/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.servicecatalog.model.AccountIdsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListPortfolioAccessResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListPortfolioAccessResponse> {
    private final List<String> accountIds;
    private final String nextPageToken;

    private ListPortfolioAccessResponse(BuilderImpl builder) {
        this.accountIds = builder.accountIds;
        this.nextPageToken = builder.nextPageToken;
    }

    public List<String> accountIds() {
        return this.accountIds;
    }

    public String nextPageToken() {
        return this.nextPageToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.accountIds() == null ? 0 : this.accountIds().hashCode());
        hashCode = 31 * hashCode + (this.nextPageToken() == null ? 0 : this.nextPageToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPortfolioAccessResponse)) {
            return false;
        }
        ListPortfolioAccessResponse other = (ListPortfolioAccessResponse)((Object)obj);
        if (other.accountIds() == null ^ this.accountIds() == null) {
            return false;
        }
        if (other.accountIds() != null && !other.accountIds().equals(this.accountIds())) {
            return false;
        }
        if (other.nextPageToken() == null ^ this.nextPageToken() == null) {
            return false;
        }
        return other.nextPageToken() == null || other.nextPageToken().equals(this.nextPageToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.accountIds() != null) {
            sb.append("AccountIds: ").append(this.accountIds()).append(",");
        }
        if (this.nextPageToken() != null) {
            sb.append("NextPageToken: ").append(this.nextPageToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<String> accountIds;
        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPortfolioAccessResponse model) {
            this.setAccountIds(model.accountIds);
            this.setNextPageToken(model.nextPageToken);
        }

        public final Collection<String> getAccountIds() {
            return this.accountIds;
        }

        @Override
        public final Builder accountIds(Collection<String> accountIds) {
            this.accountIds = AccountIdsCopier.copy(accountIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountIds(String ... accountIds) {
            if (this.accountIds == null) {
                this.accountIds = new ArrayList<String>(accountIds.length);
            }
            for (String e : accountIds) {
                this.accountIds.add(e);
            }
            return this;
        }

        public final void setAccountIds(Collection<String> accountIds) {
            this.accountIds = AccountIdsCopier.copy(accountIds);
        }

        @SafeVarargs
        public final void setAccountIds(String ... accountIds) {
            if (this.accountIds == null) {
                this.accountIds = new ArrayList<String>(accountIds.length);
            }
            for (String e : accountIds) {
                this.accountIds.add(e);
            }
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        public ListPortfolioAccessResponse build() {
            return new ListPortfolioAccessResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListPortfolioAccessResponse> {
        public Builder accountIds(Collection<String> var1);

        public Builder accountIds(String ... var1);

        public Builder nextPageToken(String var1);
    }
}

