/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.servicecatalog.model.PortfolioDetail;
import software.amazon.awssdk.services.servicecatalog.model.PortfolioDetailsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListAcceptedPortfolioSharesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListAcceptedPortfolioSharesResponse> {
    private final List<PortfolioDetail> portfolioDetails;
    private final String nextPageToken;

    private ListAcceptedPortfolioSharesResponse(BuilderImpl builder) {
        this.portfolioDetails = builder.portfolioDetails;
        this.nextPageToken = builder.nextPageToken;
    }

    public List<PortfolioDetail> portfolioDetails() {
        return this.portfolioDetails;
    }

    public String nextPageToken() {
        return this.nextPageToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.portfolioDetails() == null ? 0 : this.portfolioDetails().hashCode());
        hashCode = 31 * hashCode + (this.nextPageToken() == null ? 0 : this.nextPageToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAcceptedPortfolioSharesResponse)) {
            return false;
        }
        ListAcceptedPortfolioSharesResponse other = (ListAcceptedPortfolioSharesResponse)((Object)obj);
        if (other.portfolioDetails() == null ^ this.portfolioDetails() == null) {
            return false;
        }
        if (other.portfolioDetails() != null && !other.portfolioDetails().equals(this.portfolioDetails())) {
            return false;
        }
        if (other.nextPageToken() == null ^ this.nextPageToken() == null) {
            return false;
        }
        return other.nextPageToken() == null || other.nextPageToken().equals(this.nextPageToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.portfolioDetails() != null) {
            sb.append("PortfolioDetails: ").append(this.portfolioDetails()).append(",");
        }
        if (this.nextPageToken() != null) {
            sb.append("NextPageToken: ").append(this.nextPageToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<PortfolioDetail> portfolioDetails;
        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAcceptedPortfolioSharesResponse model) {
            this.setPortfolioDetails(model.portfolioDetails);
            this.setNextPageToken(model.nextPageToken);
        }

        public final Collection<PortfolioDetail> getPortfolioDetails() {
            return this.portfolioDetails;
        }

        @Override
        public final Builder portfolioDetails(Collection<PortfolioDetail> portfolioDetails) {
            this.portfolioDetails = PortfolioDetailsCopier.copy(portfolioDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder portfolioDetails(PortfolioDetail ... portfolioDetails) {
            if (this.portfolioDetails == null) {
                this.portfolioDetails = new ArrayList<PortfolioDetail>(portfolioDetails.length);
            }
            for (PortfolioDetail e : portfolioDetails) {
                this.portfolioDetails.add(e);
            }
            return this;
        }

        public final void setPortfolioDetails(Collection<PortfolioDetail> portfolioDetails) {
            this.portfolioDetails = PortfolioDetailsCopier.copy(portfolioDetails);
        }

        @SafeVarargs
        public final void setPortfolioDetails(PortfolioDetail ... portfolioDetails) {
            if (this.portfolioDetails == null) {
                this.portfolioDetails = new ArrayList<PortfolioDetail>(portfolioDetails.length);
            }
            for (PortfolioDetail e : portfolioDetails) {
                this.portfolioDetails.add(e);
            }
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        public ListAcceptedPortfolioSharesResponse build() {
            return new ListAcceptedPortfolioSharesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListAcceptedPortfolioSharesResponse> {
        public Builder portfolioDetails(Collection<PortfolioDetail> var1);

        public Builder portfolioDetails(PortfolioDetail ... var1);

        public Builder nextPageToken(String var1);
    }
}

