/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.servicecatalog.model.PortfolioDetail;
import software.amazon.awssdk.services.servicecatalog.model.Tag;
import software.amazon.awssdk.services.servicecatalog.model.TagsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribePortfolioResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribePortfolioResponse> {
    private final PortfolioDetail portfolioDetail;
    private final List<Tag> tags;

    private DescribePortfolioResponse(BuilderImpl builder) {
        this.portfolioDetail = builder.portfolioDetail;
        this.tags = builder.tags;
    }

    public PortfolioDetail portfolioDetail() {
        return this.portfolioDetail;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.portfolioDetail() == null ? 0 : this.portfolioDetail().hashCode());
        hashCode = 31 * hashCode + (this.tags() == null ? 0 : this.tags().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePortfolioResponse)) {
            return false;
        }
        DescribePortfolioResponse other = (DescribePortfolioResponse)((Object)obj);
        if (other.portfolioDetail() == null ^ this.portfolioDetail() == null) {
            return false;
        }
        if (other.portfolioDetail() != null && !other.portfolioDetail().equals(this.portfolioDetail())) {
            return false;
        }
        if (other.tags() == null ^ this.tags() == null) {
            return false;
        }
        return other.tags() == null || other.tags().equals(this.tags());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.portfolioDetail() != null) {
            sb.append("PortfolioDetail: ").append(this.portfolioDetail()).append(",");
        }
        if (this.tags() != null) {
            sb.append("Tags: ").append(this.tags()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private PortfolioDetail portfolioDetail;
        private List<Tag> tags;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePortfolioResponse model) {
            this.setPortfolioDetail(model.portfolioDetail);
            this.setTags(model.tags);
        }

        public final PortfolioDetail getPortfolioDetail() {
            return this.portfolioDetail;
        }

        @Override
        public final Builder portfolioDetail(PortfolioDetail portfolioDetail) {
            this.portfolioDetail = portfolioDetail;
            return this;
        }

        public final void setPortfolioDetail(PortfolioDetail portfolioDetail) {
            this.portfolioDetail = portfolioDetail;
        }

        public final Collection<Tag> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            if (this.tags == null) {
                this.tags = new ArrayList<Tag>(tags.length);
            }
            for (Tag e : tags) {
                this.tags.add(e);
            }
            return this;
        }

        public final void setTags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @SafeVarargs
        public final void setTags(Tag ... tags) {
            if (this.tags == null) {
                this.tags = new ArrayList<Tag>(tags.length);
            }
            for (Tag e : tags) {
                this.tags.add(e);
            }
        }

        public DescribePortfolioResponse build() {
            return new DescribePortfolioResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribePortfolioResponse> {
        public Builder portfolioDetail(PortfolioDetail var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);
    }
}

