/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.servicecatalog.model.AddTagsCopier;
import software.amazon.awssdk.services.servicecatalog.model.Tag;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreatePortfolioRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreatePortfolioRequest> {
    private final String acceptLanguage;
    private final String displayName;
    private final String description;
    private final String providerName;
    private final List<Tag> tags;
    private final String idempotencyToken;

    private CreatePortfolioRequest(BuilderImpl builder) {
        this.acceptLanguage = builder.acceptLanguage;
        this.displayName = builder.displayName;
        this.description = builder.description;
        this.providerName = builder.providerName;
        this.tags = builder.tags;
        this.idempotencyToken = builder.idempotencyToken;
    }

    public String acceptLanguage() {
        return this.acceptLanguage;
    }

    public String displayName() {
        return this.displayName;
    }

    public String description() {
        return this.description;
    }

    public String providerName() {
        return this.providerName;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public String idempotencyToken() {
        return this.idempotencyToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.acceptLanguage() == null ? 0 : this.acceptLanguage().hashCode());
        hashCode = 31 * hashCode + (this.displayName() == null ? 0 : this.displayName().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        hashCode = 31 * hashCode + (this.providerName() == null ? 0 : this.providerName().hashCode());
        hashCode = 31 * hashCode + (this.tags() == null ? 0 : this.tags().hashCode());
        hashCode = 31 * hashCode + (this.idempotencyToken() == null ? 0 : this.idempotencyToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePortfolioRequest)) {
            return false;
        }
        CreatePortfolioRequest other = (CreatePortfolioRequest)((Object)obj);
        if (other.acceptLanguage() == null ^ this.acceptLanguage() == null) {
            return false;
        }
        if (other.acceptLanguage() != null && !other.acceptLanguage().equals(this.acceptLanguage())) {
            return false;
        }
        if (other.displayName() == null ^ this.displayName() == null) {
            return false;
        }
        if (other.displayName() != null && !other.displayName().equals(this.displayName())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.providerName() == null ^ this.providerName() == null) {
            return false;
        }
        if (other.providerName() != null && !other.providerName().equals(this.providerName())) {
            return false;
        }
        if (other.tags() == null ^ this.tags() == null) {
            return false;
        }
        if (other.tags() != null && !other.tags().equals(this.tags())) {
            return false;
        }
        if (other.idempotencyToken() == null ^ this.idempotencyToken() == null) {
            return false;
        }
        return other.idempotencyToken() == null || other.idempotencyToken().equals(this.idempotencyToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.acceptLanguage() != null) {
            sb.append("AcceptLanguage: ").append(this.acceptLanguage()).append(",");
        }
        if (this.displayName() != null) {
            sb.append("DisplayName: ").append(this.displayName()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.providerName() != null) {
            sb.append("ProviderName: ").append(this.providerName()).append(",");
        }
        if (this.tags() != null) {
            sb.append("Tags: ").append(this.tags()).append(",");
        }
        if (this.idempotencyToken() != null) {
            sb.append("IdempotencyToken: ").append(this.idempotencyToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String acceptLanguage;
        private String displayName;
        private String description;
        private String providerName;
        private List<Tag> tags;
        private String idempotencyToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePortfolioRequest model) {
            this.setAcceptLanguage(model.acceptLanguage);
            this.setDisplayName(model.displayName);
            this.setDescription(model.description);
            this.setProviderName(model.providerName);
            this.setTags(model.tags);
            this.setIdempotencyToken(model.idempotencyToken);
        }

        public final String getAcceptLanguage() {
            return this.acceptLanguage;
        }

        @Override
        public final Builder acceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
            return this;
        }

        public final void setAcceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getProviderName() {
            return this.providerName;
        }

        @Override
        public final Builder providerName(String providerName) {
            this.providerName = providerName;
            return this;
        }

        public final void setProviderName(String providerName) {
            this.providerName = providerName;
        }

        public final Collection<Tag> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = AddTagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            if (this.tags == null) {
                this.tags = new ArrayList<Tag>(tags.length);
            }
            for (Tag e : tags) {
                this.tags.add(e);
            }
            return this;
        }

        public final void setTags(Collection<Tag> tags) {
            this.tags = AddTagsCopier.copy(tags);
        }

        @SafeVarargs
        public final void setTags(Tag ... tags) {
            if (this.tags == null) {
                this.tags = new ArrayList<Tag>(tags.length);
            }
            for (Tag e : tags) {
                this.tags.add(e);
            }
        }

        public final String getIdempotencyToken() {
            return this.idempotencyToken;
        }

        @Override
        public final Builder idempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
            return this;
        }

        public final void setIdempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
        }

        public CreatePortfolioRequest build() {
            return new CreatePortfolioRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreatePortfolioRequest> {
        public Builder acceptLanguage(String var1);

        public Builder displayName(String var1);

        public Builder description(String var1);

        public Builder providerName(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder idempotencyToken(String var1);
    }
}

