/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog;

import software.amazon.awssdk.AmazonServiceException;
import software.amazon.awssdk.SdkBaseException;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.client.AwsSyncClientParams;
import software.amazon.awssdk.client.ClientExecutionParams;
import software.amazon.awssdk.client.ClientHandler;
import software.amazon.awssdk.client.ClientHandlerParams;
import software.amazon.awssdk.client.SdkClientHandler;
import software.amazon.awssdk.http.HttpResponseHandler;
import software.amazon.awssdk.protocol.json.JsonClientMetadata;
import software.amazon.awssdk.protocol.json.JsonErrorResponseMetadata;
import software.amazon.awssdk.protocol.json.JsonErrorShapeMetadata;
import software.amazon.awssdk.protocol.json.JsonOperationMetadata;
import software.amazon.awssdk.protocol.json.SdkJsonProtocolFactory;
import software.amazon.awssdk.runtime.http.response.JsonResponseHandler;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.servicecatalog.ServiceCatalogClient;
import software.amazon.awssdk.services.servicecatalog.model.AcceptPortfolioShareRequest;
import software.amazon.awssdk.services.servicecatalog.model.AcceptPortfolioShareResponse;
import software.amazon.awssdk.services.servicecatalog.model.AssociatePrincipalWithPortfolioRequest;
import software.amazon.awssdk.services.servicecatalog.model.AssociatePrincipalWithPortfolioResponse;
import software.amazon.awssdk.services.servicecatalog.model.AssociateProductWithPortfolioRequest;
import software.amazon.awssdk.services.servicecatalog.model.AssociateProductWithPortfolioResponse;
import software.amazon.awssdk.services.servicecatalog.model.CreateConstraintRequest;
import software.amazon.awssdk.services.servicecatalog.model.CreateConstraintResponse;
import software.amazon.awssdk.services.servicecatalog.model.CreatePortfolioRequest;
import software.amazon.awssdk.services.servicecatalog.model.CreatePortfolioResponse;
import software.amazon.awssdk.services.servicecatalog.model.CreatePortfolioShareRequest;
import software.amazon.awssdk.services.servicecatalog.model.CreatePortfolioShareResponse;
import software.amazon.awssdk.services.servicecatalog.model.CreateProductRequest;
import software.amazon.awssdk.services.servicecatalog.model.CreateProductResponse;
import software.amazon.awssdk.services.servicecatalog.model.CreateProvisioningArtifactRequest;
import software.amazon.awssdk.services.servicecatalog.model.CreateProvisioningArtifactResponse;
import software.amazon.awssdk.services.servicecatalog.model.DeleteConstraintRequest;
import software.amazon.awssdk.services.servicecatalog.model.DeleteConstraintResponse;
import software.amazon.awssdk.services.servicecatalog.model.DeletePortfolioRequest;
import software.amazon.awssdk.services.servicecatalog.model.DeletePortfolioResponse;
import software.amazon.awssdk.services.servicecatalog.model.DeletePortfolioShareRequest;
import software.amazon.awssdk.services.servicecatalog.model.DeletePortfolioShareResponse;
import software.amazon.awssdk.services.servicecatalog.model.DeleteProductRequest;
import software.amazon.awssdk.services.servicecatalog.model.DeleteProductResponse;
import software.amazon.awssdk.services.servicecatalog.model.DeleteProvisioningArtifactRequest;
import software.amazon.awssdk.services.servicecatalog.model.DeleteProvisioningArtifactResponse;
import software.amazon.awssdk.services.servicecatalog.model.DescribeConstraintRequest;
import software.amazon.awssdk.services.servicecatalog.model.DescribeConstraintResponse;
import software.amazon.awssdk.services.servicecatalog.model.DescribePortfolioRequest;
import software.amazon.awssdk.services.servicecatalog.model.DescribePortfolioResponse;
import software.amazon.awssdk.services.servicecatalog.model.DescribeProductAsAdminRequest;
import software.amazon.awssdk.services.servicecatalog.model.DescribeProductAsAdminResponse;
import software.amazon.awssdk.services.servicecatalog.model.DescribeProductRequest;
import software.amazon.awssdk.services.servicecatalog.model.DescribeProductResponse;
import software.amazon.awssdk.services.servicecatalog.model.DescribeProductViewRequest;
import software.amazon.awssdk.services.servicecatalog.model.DescribeProductViewResponse;
import software.amazon.awssdk.services.servicecatalog.model.DescribeProvisionedProductRequest;
import software.amazon.awssdk.services.servicecatalog.model.DescribeProvisionedProductResponse;
import software.amazon.awssdk.services.servicecatalog.model.DescribeProvisioningArtifactRequest;
import software.amazon.awssdk.services.servicecatalog.model.DescribeProvisioningArtifactResponse;
import software.amazon.awssdk.services.servicecatalog.model.DescribeProvisioningParametersRequest;
import software.amazon.awssdk.services.servicecatalog.model.DescribeProvisioningParametersResponse;
import software.amazon.awssdk.services.servicecatalog.model.DescribeRecordRequest;
import software.amazon.awssdk.services.servicecatalog.model.DescribeRecordResponse;
import software.amazon.awssdk.services.servicecatalog.model.DisassociatePrincipalFromPortfolioRequest;
import software.amazon.awssdk.services.servicecatalog.model.DisassociatePrincipalFromPortfolioResponse;
import software.amazon.awssdk.services.servicecatalog.model.DisassociateProductFromPortfolioRequest;
import software.amazon.awssdk.services.servicecatalog.model.DisassociateProductFromPortfolioResponse;
import software.amazon.awssdk.services.servicecatalog.model.DuplicateResourceException;
import software.amazon.awssdk.services.servicecatalog.model.InvalidParametersException;
import software.amazon.awssdk.services.servicecatalog.model.LimitExceededException;
import software.amazon.awssdk.services.servicecatalog.model.ListAcceptedPortfolioSharesRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListAcceptedPortfolioSharesResponse;
import software.amazon.awssdk.services.servicecatalog.model.ListConstraintsForPortfolioRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListConstraintsForPortfolioResponse;
import software.amazon.awssdk.services.servicecatalog.model.ListLaunchPathsRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListLaunchPathsResponse;
import software.amazon.awssdk.services.servicecatalog.model.ListPortfolioAccessRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListPortfolioAccessResponse;
import software.amazon.awssdk.services.servicecatalog.model.ListPortfoliosForProductRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListPortfoliosForProductResponse;
import software.amazon.awssdk.services.servicecatalog.model.ListPortfoliosRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListPortfoliosResponse;
import software.amazon.awssdk.services.servicecatalog.model.ListPrincipalsForPortfolioRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListPrincipalsForPortfolioResponse;
import software.amazon.awssdk.services.servicecatalog.model.ListProvisioningArtifactsRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListProvisioningArtifactsResponse;
import software.amazon.awssdk.services.servicecatalog.model.ListRecordHistoryRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListRecordHistoryResponse;
import software.amazon.awssdk.services.servicecatalog.model.ProvisionProductRequest;
import software.amazon.awssdk.services.servicecatalog.model.ProvisionProductResponse;
import software.amazon.awssdk.services.servicecatalog.model.RejectPortfolioShareRequest;
import software.amazon.awssdk.services.servicecatalog.model.RejectPortfolioShareResponse;
import software.amazon.awssdk.services.servicecatalog.model.ResourceInUseException;
import software.amazon.awssdk.services.servicecatalog.model.ResourceNotFoundException;
import software.amazon.awssdk.services.servicecatalog.model.ScanProvisionedProductsRequest;
import software.amazon.awssdk.services.servicecatalog.model.ScanProvisionedProductsResponse;
import software.amazon.awssdk.services.servicecatalog.model.SearchProductsAsAdminRequest;
import software.amazon.awssdk.services.servicecatalog.model.SearchProductsAsAdminResponse;
import software.amazon.awssdk.services.servicecatalog.model.SearchProductsRequest;
import software.amazon.awssdk.services.servicecatalog.model.SearchProductsResponse;
import software.amazon.awssdk.services.servicecatalog.model.ServiceCatalogException;
import software.amazon.awssdk.services.servicecatalog.model.TerminateProvisionedProductRequest;
import software.amazon.awssdk.services.servicecatalog.model.TerminateProvisionedProductResponse;
import software.amazon.awssdk.services.servicecatalog.model.UpdateConstraintRequest;
import software.amazon.awssdk.services.servicecatalog.model.UpdateConstraintResponse;
import software.amazon.awssdk.services.servicecatalog.model.UpdatePortfolioRequest;
import software.amazon.awssdk.services.servicecatalog.model.UpdatePortfolioResponse;
import software.amazon.awssdk.services.servicecatalog.model.UpdateProductRequest;
import software.amazon.awssdk.services.servicecatalog.model.UpdateProductResponse;
import software.amazon.awssdk.services.servicecatalog.model.UpdateProvisionedProductRequest;
import software.amazon.awssdk.services.servicecatalog.model.UpdateProvisionedProductResponse;
import software.amazon.awssdk.services.servicecatalog.model.UpdateProvisioningArtifactRequest;
import software.amazon.awssdk.services.servicecatalog.model.UpdateProvisioningArtifactResponse;
import software.amazon.awssdk.services.servicecatalog.transform.AcceptPortfolioShareRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.AcceptPortfolioShareResponseUnmarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.AssociatePrincipalWithPortfolioRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.AssociatePrincipalWithPortfolioResponseUnmarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.AssociateProductWithPortfolioRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.AssociateProductWithPortfolioResponseUnmarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.CreateConstraintRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.CreateConstraintResponseUnmarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.CreatePortfolioRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.CreatePortfolioResponseUnmarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.CreatePortfolioShareRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.CreatePortfolioShareResponseUnmarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.CreateProductRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.CreateProductResponseUnmarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.CreateProvisioningArtifactRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.CreateProvisioningArtifactResponseUnmarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.DeleteConstraintRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.DeleteConstraintResponseUnmarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.DeletePortfolioRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.DeletePortfolioResponseUnmarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.DeletePortfolioShareRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.DeletePortfolioShareResponseUnmarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.DeleteProductRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.DeleteProductResponseUnmarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.DeleteProvisioningArtifactRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.DeleteProvisioningArtifactResponseUnmarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.DescribeConstraintRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.DescribeConstraintResponseUnmarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.DescribePortfolioRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.DescribePortfolioResponseUnmarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.DescribeProductAsAdminRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.DescribeProductAsAdminResponseUnmarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.DescribeProductRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.DescribeProductResponseUnmarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.DescribeProductViewRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.DescribeProductViewResponseUnmarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.DescribeProvisionedProductRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.DescribeProvisionedProductResponseUnmarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.DescribeProvisioningArtifactRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.DescribeProvisioningArtifactResponseUnmarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.DescribeProvisioningParametersRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.DescribeProvisioningParametersResponseUnmarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.DescribeRecordRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.DescribeRecordResponseUnmarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.DisassociatePrincipalFromPortfolioRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.DisassociatePrincipalFromPortfolioResponseUnmarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.DisassociateProductFromPortfolioRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.DisassociateProductFromPortfolioResponseUnmarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.ListAcceptedPortfolioSharesRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.ListAcceptedPortfolioSharesResponseUnmarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.ListConstraintsForPortfolioRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.ListConstraintsForPortfolioResponseUnmarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.ListLaunchPathsRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.ListLaunchPathsResponseUnmarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.ListPortfolioAccessRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.ListPortfolioAccessResponseUnmarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.ListPortfoliosForProductRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.ListPortfoliosForProductResponseUnmarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.ListPortfoliosRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.ListPortfoliosResponseUnmarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.ListPrincipalsForPortfolioRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.ListPrincipalsForPortfolioResponseUnmarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.ListProvisioningArtifactsRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.ListProvisioningArtifactsResponseUnmarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.ListRecordHistoryRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.ListRecordHistoryResponseUnmarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.ProvisionProductRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.ProvisionProductResponseUnmarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.RejectPortfolioShareRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.RejectPortfolioShareResponseUnmarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.ScanProvisionedProductsRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.ScanProvisionedProductsResponseUnmarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.SearchProductsAsAdminRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.SearchProductsAsAdminResponseUnmarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.SearchProductsRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.SearchProductsResponseUnmarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.TerminateProvisionedProductRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.TerminateProvisionedProductResponseUnmarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.UpdateConstraintRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.UpdateConstraintResponseUnmarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.UpdatePortfolioRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.UpdatePortfolioResponseUnmarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.UpdateProductRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.UpdateProductResponseUnmarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.UpdateProvisionedProductRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.UpdateProvisionedProductResponseUnmarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.UpdateProvisioningArtifactRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.UpdateProvisioningArtifactResponseUnmarshaller;

@SdkInternalApi
final class DefaultServiceCatalogClient
implements ServiceCatalogClient {
    private final ClientHandler clientHandler;
    private final SdkJsonProtocolFactory protocolFactory;
    private final AwsSyncClientParams clientParams;

    protected DefaultServiceCatalogClient(AwsSyncClientParams clientParams) {
        this.clientHandler = new SdkClientHandler(new ClientHandlerParams().withClientParams(clientParams).withCalculateCrc32FromCompressedDataEnabled(false));
        this.clientParams = clientParams;
        this.protocolFactory = this.init();
    }

    @Override
    public AcceptPortfolioShareResponse acceptPortfolioShare(AcceptPortfolioShareRequest acceptPortfolioShareRequest) throws InvalidParametersException, ResourceNotFoundException, LimitExceededException, SdkBaseException, SdkClientException, ServiceCatalogException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new AcceptPortfolioShareResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (AcceptPortfolioShareResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)acceptPortfolioShareRequest).withMarshaller((Marshaller)new AcceptPortfolioShareRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public AssociatePrincipalWithPortfolioResponse associatePrincipalWithPortfolio(AssociatePrincipalWithPortfolioRequest associatePrincipalWithPortfolioRequest) throws InvalidParametersException, ResourceNotFoundException, LimitExceededException, SdkBaseException, SdkClientException, ServiceCatalogException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new AssociatePrincipalWithPortfolioResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (AssociatePrincipalWithPortfolioResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)associatePrincipalWithPortfolioRequest).withMarshaller((Marshaller)new AssociatePrincipalWithPortfolioRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public AssociateProductWithPortfolioResponse associateProductWithPortfolio(AssociateProductWithPortfolioRequest associateProductWithPortfolioRequest) throws InvalidParametersException, ResourceNotFoundException, LimitExceededException, SdkBaseException, SdkClientException, ServiceCatalogException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new AssociateProductWithPortfolioResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (AssociateProductWithPortfolioResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)associateProductWithPortfolioRequest).withMarshaller((Marshaller)new AssociateProductWithPortfolioRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public CreateConstraintResponse createConstraint(CreateConstraintRequest createConstraintRequest) throws ResourceNotFoundException, InvalidParametersException, LimitExceededException, DuplicateResourceException, SdkBaseException, SdkClientException, ServiceCatalogException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new CreateConstraintResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (CreateConstraintResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)createConstraintRequest).withMarshaller((Marshaller)new CreateConstraintRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public CreatePortfolioResponse createPortfolio(CreatePortfolioRequest createPortfolioRequest) throws InvalidParametersException, LimitExceededException, SdkBaseException, SdkClientException, ServiceCatalogException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new CreatePortfolioResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (CreatePortfolioResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)createPortfolioRequest).withMarshaller((Marshaller)new CreatePortfolioRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public CreatePortfolioShareResponse createPortfolioShare(CreatePortfolioShareRequest createPortfolioShareRequest) throws ResourceNotFoundException, LimitExceededException, InvalidParametersException, SdkBaseException, SdkClientException, ServiceCatalogException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new CreatePortfolioShareResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (CreatePortfolioShareResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)createPortfolioShareRequest).withMarshaller((Marshaller)new CreatePortfolioShareRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public CreateProductResponse createProduct(CreateProductRequest createProductRequest) throws InvalidParametersException, LimitExceededException, SdkBaseException, SdkClientException, ServiceCatalogException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new CreateProductResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (CreateProductResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)createProductRequest).withMarshaller((Marshaller)new CreateProductRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public CreateProvisioningArtifactResponse createProvisioningArtifact(CreateProvisioningArtifactRequest createProvisioningArtifactRequest) throws ResourceNotFoundException, InvalidParametersException, LimitExceededException, SdkBaseException, SdkClientException, ServiceCatalogException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new CreateProvisioningArtifactResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (CreateProvisioningArtifactResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)createProvisioningArtifactRequest).withMarshaller((Marshaller)new CreateProvisioningArtifactRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public DeleteConstraintResponse deleteConstraint(DeleteConstraintRequest deleteConstraintRequest) throws ResourceNotFoundException, InvalidParametersException, SdkBaseException, SdkClientException, ServiceCatalogException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new DeleteConstraintResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DeleteConstraintResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)deleteConstraintRequest).withMarshaller((Marshaller)new DeleteConstraintRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public DeletePortfolioResponse deletePortfolio(DeletePortfolioRequest deletePortfolioRequest) throws ResourceNotFoundException, InvalidParametersException, ResourceInUseException, SdkBaseException, SdkClientException, ServiceCatalogException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new DeletePortfolioResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DeletePortfolioResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)deletePortfolioRequest).withMarshaller((Marshaller)new DeletePortfolioRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public DeletePortfolioShareResponse deletePortfolioShare(DeletePortfolioShareRequest deletePortfolioShareRequest) throws ResourceNotFoundException, SdkBaseException, SdkClientException, ServiceCatalogException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new DeletePortfolioShareResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DeletePortfolioShareResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)deletePortfolioShareRequest).withMarshaller((Marshaller)new DeletePortfolioShareRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public DeleteProductResponse deleteProduct(DeleteProductRequest deleteProductRequest) throws ResourceNotFoundException, ResourceInUseException, InvalidParametersException, SdkBaseException, SdkClientException, ServiceCatalogException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new DeleteProductResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DeleteProductResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)deleteProductRequest).withMarshaller((Marshaller)new DeleteProductRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public DeleteProvisioningArtifactResponse deleteProvisioningArtifact(DeleteProvisioningArtifactRequest deleteProvisioningArtifactRequest) throws ResourceNotFoundException, ResourceInUseException, InvalidParametersException, SdkBaseException, SdkClientException, ServiceCatalogException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new DeleteProvisioningArtifactResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DeleteProvisioningArtifactResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)deleteProvisioningArtifactRequest).withMarshaller((Marshaller)new DeleteProvisioningArtifactRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public DescribeConstraintResponse describeConstraint(DescribeConstraintRequest describeConstraintRequest) throws ResourceNotFoundException, SdkBaseException, SdkClientException, ServiceCatalogException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new DescribeConstraintResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DescribeConstraintResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)describeConstraintRequest).withMarshaller((Marshaller)new DescribeConstraintRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public DescribePortfolioResponse describePortfolio(DescribePortfolioRequest describePortfolioRequest) throws ResourceNotFoundException, SdkBaseException, SdkClientException, ServiceCatalogException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new DescribePortfolioResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DescribePortfolioResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)describePortfolioRequest).withMarshaller((Marshaller)new DescribePortfolioRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public DescribeProductResponse describeProduct(DescribeProductRequest describeProductRequest) throws ResourceNotFoundException, InvalidParametersException, SdkBaseException, SdkClientException, ServiceCatalogException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new DescribeProductResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DescribeProductResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)describeProductRequest).withMarshaller((Marshaller)new DescribeProductRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public DescribeProductAsAdminResponse describeProductAsAdmin(DescribeProductAsAdminRequest describeProductAsAdminRequest) throws ResourceNotFoundException, SdkBaseException, SdkClientException, ServiceCatalogException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new DescribeProductAsAdminResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DescribeProductAsAdminResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)describeProductAsAdminRequest).withMarshaller((Marshaller)new DescribeProductAsAdminRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public DescribeProductViewResponse describeProductView(DescribeProductViewRequest describeProductViewRequest) throws ResourceNotFoundException, InvalidParametersException, SdkBaseException, SdkClientException, ServiceCatalogException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new DescribeProductViewResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DescribeProductViewResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)describeProductViewRequest).withMarshaller((Marshaller)new DescribeProductViewRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public DescribeProvisionedProductResponse describeProvisionedProduct(DescribeProvisionedProductRequest describeProvisionedProductRequest) throws ResourceNotFoundException, SdkBaseException, SdkClientException, ServiceCatalogException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new DescribeProvisionedProductResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DescribeProvisionedProductResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)describeProvisionedProductRequest).withMarshaller((Marshaller)new DescribeProvisionedProductRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public DescribeProvisioningArtifactResponse describeProvisioningArtifact(DescribeProvisioningArtifactRequest describeProvisioningArtifactRequest) throws ResourceNotFoundException, SdkBaseException, SdkClientException, ServiceCatalogException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new DescribeProvisioningArtifactResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DescribeProvisioningArtifactResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)describeProvisioningArtifactRequest).withMarshaller((Marshaller)new DescribeProvisioningArtifactRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public DescribeProvisioningParametersResponse describeProvisioningParameters(DescribeProvisioningParametersRequest describeProvisioningParametersRequest) throws InvalidParametersException, ResourceNotFoundException, SdkBaseException, SdkClientException, ServiceCatalogException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new DescribeProvisioningParametersResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DescribeProvisioningParametersResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)describeProvisioningParametersRequest).withMarshaller((Marshaller)new DescribeProvisioningParametersRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public DescribeRecordResponse describeRecord(DescribeRecordRequest describeRecordRequest) throws ResourceNotFoundException, SdkBaseException, SdkClientException, ServiceCatalogException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new DescribeRecordResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DescribeRecordResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)describeRecordRequest).withMarshaller((Marshaller)new DescribeRecordRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public DisassociatePrincipalFromPortfolioResponse disassociatePrincipalFromPortfolio(DisassociatePrincipalFromPortfolioRequest disassociatePrincipalFromPortfolioRequest) throws InvalidParametersException, ResourceNotFoundException, SdkBaseException, SdkClientException, ServiceCatalogException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new DisassociatePrincipalFromPortfolioResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DisassociatePrincipalFromPortfolioResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)disassociatePrincipalFromPortfolioRequest).withMarshaller((Marshaller)new DisassociatePrincipalFromPortfolioRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public DisassociateProductFromPortfolioResponse disassociateProductFromPortfolio(DisassociateProductFromPortfolioRequest disassociateProductFromPortfolioRequest) throws ResourceNotFoundException, InvalidParametersException, SdkBaseException, SdkClientException, ServiceCatalogException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new DisassociateProductFromPortfolioResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DisassociateProductFromPortfolioResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)disassociateProductFromPortfolioRequest).withMarshaller((Marshaller)new DisassociateProductFromPortfolioRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public ListAcceptedPortfolioSharesResponse listAcceptedPortfolioShares(ListAcceptedPortfolioSharesRequest listAcceptedPortfolioSharesRequest) throws InvalidParametersException, SdkBaseException, SdkClientException, ServiceCatalogException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new ListAcceptedPortfolioSharesResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (ListAcceptedPortfolioSharesResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)listAcceptedPortfolioSharesRequest).withMarshaller((Marshaller)new ListAcceptedPortfolioSharesRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public ListConstraintsForPortfolioResponse listConstraintsForPortfolio(ListConstraintsForPortfolioRequest listConstraintsForPortfolioRequest) throws ResourceNotFoundException, InvalidParametersException, SdkBaseException, SdkClientException, ServiceCatalogException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new ListConstraintsForPortfolioResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (ListConstraintsForPortfolioResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)listConstraintsForPortfolioRequest).withMarshaller((Marshaller)new ListConstraintsForPortfolioRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public ListLaunchPathsResponse listLaunchPaths(ListLaunchPathsRequest listLaunchPathsRequest) throws InvalidParametersException, ResourceNotFoundException, SdkBaseException, SdkClientException, ServiceCatalogException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new ListLaunchPathsResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (ListLaunchPathsResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)listLaunchPathsRequest).withMarshaller((Marshaller)new ListLaunchPathsRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public ListPortfolioAccessResponse listPortfolioAccess(ListPortfolioAccessRequest listPortfolioAccessRequest) throws ResourceNotFoundException, SdkBaseException, SdkClientException, ServiceCatalogException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new ListPortfolioAccessResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (ListPortfolioAccessResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)listPortfolioAccessRequest).withMarshaller((Marshaller)new ListPortfolioAccessRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public ListPortfoliosResponse listPortfolios(ListPortfoliosRequest listPortfoliosRequest) throws InvalidParametersException, SdkBaseException, SdkClientException, ServiceCatalogException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new ListPortfoliosResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (ListPortfoliosResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)listPortfoliosRequest).withMarshaller((Marshaller)new ListPortfoliosRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public ListPortfoliosForProductResponse listPortfoliosForProduct(ListPortfoliosForProductRequest listPortfoliosForProductRequest) throws InvalidParametersException, ResourceNotFoundException, SdkBaseException, SdkClientException, ServiceCatalogException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new ListPortfoliosForProductResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (ListPortfoliosForProductResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)listPortfoliosForProductRequest).withMarshaller((Marshaller)new ListPortfoliosForProductRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public ListPrincipalsForPortfolioResponse listPrincipalsForPortfolio(ListPrincipalsForPortfolioRequest listPrincipalsForPortfolioRequest) throws ResourceNotFoundException, InvalidParametersException, SdkBaseException, SdkClientException, ServiceCatalogException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new ListPrincipalsForPortfolioResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (ListPrincipalsForPortfolioResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)listPrincipalsForPortfolioRequest).withMarshaller((Marshaller)new ListPrincipalsForPortfolioRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public ListProvisioningArtifactsResponse listProvisioningArtifacts(ListProvisioningArtifactsRequest listProvisioningArtifactsRequest) throws ResourceNotFoundException, InvalidParametersException, SdkBaseException, SdkClientException, ServiceCatalogException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new ListProvisioningArtifactsResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (ListProvisioningArtifactsResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)listProvisioningArtifactsRequest).withMarshaller((Marshaller)new ListProvisioningArtifactsRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public ListRecordHistoryResponse listRecordHistory(ListRecordHistoryRequest listRecordHistoryRequest) throws InvalidParametersException, SdkBaseException, SdkClientException, ServiceCatalogException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new ListRecordHistoryResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (ListRecordHistoryResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)listRecordHistoryRequest).withMarshaller((Marshaller)new ListRecordHistoryRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public ProvisionProductResponse provisionProduct(ProvisionProductRequest provisionProductRequest) throws InvalidParametersException, ResourceNotFoundException, DuplicateResourceException, SdkBaseException, SdkClientException, ServiceCatalogException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new ProvisionProductResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (ProvisionProductResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)provisionProductRequest).withMarshaller((Marshaller)new ProvisionProductRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public RejectPortfolioShareResponse rejectPortfolioShare(RejectPortfolioShareRequest rejectPortfolioShareRequest) throws ResourceNotFoundException, SdkBaseException, SdkClientException, ServiceCatalogException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new RejectPortfolioShareResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (RejectPortfolioShareResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)rejectPortfolioShareRequest).withMarshaller((Marshaller)new RejectPortfolioShareRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public ScanProvisionedProductsResponse scanProvisionedProducts(ScanProvisionedProductsRequest scanProvisionedProductsRequest) throws InvalidParametersException, SdkBaseException, SdkClientException, ServiceCatalogException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new ScanProvisionedProductsResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (ScanProvisionedProductsResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)scanProvisionedProductsRequest).withMarshaller((Marshaller)new ScanProvisionedProductsRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public SearchProductsResponse searchProducts(SearchProductsRequest searchProductsRequest) throws InvalidParametersException, SdkBaseException, SdkClientException, ServiceCatalogException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new SearchProductsResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (SearchProductsResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)searchProductsRequest).withMarshaller((Marshaller)new SearchProductsRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public SearchProductsAsAdminResponse searchProductsAsAdmin(SearchProductsAsAdminRequest searchProductsAsAdminRequest) throws ResourceNotFoundException, InvalidParametersException, SdkBaseException, SdkClientException, ServiceCatalogException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new SearchProductsAsAdminResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (SearchProductsAsAdminResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)searchProductsAsAdminRequest).withMarshaller((Marshaller)new SearchProductsAsAdminRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public TerminateProvisionedProductResponse terminateProvisionedProduct(TerminateProvisionedProductRequest terminateProvisionedProductRequest) throws ResourceNotFoundException, SdkBaseException, SdkClientException, ServiceCatalogException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new TerminateProvisionedProductResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (TerminateProvisionedProductResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)terminateProvisionedProductRequest).withMarshaller((Marshaller)new TerminateProvisionedProductRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public UpdateConstraintResponse updateConstraint(UpdateConstraintRequest updateConstraintRequest) throws ResourceNotFoundException, InvalidParametersException, SdkBaseException, SdkClientException, ServiceCatalogException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new UpdateConstraintResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (UpdateConstraintResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)updateConstraintRequest).withMarshaller((Marshaller)new UpdateConstraintRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public UpdatePortfolioResponse updatePortfolio(UpdatePortfolioRequest updatePortfolioRequest) throws InvalidParametersException, ResourceNotFoundException, LimitExceededException, SdkBaseException, SdkClientException, ServiceCatalogException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new UpdatePortfolioResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (UpdatePortfolioResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)updatePortfolioRequest).withMarshaller((Marshaller)new UpdatePortfolioRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public UpdateProductResponse updateProduct(UpdateProductRequest updateProductRequest) throws ResourceNotFoundException, InvalidParametersException, SdkBaseException, SdkClientException, ServiceCatalogException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new UpdateProductResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (UpdateProductResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)updateProductRequest).withMarshaller((Marshaller)new UpdateProductRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public UpdateProvisionedProductResponse updateProvisionedProduct(UpdateProvisionedProductRequest updateProvisionedProductRequest) throws InvalidParametersException, ResourceNotFoundException, SdkBaseException, SdkClientException, ServiceCatalogException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new UpdateProvisionedProductResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (UpdateProvisionedProductResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)updateProvisionedProductRequest).withMarshaller((Marshaller)new UpdateProvisionedProductRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public UpdateProvisioningArtifactResponse updateProvisioningArtifact(UpdateProvisioningArtifactRequest updateProvisioningArtifactRequest) throws ResourceNotFoundException, InvalidParametersException, SdkBaseException, SdkClientException, ServiceCatalogException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new UpdateProvisioningArtifactResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (UpdateProvisioningArtifactResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)updateProvisioningArtifactRequest).withMarshaller((Marshaller)new UpdateProvisioningArtifactRequestMarshaller(this.protocolFactory))));
    }

    private HttpResponseHandler<AmazonServiceException> createErrorResponseHandler() {
        return this.protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
    }

    private SdkJsonProtocolFactory init() {
        return new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withBaseServiceExceptionClass(ServiceCatalogException.class).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceInUseException").withModeledClass(ResourceInUseException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidParametersException").withModeledClass(InvalidParametersException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("DuplicateResourceException").withModeledClass(DuplicateResourceException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LimitExceededException").withModeledClass(LimitExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withModeledClass(ResourceNotFoundException.class)));
    }

    @Override
    public void close() throws Exception {
        this.clientHandler.close();
    }
}

