/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.testutils.service;

import java.io.IOException;
import java.io.InputStream;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.junit.Assert;
import software.amazon.awssdk.core.AmazonServiceException;
import software.amazon.awssdk.core.auth.AwsCredentialsProvider;
import software.amazon.awssdk.core.auth.AwsCredentialsProviderChain;
import software.amazon.awssdk.core.auth.EnvironmentVariableCredentialsProvider;
import software.amazon.awssdk.core.auth.ProfileCredentialsProvider;
import software.amazon.awssdk.core.auth.SystemPropertyCredentialsProvider;
import software.amazon.awssdk.utils.IoUtils;
import software.amazon.awssdk.utils.StringUtils;

public abstract class AwsTestBase {
    private static final String TEST_CREDENTIALS_PROFILE_NAME = "aws-test-account";
    public static final AwsCredentialsProviderChain CREDENTIALS_PROVIDER_CHAIN = AwsCredentialsProviderChain.builder().credentialsProviders(new AwsCredentialsProvider[]{ProfileCredentialsProvider.builder().profileName("aws-test-account").build(), SystemPropertyCredentialsProvider.create(), EnvironmentVariableCredentialsProvider.create()}).build();

    @Deprecated
    public static void setUpCredentials() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String getResourceAsString(Class<?> clazz, String location) {
        try (InputStream resourceStream = clazz.getResourceAsStream(location);){
            String string = IoUtils.toString((InputStream)resourceStream);
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    protected void assertValidException(AmazonServiceException e) {
        Assert.assertThat((Object)e, AwsTestBase.isValidAmazonServiceException());
    }

    public static Matcher<AmazonServiceException> isValidAmazonServiceException() {
        return new TypeSafeMatcher<AmazonServiceException>(){
            private StringBuilder sb = new StringBuilder();

            protected boolean matchesSafely(AmazonServiceException item) {
                this.isNotBlank(item.getRequestId(), "requestId");
                this.isNotBlank(item.getMessage(), "message");
                this.isNotBlank(item.getErrorCode(), "errorCode");
                this.isNotBlank(item.getServiceName(), "serviceName");
                return this.sb.length() == 0;
            }

            public void describeTo(Description description) {
                description.appendText(this.sb.toString());
            }

            private void isNotBlank(String value, String fieldName) {
                if (StringUtils.isBlank((CharSequence)value)) {
                    if (this.sb.length() > 0) {
                        this.sb.append(", ");
                    }
                    this.sb.append(fieldName).append(" should not be null or blank");
                }
            }
        };
    }
}

