/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.serverlessapplicationrepository.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.serverlessapplicationrepository.model.*;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * Version JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class VersionUnmarshaller implements Unmarshaller<Version, JsonUnmarshallerContext> {

    public Version unmarshall(JsonUnmarshallerContext context) throws Exception {
        Version.Builder versionBuilder = Version.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("applicationId", targetDepth)) {
                    context.nextToken();
                    versionBuilder.applicationId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("creationTime", targetDepth)) {
                    context.nextToken();
                    versionBuilder.creationTime(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("parameterDefinitions", targetDepth)) {
                    context.nextToken();
                    versionBuilder.parameterDefinitions(new ListUnmarshaller<ParameterDefinition>(ParameterDefinitionUnmarshaller
                            .getInstance()).unmarshall(context));
                }
                if (context.testExpression("semanticVersion", targetDepth)) {
                    context.nextToken();
                    versionBuilder.semanticVersion(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("sourceCodeUrl", targetDepth)) {
                    context.nextToken();
                    versionBuilder.sourceCodeUrl(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("templateUrl", targetDepth)) {
                    context.nextToken();
                    versionBuilder.templateUrl(context.getUnmarshaller(String.class).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return versionBuilder.build();
    }

    private static final VersionUnmarshaller INSTANCE = new VersionUnmarshaller();

    public static VersionUnmarshaller getInstance() {
        return INSTANCE;
    }
}
