/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.serverlessapplicationrepository.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.serverlessapplicationrepository.model.*;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * ParameterDefinition JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ParameterDefinitionUnmarshaller implements Unmarshaller<ParameterDefinition, JsonUnmarshallerContext> {

    public ParameterDefinition unmarshall(JsonUnmarshallerContext context) throws Exception {
        ParameterDefinition.Builder parameterDefinitionBuilder = ParameterDefinition.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("allowedPattern", targetDepth)) {
                    context.nextToken();
                    parameterDefinitionBuilder.allowedPattern(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("allowedValues", targetDepth)) {
                    context.nextToken();
                    parameterDefinitionBuilder.allowedValues(new ListUnmarshaller<String>(context.getUnmarshaller(String.class))
                            .unmarshall(context));
                }
                if (context.testExpression("constraintDescription", targetDepth)) {
                    context.nextToken();
                    parameterDefinitionBuilder.constraintDescription(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("defaultValue", targetDepth)) {
                    context.nextToken();
                    parameterDefinitionBuilder.defaultValue(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("description", targetDepth)) {
                    context.nextToken();
                    parameterDefinitionBuilder.description(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("maxLength", targetDepth)) {
                    context.nextToken();
                    parameterDefinitionBuilder.maxLength(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (context.testExpression("maxValue", targetDepth)) {
                    context.nextToken();
                    parameterDefinitionBuilder.maxValue(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (context.testExpression("minLength", targetDepth)) {
                    context.nextToken();
                    parameterDefinitionBuilder.minLength(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (context.testExpression("minValue", targetDepth)) {
                    context.nextToken();
                    parameterDefinitionBuilder.minValue(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (context.testExpression("name", targetDepth)) {
                    context.nextToken();
                    parameterDefinitionBuilder.name(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("noEcho", targetDepth)) {
                    context.nextToken();
                    parameterDefinitionBuilder.noEcho(context.getUnmarshaller(Boolean.class).unmarshall(context));
                }
                if (context.testExpression("referencedByResources", targetDepth)) {
                    context.nextToken();
                    parameterDefinitionBuilder.referencedByResources(new ListUnmarshaller<String>(context
                            .getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("type", targetDepth)) {
                    context.nextToken();
                    parameterDefinitionBuilder.type(context.getUnmarshaller(String.class).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return parameterDefinitionBuilder.build();
    }

    private static final ParameterDefinitionUnmarshaller INSTANCE = new ParameterDefinitionUnmarshaller();

    public static ParameterDefinitionUnmarshaller getInstance() {
        return INSTANCE;
    }
}
