/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.serverlessapplicationrepository.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.serverlessapplicationrepository.transform.VersionSummaryMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Application version summary.
 */
@Generated("software.amazon.awssdk:codegen")
public class VersionSummary implements StructuredPojo, ToCopyableBuilder<VersionSummary.Builder, VersionSummary> {
    private final String applicationId;

    private final String creationTime;

    private final String semanticVersion;

    private final String sourceCodeUrl;

    private VersionSummary(BuilderImpl builder) {
        this.applicationId = builder.applicationId;
        this.creationTime = builder.creationTime;
        this.semanticVersion = builder.semanticVersion;
        this.sourceCodeUrl = builder.sourceCodeUrl;
    }

    /**
     * The application Amazon Resource Name (ARN).
     * 
     * @return The application Amazon Resource Name (ARN).
     */
    public String applicationId() {
        return applicationId;
    }

    /**
     * The date/time this resource was created.
     * 
     * @return The date/time this resource was created.
     */
    public String creationTime() {
        return creationTime;
    }

    /**
     * The semantic version of the application:\n\n https://semver.org/
     * 
     * @return The semantic version of the application:\n\n https://semver.org/
     */
    public String semanticVersion() {
        return semanticVersion;
    }

    /**
     * A link to a public repository for the source code of your application.
     * 
     * @return A link to a public repository for the source code of your application.
     */
    public String sourceCodeUrl() {
        return sourceCodeUrl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(semanticVersion());
        hashCode = 31 * hashCode + Objects.hashCode(sourceCodeUrl());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VersionSummary)) {
            return false;
        }
        VersionSummary other = (VersionSummary) obj;
        return Objects.equals(applicationId(), other.applicationId()) && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(semanticVersion(), other.semanticVersion())
                && Objects.equals(sourceCodeUrl(), other.sourceCodeUrl());
    }

    @Override
    public String toString() {
        return ToString.builder("VersionSummary").add("ApplicationId", applicationId()).add("CreationTime", creationTime())
                .add("SemanticVersion", semanticVersion()).add("SourceCodeUrl", sourceCodeUrl()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationId":
            return Optional.of(clazz.cast(applicationId()));
        case "CreationTime":
            return Optional.of(clazz.cast(creationTime()));
        case "SemanticVersion":
            return Optional.of(clazz.cast(semanticVersion()));
        case "SourceCodeUrl":
            return Optional.of(clazz.cast(sourceCodeUrl()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        VersionSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, VersionSummary> {
        /**
         * The application Amazon Resource Name (ARN).
         * 
         * @param applicationId
         *        The application Amazon Resource Name (ARN).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * The date/time this resource was created.
         * 
         * @param creationTime
         *        The date/time this resource was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(String creationTime);

        /**
         * The semantic version of the application:\n\n https://semver.org/
         * 
         * @param semanticVersion
         *        The semantic version of the application:\n\n https://semver.org/
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder semanticVersion(String semanticVersion);

        /**
         * A link to a public repository for the source code of your application.
         * 
         * @param sourceCodeUrl
         *        A link to a public repository for the source code of your application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceCodeUrl(String sourceCodeUrl);
    }

    static final class BuilderImpl implements Builder {
        private String applicationId;

        private String creationTime;

        private String semanticVersion;

        private String sourceCodeUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(VersionSummary model) {
            applicationId(model.applicationId);
            creationTime(model.creationTime);
            semanticVersion(model.semanticVersion);
            sourceCodeUrl(model.sourceCodeUrl);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final String getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(String creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(String creationTime) {
            this.creationTime = creationTime;
        }

        public final String getSemanticVersion() {
            return semanticVersion;
        }

        @Override
        public final Builder semanticVersion(String semanticVersion) {
            this.semanticVersion = semanticVersion;
            return this;
        }

        public final void setSemanticVersion(String semanticVersion) {
            this.semanticVersion = semanticVersion;
        }

        public final String getSourceCodeUrl() {
            return sourceCodeUrl;
        }

        @Override
        public final Builder sourceCodeUrl(String sourceCodeUrl) {
            this.sourceCodeUrl = sourceCodeUrl;
            return this;
        }

        public final void setSourceCodeUrl(String sourceCodeUrl) {
            this.sourceCodeUrl = sourceCodeUrl;
        }

        @Override
        public VersionSummary build() {
            return new VersionSummary(this);
        }
    }
}
