/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.serverlessapplicationrepository.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * The resource (for example, an access policy statement) specified in the request does not exist.
 */
@Generated("software.amazon.awssdk:codegen")
public class NotFoundException extends ServerlessApplicationRepositoryException implements
        ToCopyableBuilder<NotFoundException.Builder, NotFoundException> {
    private final String errorCode;

    private NotFoundException(BuilderImpl builder) {
        super(builder.message);
        this.errorCode = builder.errorCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * 404
     * 
     * @return 404
     */
    public String errorCode() {
        return errorCode;
    }

    public interface Builder extends CopyableBuilder<Builder, NotFoundException> {
        /**
         * 404
         * 
         * @param errorCode
         *        404
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorCode(String errorCode);

        Builder message(String message);
    }

    static final class BuilderImpl implements Builder {
        private String errorCode;

        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(NotFoundException model) {
            errorCode(model.errorCode);
            this.message = model.getMessage();
        }

        public final String getErrorCode() {
            return errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        @JsonProperty("errorCode")
        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public String getMessage() {
            return message;
        }

        public String message() {
            return message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        @Override
        public Builder message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public NotFoundException build() {
            return new NotFoundException(this);
        }
    }
}
