/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.serverlessapplicationrepository.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.ListOf__stringCopier;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.ServerlessApplicationRepositoryRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateApplicationRequest
extends ServerlessApplicationRepositoryRequest
implements ToCopyableBuilder<Builder, UpdateApplicationRequest> {
    private final String applicationId;
    private final String author;
    private final String description;
    private final List<String> labels;
    private final String readmeBody;
    private final String readmeUrl;

    private UpdateApplicationRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.author = builder.author;
        this.description = builder.description;
        this.labels = builder.labels;
        this.readmeBody = builder.readmeBody;
        this.readmeUrl = builder.readmeUrl;
    }

    public String applicationId() {
        return this.applicationId;
    }

    public String author() {
        return this.author;
    }

    public String description() {
        return this.description;
    }

    public List<String> labels() {
        return this.labels;
    }

    public String readmeBody() {
        return this.readmeBody;
    }

    public String readmeUrl() {
        return this.readmeUrl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.author());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.labels());
        hashCode = 31 * hashCode + Objects.hashCode(this.readmeBody());
        hashCode = 31 * hashCode + Objects.hashCode(this.readmeUrl());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateApplicationRequest)) {
            return false;
        }
        UpdateApplicationRequest other = (UpdateApplicationRequest)((Object)obj);
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.author(), other.author()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.labels(), other.labels()) && Objects.equals(this.readmeBody(), other.readmeBody()) && Objects.equals(this.readmeUrl(), other.readmeUrl());
    }

    public String toString() {
        return ToString.builder((String)"UpdateApplicationRequest").add("ApplicationId", (Object)this.applicationId()).add("Author", (Object)this.author()).add("Description", (Object)this.description()).add("Labels", this.labels()).add("ReadmeBody", (Object)this.readmeBody()).add("ReadmeUrl", (Object)this.readmeUrl()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationId": {
                return Optional.of(clazz.cast(this.applicationId()));
            }
            case "Author": {
                return Optional.of(clazz.cast(this.author()));
            }
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "Labels": {
                return Optional.of(clazz.cast(this.labels()));
            }
            case "ReadmeBody": {
                return Optional.of(clazz.cast(this.readmeBody()));
            }
            case "ReadmeUrl": {
                return Optional.of(clazz.cast(this.readmeUrl()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ServerlessApplicationRepositoryRequest.BuilderImpl
    implements Builder {
        private String applicationId;
        private String author;
        private String description;
        private List<String> labels;
        private String readmeBody;
        private String readmeUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateApplicationRequest model) {
            this.applicationId(model.applicationId);
            this.author(model.author);
            this.description(model.description);
            this.labels(model.labels);
            this.readmeBody(model.readmeBody);
            this.readmeUrl(model.readmeUrl);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final String getAuthor() {
            return this.author;
        }

        @Override
        public final Builder author(String author) {
            this.author = author;
            return this;
        }

        public final void setAuthor(String author) {
            this.author = author;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<String> getLabels() {
            return this.labels;
        }

        @Override
        public final Builder labels(Collection<String> labels) {
            this.labels = ListOf__stringCopier.copy(labels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder labels(String ... labels) {
            this.labels(Arrays.asList(labels));
            return this;
        }

        public final void setLabels(Collection<String> labels) {
            this.labels = ListOf__stringCopier.copy(labels);
        }

        public final String getReadmeBody() {
            return this.readmeBody;
        }

        @Override
        public final Builder readmeBody(String readmeBody) {
            this.readmeBody = readmeBody;
            return this;
        }

        public final void setReadmeBody(String readmeBody) {
            this.readmeBody = readmeBody;
        }

        public final String getReadmeUrl() {
            return this.readmeUrl;
        }

        @Override
        public final Builder readmeUrl(String readmeUrl) {
            this.readmeUrl = readmeUrl;
            return this;
        }

        public final void setReadmeUrl(String readmeUrl) {
            this.readmeUrl = readmeUrl;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public UpdateApplicationRequest build() {
            return new UpdateApplicationRequest(this);
        }
    }

    public static interface Builder
    extends ServerlessApplicationRepositoryRequest.Builder,
    CopyableBuilder<Builder, UpdateApplicationRequest> {
        public Builder applicationId(String var1);

        public Builder author(String var1);

        public Builder description(String var1);

        public Builder labels(Collection<String> var1);

        public Builder labels(String ... var1);

        public Builder readmeBody(String var1);

        public Builder readmeUrl(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

