/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.serverlessapplicationrepository.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.serverlessapplicationrepository.transform.ApplicationSummaryMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Summary of details about the application.
 */
@Generated("software.amazon.awssdk:codegen")
public class ApplicationSummary implements StructuredPojo, ToCopyableBuilder<ApplicationSummary.Builder, ApplicationSummary> {
    private final String applicationId;

    private final String author;

    private final String creationTime;

    private final String description;

    private final List<String> labels;

    private final String name;

    private final String spdxLicenseId;

    private ApplicationSummary(BuilderImpl builder) {
        this.applicationId = builder.applicationId;
        this.author = builder.author;
        this.creationTime = builder.creationTime;
        this.description = builder.description;
        this.labels = builder.labels;
        this.name = builder.name;
        this.spdxLicenseId = builder.spdxLicenseId;
    }

    /**
     * The application ARN.
     * 
     * @return The application ARN.
     */
    public String applicationId() {
        return applicationId;
    }

    /**
     * The name of the author publishing the app\nMin Length=1. Max Length=127.\nPattern
     * "^[a-z0-9](([a-z0-9]|-(?!-))*[a-z0-9])?$";
     * 
     * @return The name of the author publishing the app\nMin Length=1. Max Length=127.\nPattern
     *         "^[a-z0-9](([a-z0-9]|-(?!-))*[a-z0-9])?$";
     */
    public String author() {
        return author;
    }

    /**
     * The date/time this resource was created.
     * 
     * @return The date/time this resource was created.
     */
    public String creationTime() {
        return creationTime;
    }

    /**
     * The description of the application.\nMin Length=1. Max Length=256
     * 
     * @return The description of the application.\nMin Length=1. Max Length=256
     */
    public String description() {
        return description;
    }

    /**
     * Labels to improve discovery of apps in search results.\nMin Length=1. Max Length=127. Maximum number of labels:
     * 10\nPattern: "^[a-zA-Z0-9+\\-_:\\/@]+$";
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Labels to improve discovery of apps in search results.\nMin Length=1. Max Length=127. Maximum number of
     *         labels: 10\nPattern: "^[a-zA-Z0-9+\\-_:\\/@]+$";
     */
    public List<String> labels() {
        return labels;
    }

    /**
     * The name of the application.\nMin Length=1. Max Length=140\nPattern: "[a-zA-Z0-9\\-]+";
     * 
     * @return The name of the application.\nMin Length=1. Max Length=140\nPattern: "[a-zA-Z0-9\\-]+";
     */
    public String name() {
        return name;
    }

    /**
     * A valid identifier from https://spdx.org/licenses/ .
     * 
     * @return A valid identifier from https://spdx.org/licenses/ .
     */
    public String spdxLicenseId() {
        return spdxLicenseId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(author());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(labels());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(spdxLicenseId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationSummary)) {
            return false;
        }
        ApplicationSummary other = (ApplicationSummary) obj;
        return Objects.equals(applicationId(), other.applicationId()) && Objects.equals(author(), other.author())
                && Objects.equals(creationTime(), other.creationTime()) && Objects.equals(description(), other.description())
                && Objects.equals(labels(), other.labels()) && Objects.equals(name(), other.name())
                && Objects.equals(spdxLicenseId(), other.spdxLicenseId());
    }

    @Override
    public String toString() {
        return ToString.builder("ApplicationSummary").add("ApplicationId", applicationId()).add("Author", author())
                .add("CreationTime", creationTime()).add("Description", description()).add("Labels", labels())
                .add("Name", name()).add("SpdxLicenseId", spdxLicenseId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationId":
            return Optional.of(clazz.cast(applicationId()));
        case "Author":
            return Optional.of(clazz.cast(author()));
        case "CreationTime":
            return Optional.of(clazz.cast(creationTime()));
        case "Description":
            return Optional.of(clazz.cast(description()));
        case "Labels":
            return Optional.of(clazz.cast(labels()));
        case "Name":
            return Optional.of(clazz.cast(name()));
        case "SpdxLicenseId":
            return Optional.of(clazz.cast(spdxLicenseId()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ApplicationSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, ApplicationSummary> {
        /**
         * The application ARN.
         * 
         * @param applicationId
         *        The application ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * The name of the author publishing the app\nMin Length=1. Max Length=127.\nPattern
         * "^[a-z0-9](([a-z0-9]|-(?!-))*[a-z0-9])?$";
         * 
         * @param author
         *        The name of the author publishing the app\nMin Length=1. Max Length=127.\nPattern
         *        "^[a-z0-9](([a-z0-9]|-(?!-))*[a-z0-9])?$";
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder author(String author);

        /**
         * The date/time this resource was created.
         * 
         * @param creationTime
         *        The date/time this resource was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(String creationTime);

        /**
         * The description of the application.\nMin Length=1. Max Length=256
         * 
         * @param description
         *        The description of the application.\nMin Length=1. Max Length=256
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * Labels to improve discovery of apps in search results.\nMin Length=1. Max Length=127. Maximum number of
         * labels: 10\nPattern: "^[a-zA-Z0-9+\\-_:\\/@]+$";
         * 
         * @param labels
         *        Labels to improve discovery of apps in search results.\nMin Length=1. Max Length=127. Maximum number
         *        of labels: 10\nPattern: "^[a-zA-Z0-9+\\-_:\\/@]+$";
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labels(Collection<String> labels);

        /**
         * Labels to improve discovery of apps in search results.\nMin Length=1. Max Length=127. Maximum number of
         * labels: 10\nPattern: "^[a-zA-Z0-9+\\-_:\\/@]+$";
         * 
         * @param labels
         *        Labels to improve discovery of apps in search results.\nMin Length=1. Max Length=127. Maximum number
         *        of labels: 10\nPattern: "^[a-zA-Z0-9+\\-_:\\/@]+$";
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labels(String... labels);

        /**
         * The name of the application.\nMin Length=1. Max Length=140\nPattern: "[a-zA-Z0-9\\-]+";
         * 
         * @param name
         *        The name of the application.\nMin Length=1. Max Length=140\nPattern: "[a-zA-Z0-9\\-]+";
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * A valid identifier from https://spdx.org/licenses/ .
         * 
         * @param spdxLicenseId
         *        A valid identifier from https://spdx.org/licenses/ .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spdxLicenseId(String spdxLicenseId);
    }

    static final class BuilderImpl implements Builder {
        private String applicationId;

        private String author;

        private String creationTime;

        private String description;

        private List<String> labels;

        private String name;

        private String spdxLicenseId;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationSummary model) {
            applicationId(model.applicationId);
            author(model.author);
            creationTime(model.creationTime);
            description(model.description);
            labels(model.labels);
            name(model.name);
            spdxLicenseId(model.spdxLicenseId);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final String getAuthor() {
            return author;
        }

        @Override
        public final Builder author(String author) {
            this.author = author;
            return this;
        }

        public final void setAuthor(String author) {
            this.author = author;
        }

        public final String getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(String creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(String creationTime) {
            this.creationTime = creationTime;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<String> getLabels() {
            return labels;
        }

        @Override
        public final Builder labels(Collection<String> labels) {
            this.labels = ListOf__stringCopier.copy(labels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder labels(String... labels) {
            labels(Arrays.asList(labels));
            return this;
        }

        public final void setLabels(Collection<String> labels) {
            this.labels = ListOf__stringCopier.copy(labels);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getSpdxLicenseId() {
            return spdxLicenseId;
        }

        @Override
        public final Builder spdxLicenseId(String spdxLicenseId) {
            this.spdxLicenseId = spdxLicenseId;
            return this;
        }

        public final void setSpdxLicenseId(String spdxLicenseId) {
            this.spdxLicenseId = spdxLicenseId;
        }

        @Override
        public ApplicationSummary build() {
            return new ApplicationSummary(this);
        }
    }
}
