/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.serverlessapplicationrepository.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.ListOf__stringCopier;
import software.amazon.awssdk.services.serverlessapplicationrepository.transform.ParameterDefinitionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ParameterDefinition
implements StructuredPojo,
ToCopyableBuilder<Builder, ParameterDefinition> {
    private final String allowedPattern;
    private final List<String> allowedValues;
    private final String constraintDescription;
    private final String defaultValue;
    private final String description;
    private final Integer maxLength;
    private final Integer maxValue;
    private final Integer minLength;
    private final Integer minValue;
    private final String name;
    private final Boolean noEcho;
    private final List<String> referencedByResources;
    private final String type;

    private ParameterDefinition(BuilderImpl builder) {
        this.allowedPattern = builder.allowedPattern;
        this.allowedValues = builder.allowedValues;
        this.constraintDescription = builder.constraintDescription;
        this.defaultValue = builder.defaultValue;
        this.description = builder.description;
        this.maxLength = builder.maxLength;
        this.maxValue = builder.maxValue;
        this.minLength = builder.minLength;
        this.minValue = builder.minValue;
        this.name = builder.name;
        this.noEcho = builder.noEcho;
        this.referencedByResources = builder.referencedByResources;
        this.type = builder.type;
    }

    public String allowedPattern() {
        return this.allowedPattern;
    }

    public List<String> allowedValues() {
        return this.allowedValues;
    }

    public String constraintDescription() {
        return this.constraintDescription;
    }

    public String defaultValue() {
        return this.defaultValue;
    }

    public String description() {
        return this.description;
    }

    public Integer maxLength() {
        return this.maxLength;
    }

    public Integer maxValue() {
        return this.maxValue;
    }

    public Integer minLength() {
        return this.minLength;
    }

    public Integer minValue() {
        return this.minValue;
    }

    public String name() {
        return this.name;
    }

    public Boolean noEcho() {
        return this.noEcho;
    }

    public List<String> referencedByResources() {
        return this.referencedByResources;
    }

    public String type() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.allowedPattern());
        hashCode = 31 * hashCode + Objects.hashCode(this.allowedValues());
        hashCode = 31 * hashCode + Objects.hashCode(this.constraintDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxLength());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.minLength());
        hashCode = 31 * hashCode + Objects.hashCode(this.minValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.noEcho());
        hashCode = 31 * hashCode + Objects.hashCode(this.referencedByResources());
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParameterDefinition)) {
            return false;
        }
        ParameterDefinition other = (ParameterDefinition)obj;
        return Objects.equals(this.allowedPattern(), other.allowedPattern()) && Objects.equals(this.allowedValues(), other.allowedValues()) && Objects.equals(this.constraintDescription(), other.constraintDescription()) && Objects.equals(this.defaultValue(), other.defaultValue()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.maxLength(), other.maxLength()) && Objects.equals(this.maxValue(), other.maxValue()) && Objects.equals(this.minLength(), other.minLength()) && Objects.equals(this.minValue(), other.minValue()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.noEcho(), other.noEcho()) && Objects.equals(this.referencedByResources(), other.referencedByResources()) && Objects.equals(this.type(), other.type());
    }

    public String toString() {
        return ToString.builder((String)"ParameterDefinition").add("AllowedPattern", (Object)this.allowedPattern()).add("AllowedValues", this.allowedValues()).add("ConstraintDescription", (Object)this.constraintDescription()).add("DefaultValue", (Object)this.defaultValue()).add("Description", (Object)this.description()).add("MaxLength", (Object)this.maxLength()).add("MaxValue", (Object)this.maxValue()).add("MinLength", (Object)this.minLength()).add("MinValue", (Object)this.minValue()).add("Name", (Object)this.name()).add("NoEcho", (Object)this.noEcho()).add("ReferencedByResources", this.referencedByResources()).add("Type", (Object)this.type()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AllowedPattern": {
                return Optional.ofNullable(clazz.cast(this.allowedPattern()));
            }
            case "AllowedValues": {
                return Optional.ofNullable(clazz.cast(this.allowedValues()));
            }
            case "ConstraintDescription": {
                return Optional.ofNullable(clazz.cast(this.constraintDescription()));
            }
            case "DefaultValue": {
                return Optional.ofNullable(clazz.cast(this.defaultValue()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "MaxLength": {
                return Optional.ofNullable(clazz.cast(this.maxLength()));
            }
            case "MaxValue": {
                return Optional.ofNullable(clazz.cast(this.maxValue()));
            }
            case "MinLength": {
                return Optional.ofNullable(clazz.cast(this.minLength()));
            }
            case "MinValue": {
                return Optional.ofNullable(clazz.cast(this.minValue()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "NoEcho": {
                return Optional.ofNullable(clazz.cast(this.noEcho()));
            }
            case "ReferencedByResources": {
                return Optional.ofNullable(clazz.cast(this.referencedByResources()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ParameterDefinitionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String allowedPattern;
        private List<String> allowedValues = DefaultSdkAutoConstructList.getInstance();
        private String constraintDescription;
        private String defaultValue;
        private String description;
        private Integer maxLength;
        private Integer maxValue;
        private Integer minLength;
        private Integer minValue;
        private String name;
        private Boolean noEcho;
        private List<String> referencedByResources = DefaultSdkAutoConstructList.getInstance();
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(ParameterDefinition model) {
            this.allowedPattern(model.allowedPattern);
            this.allowedValues(model.allowedValues);
            this.constraintDescription(model.constraintDescription);
            this.defaultValue(model.defaultValue);
            this.description(model.description);
            this.maxLength(model.maxLength);
            this.maxValue(model.maxValue);
            this.minLength(model.minLength);
            this.minValue(model.minValue);
            this.name(model.name);
            this.noEcho(model.noEcho);
            this.referencedByResources(model.referencedByResources);
            this.type(model.type);
        }

        public final String getAllowedPattern() {
            return this.allowedPattern;
        }

        @Override
        public final Builder allowedPattern(String allowedPattern) {
            this.allowedPattern = allowedPattern;
            return this;
        }

        public final void setAllowedPattern(String allowedPattern) {
            this.allowedPattern = allowedPattern;
        }

        public final Collection<String> getAllowedValues() {
            return this.allowedValues;
        }

        @Override
        public final Builder allowedValues(Collection<String> allowedValues) {
            this.allowedValues = ListOf__stringCopier.copy(allowedValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedValues(String ... allowedValues) {
            this.allowedValues(Arrays.asList(allowedValues));
            return this;
        }

        public final void setAllowedValues(Collection<String> allowedValues) {
            this.allowedValues = ListOf__stringCopier.copy(allowedValues);
        }

        public final String getConstraintDescription() {
            return this.constraintDescription;
        }

        @Override
        public final Builder constraintDescription(String constraintDescription) {
            this.constraintDescription = constraintDescription;
            return this;
        }

        public final void setConstraintDescription(String constraintDescription) {
            this.constraintDescription = constraintDescription;
        }

        public final String getDefaultValue() {
            return this.defaultValue;
        }

        @Override
        public final Builder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public final void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Integer getMaxLength() {
            return this.maxLength;
        }

        @Override
        public final Builder maxLength(Integer maxLength) {
            this.maxLength = maxLength;
            return this;
        }

        public final void setMaxLength(Integer maxLength) {
            this.maxLength = maxLength;
        }

        public final Integer getMaxValue() {
            return this.maxValue;
        }

        @Override
        public final Builder maxValue(Integer maxValue) {
            this.maxValue = maxValue;
            return this;
        }

        public final void setMaxValue(Integer maxValue) {
            this.maxValue = maxValue;
        }

        public final Integer getMinLength() {
            return this.minLength;
        }

        @Override
        public final Builder minLength(Integer minLength) {
            this.minLength = minLength;
            return this;
        }

        public final void setMinLength(Integer minLength) {
            this.minLength = minLength;
        }

        public final Integer getMinValue() {
            return this.minValue;
        }

        @Override
        public final Builder minValue(Integer minValue) {
            this.minValue = minValue;
            return this;
        }

        public final void setMinValue(Integer minValue) {
            this.minValue = minValue;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Boolean getNoEcho() {
            return this.noEcho;
        }

        @Override
        public final Builder noEcho(Boolean noEcho) {
            this.noEcho = noEcho;
            return this;
        }

        public final void setNoEcho(Boolean noEcho) {
            this.noEcho = noEcho;
        }

        public final Collection<String> getReferencedByResources() {
            return this.referencedByResources;
        }

        @Override
        public final Builder referencedByResources(Collection<String> referencedByResources) {
            this.referencedByResources = ListOf__stringCopier.copy(referencedByResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder referencedByResources(String ... referencedByResources) {
            this.referencedByResources(Arrays.asList(referencedByResources));
            return this;
        }

        public final void setReferencedByResources(Collection<String> referencedByResources) {
            this.referencedByResources = ListOf__stringCopier.copy(referencedByResources);
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public ParameterDefinition build() {
            return new ParameterDefinition(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ParameterDefinition> {
        public Builder allowedPattern(String var1);

        public Builder allowedValues(Collection<String> var1);

        public Builder allowedValues(String ... var1);

        public Builder constraintDescription(String var1);

        public Builder defaultValue(String var1);

        public Builder description(String var1);

        public Builder maxLength(Integer var1);

        public Builder maxValue(Integer var1);

        public Builder minLength(Integer var1);

        public Builder minValue(Integer var1);

        public Builder name(String var1);

        public Builder noEcho(Boolean var1);

        public Builder referencedByResources(Collection<String> var1);

        public Builder referencedByResources(String ... var1);

        public Builder type(String var1);
    }
}

