/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.serverlessapplicationrepository.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.ListOf__stringCopier;
import software.amazon.awssdk.services.serverlessapplicationrepository.transform.ApplicationSummaryMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ApplicationSummary
implements StructuredPojo,
ToCopyableBuilder<Builder, ApplicationSummary> {
    private final String applicationId;
    private final String author;
    private final String creationTime;
    private final String description;
    private final List<String> labels;
    private final String name;
    private final String spdxLicenseId;

    private ApplicationSummary(BuilderImpl builder) {
        this.applicationId = builder.applicationId;
        this.author = builder.author;
        this.creationTime = builder.creationTime;
        this.description = builder.description;
        this.labels = builder.labels;
        this.name = builder.name;
        this.spdxLicenseId = builder.spdxLicenseId;
    }

    public String applicationId() {
        return this.applicationId;
    }

    public String author() {
        return this.author;
    }

    public String creationTime() {
        return this.creationTime;
    }

    public String description() {
        return this.description;
    }

    public List<String> labels() {
        return this.labels;
    }

    public String name() {
        return this.name;
    }

    public String spdxLicenseId() {
        return this.spdxLicenseId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.author());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.labels());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.spdxLicenseId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationSummary)) {
            return false;
        }
        ApplicationSummary other = (ApplicationSummary)obj;
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.author(), other.author()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.labels(), other.labels()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.spdxLicenseId(), other.spdxLicenseId());
    }

    public String toString() {
        return ToString.builder((String)"ApplicationSummary").add("ApplicationId", (Object)this.applicationId()).add("Author", (Object)this.author()).add("CreationTime", (Object)this.creationTime()).add("Description", (Object)this.description()).add("Labels", this.labels()).add("Name", (Object)this.name()).add("SpdxLicenseId", (Object)this.spdxLicenseId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "Author": {
                return Optional.ofNullable(clazz.cast(this.author()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Labels": {
                return Optional.ofNullable(clazz.cast(this.labels()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "SpdxLicenseId": {
                return Optional.ofNullable(clazz.cast(this.spdxLicenseId()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ApplicationSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String applicationId;
        private String author;
        private String creationTime;
        private String description;
        private List<String> labels = DefaultSdkAutoConstructList.getInstance();
        private String name;
        private String spdxLicenseId;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationSummary model) {
            this.applicationId(model.applicationId);
            this.author(model.author);
            this.creationTime(model.creationTime);
            this.description(model.description);
            this.labels(model.labels);
            this.name(model.name);
            this.spdxLicenseId(model.spdxLicenseId);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final String getAuthor() {
            return this.author;
        }

        @Override
        public final Builder author(String author) {
            this.author = author;
            return this;
        }

        public final void setAuthor(String author) {
            this.author = author;
        }

        public final String getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(String creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(String creationTime) {
            this.creationTime = creationTime;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<String> getLabels() {
            return this.labels;
        }

        @Override
        public final Builder labels(Collection<String> labels) {
            this.labels = ListOf__stringCopier.copy(labels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder labels(String ... labels) {
            this.labels(Arrays.asList(labels));
            return this;
        }

        public final void setLabels(Collection<String> labels) {
            this.labels = ListOf__stringCopier.copy(labels);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getSpdxLicenseId() {
            return this.spdxLicenseId;
        }

        @Override
        public final Builder spdxLicenseId(String spdxLicenseId) {
            this.spdxLicenseId = spdxLicenseId;
            return this;
        }

        public final void setSpdxLicenseId(String spdxLicenseId) {
            this.spdxLicenseId = spdxLicenseId;
        }

        public ApplicationSummary build() {
            return new ApplicationSummary(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ApplicationSummary> {
        public Builder applicationId(String var1);

        public Builder author(String var1);

        public Builder creationTime(String var1);

        public Builder description(String var1);

        public Builder labels(Collection<String> var1);

        public Builder labels(String ... var1);

        public Builder name(String var1);

        public Builder spdxLicenseId(String var1);
    }
}

