/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.serverlessapplicationrepository.transform;

import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.CreateCloudFormationChangeSetRequest;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link CreateCloudFormationChangeSetRequest} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class CreateCloudFormationChangeSetRequestModelMarshaller {
    private static final MarshallingInfo<String> APPLICATIONID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PATH).marshallLocationName("applicationId").isBinary(false).build();

    private static final MarshallingInfo<List> PARAMETEROVERRIDES_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("parameterOverrides").isBinary(false).build();

    private static final MarshallingInfo<String> SEMANTICVERSION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("semanticVersion").isBinary(false).build();

    private static final MarshallingInfo<String> STACKNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("stackName").isBinary(false).build();

    private static final CreateCloudFormationChangeSetRequestModelMarshaller INSTANCE = new CreateCloudFormationChangeSetRequestModelMarshaller();

    private CreateCloudFormationChangeSetRequestModelMarshaller() {
    }

    public static CreateCloudFormationChangeSetRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(CreateCloudFormationChangeSetRequest createCloudFormationChangeSetRequest,
            ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(createCloudFormationChangeSetRequest, "createCloudFormationChangeSetRequest");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(createCloudFormationChangeSetRequest.applicationId(), APPLICATIONID_BINDING);
            protocolMarshaller.marshall(createCloudFormationChangeSetRequest.parameterOverrides(), PARAMETEROVERRIDES_BINDING);
            protocolMarshaller.marshall(createCloudFormationChangeSetRequest.semanticVersion(), SEMANTICVERSION_BINDING);
            protocolMarshaller.marshall(createCloudFormationChangeSetRequest.stackName(), STACKNAME_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
