/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.serverlessapplicationrepository.transform;

import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.ParameterDefinition;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link ParameterDefinition} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class ParameterDefinitionMarshaller {
    private static final MarshallingInfo<String> ALLOWEDPATTERN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("allowedPattern").isBinary(false).build();

    private static final MarshallingInfo<List> ALLOWEDVALUES_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("allowedValues").isBinary(false).build();

    private static final MarshallingInfo<String> CONSTRAINTDESCRIPTION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("constraintDescription").isBinary(false).build();

    private static final MarshallingInfo<String> DEFAULTVALUE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("defaultValue").isBinary(false).build();

    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("description").isBinary(false).build();

    private static final MarshallingInfo<Integer> MAXLENGTH_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("maxLength").isBinary(false).build();

    private static final MarshallingInfo<Integer> MAXVALUE_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("maxValue").isBinary(false).build();

    private static final MarshallingInfo<Integer> MINLENGTH_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("minLength").isBinary(false).build();

    private static final MarshallingInfo<Integer> MINVALUE_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("minValue").isBinary(false).build();

    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").isBinary(false).build();

    private static final MarshallingInfo<Boolean> NOECHO_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("noEcho").isBinary(false).build();

    private static final MarshallingInfo<List> REFERENCEDBYRESOURCES_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("referencedByResources").isBinary(false).build();

    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("type").isBinary(false).build();

    private static final ParameterDefinitionMarshaller INSTANCE = new ParameterDefinitionMarshaller();

    private ParameterDefinitionMarshaller() {
    }

    public static ParameterDefinitionMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(ParameterDefinition parameterDefinition, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(parameterDefinition, "parameterDefinition");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(parameterDefinition.allowedPattern(), ALLOWEDPATTERN_BINDING);
            protocolMarshaller.marshall(parameterDefinition.allowedValues(), ALLOWEDVALUES_BINDING);
            protocolMarshaller.marshall(parameterDefinition.constraintDescription(), CONSTRAINTDESCRIPTION_BINDING);
            protocolMarshaller.marshall(parameterDefinition.defaultValue(), DEFAULTVALUE_BINDING);
            protocolMarshaller.marshall(parameterDefinition.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall(parameterDefinition.maxLength(), MAXLENGTH_BINDING);
            protocolMarshaller.marshall(parameterDefinition.maxValue(), MAXVALUE_BINDING);
            protocolMarshaller.marshall(parameterDefinition.minLength(), MINLENGTH_BINDING);
            protocolMarshaller.marshall(parameterDefinition.minValue(), MINVALUE_BINDING);
            protocolMarshaller.marshall(parameterDefinition.name(), NAME_BINDING);
            protocolMarshaller.marshall(parameterDefinition.noEcho(), NOECHO_BINDING);
            protocolMarshaller.marshall(parameterDefinition.referencedByResources(), REFERENCEDBYRESOURCES_BINDING);
            protocolMarshaller.marshall(parameterDefinition.type(), TYPE_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}
