/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.serverlessapplicationrepository.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class ListApplicationsResponse extends ServerlessApplicationRepositoryResponse implements
        ToCopyableBuilder<ListApplicationsResponse.Builder, ListApplicationsResponse> {
    private final List<ApplicationSummary> applications;

    private final String nextToken;

    private ListApplicationsResponse(BuilderImpl builder) {
        super(builder);
        this.applications = builder.applications;
        this.nextToken = builder.nextToken;
    }

    /**
     * Array of application summaries.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Array of application summaries.
     */
    public List<ApplicationSummary> applications() {
        return applications;
    }

    /**
     * The token to request the next page of results.
     * 
     * @return The token to request the next page of results.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(applications());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListApplicationsResponse)) {
            return false;
        }
        ListApplicationsResponse other = (ListApplicationsResponse) obj;
        return Objects.equals(applications(), other.applications()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("ListApplicationsResponse").add("Applications", applications()).add("NextToken", nextToken())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Applications":
            return Optional.of(clazz.cast(applications()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends ServerlessApplicationRepositoryResponse.Builder,
            CopyableBuilder<Builder, ListApplicationsResponse> {
        /**
         * Array of application summaries.
         * 
         * @param applications
         *        Array of application summaries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applications(Collection<ApplicationSummary> applications);

        /**
         * Array of application summaries.
         * 
         * @param applications
         *        Array of application summaries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applications(ApplicationSummary... applications);

        /**
         * Array of application summaries. This is a convenience that creates an instance of the {@link List
         * <ApplicationSummary>.Builder} avoiding the need to create one manually via {@link List
         * <ApplicationSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ApplicationSummary>.Builder#build()} is called immediately
         * and its result is passed to {@link #applications(List<ApplicationSummary>)}.
         * 
         * @param applications
         *        a consumer that will call methods on {@link List<ApplicationSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #applications(List<ApplicationSummary>)
         */
        Builder applications(Consumer<ApplicationSummary.Builder>... applications);

        /**
         * The token to request the next page of results.
         * 
         * @param nextToken
         *        The token to request the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ServerlessApplicationRepositoryResponse.BuilderImpl implements Builder {
        private List<ApplicationSummary> applications;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListApplicationsResponse model) {
            super(model);
            applications(model.applications);
            nextToken(model.nextToken);
        }

        public final Collection<ApplicationSummary.Builder> getApplications() {
            return applications != null ? applications.stream().map(ApplicationSummary::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder applications(Collection<ApplicationSummary> applications) {
            this.applications = ListOfApplicationSummaryCopier.copy(applications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applications(ApplicationSummary... applications) {
            applications(Arrays.asList(applications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applications(Consumer<ApplicationSummary.Builder>... applications) {
            applications(Stream.of(applications).map(c -> ApplicationSummary.builder().apply(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setApplications(Collection<ApplicationSummary.BuilderImpl> applications) {
            this.applications = ListOfApplicationSummaryCopier.copyFromBuilder(applications);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListApplicationsResponse build() {
            return new ListApplicationsResponse(this);
        }
    }
}
