/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.serverlessapplicationrepository.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class ListApplicationVersionsResponse extends ServerlessApplicationRepositoryResponse implements
        ToCopyableBuilder<ListApplicationVersionsResponse.Builder, ListApplicationVersionsResponse> {
    private final String nextToken;

    private final List<VersionSummary> versions;

    private ListApplicationVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.versions = builder.versions;
    }

    /**
     * The token to request the next page of results.
     * 
     * @return The token to request the next page of results.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * Array of version summaries for the application.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Array of version summaries for the application.
     */
    public List<VersionSummary> versions() {
        return versions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(versions());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListApplicationVersionsResponse)) {
            return false;
        }
        ListApplicationVersionsResponse other = (ListApplicationVersionsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(versions(), other.versions());
    }

    @Override
    public String toString() {
        return ToString.builder("ListApplicationVersionsResponse").add("NextToken", nextToken()).add("Versions", versions())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        case "Versions":
            return Optional.of(clazz.cast(versions()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends ServerlessApplicationRepositoryResponse.Builder,
            CopyableBuilder<Builder, ListApplicationVersionsResponse> {
        /**
         * The token to request the next page of results.
         * 
         * @param nextToken
         *        The token to request the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * Array of version summaries for the application.
         * 
         * @param versions
         *        Array of version summaries for the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versions(Collection<VersionSummary> versions);

        /**
         * Array of version summaries for the application.
         * 
         * @param versions
         *        Array of version summaries for the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versions(VersionSummary... versions);

        /**
         * Array of version summaries for the application. This is a convenience that creates an instance of the
         * {@link List<VersionSummary>.Builder} avoiding the need to create one manually via {@link List
         * <VersionSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<VersionSummary>.Builder#build()} is called immediately and
         * its result is passed to {@link #versions(List<VersionSummary>)}.
         * 
         * @param versions
         *        a consumer that will call methods on {@link List<VersionSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #versions(List<VersionSummary>)
         */
        Builder versions(Consumer<VersionSummary.Builder>... versions);
    }

    static final class BuilderImpl extends ServerlessApplicationRepositoryResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<VersionSummary> versions;

        private BuilderImpl() {
        }

        private BuilderImpl(ListApplicationVersionsResponse model) {
            super(model);
            nextToken(model.nextToken);
            versions(model.versions);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<VersionSummary.Builder> getVersions() {
            return versions != null ? versions.stream().map(VersionSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder versions(Collection<VersionSummary> versions) {
            this.versions = ListOfVersionSummaryCopier.copy(versions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder versions(VersionSummary... versions) {
            versions(Arrays.asList(versions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder versions(Consumer<VersionSummary.Builder>... versions) {
            versions(Stream.of(versions).map(c -> VersionSummary.builder().apply(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setVersions(Collection<VersionSummary.BuilderImpl> versions) {
            this.versions = ListOfVersionSummaryCopier.copyFromBuilder(versions);
        }

        @Override
        public ListApplicationVersionsResponse build() {
            return new ListApplicationVersionsResponse(this);
        }
    }
}
