/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.serverlessapplicationrepository.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateCloudFormationChangeSetResponse extends ServerlessApplicationRepositoryResponse implements
        ToCopyableBuilder<CreateCloudFormationChangeSetResponse.Builder, CreateCloudFormationChangeSetResponse> {
    private final String applicationId;

    private final String changeSetId;

    private final String semanticVersion;

    private final String stackId;

    private CreateCloudFormationChangeSetResponse(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.changeSetId = builder.changeSetId;
        this.semanticVersion = builder.semanticVersion;
        this.stackId = builder.stackId;
    }

    /**
     * The application Amazon Resource Name (ARN).
     * 
     * @return The application Amazon Resource Name (ARN).
     */
    public String applicationId() {
        return applicationId;
    }

    /**
     * The ARN of the change set.\nLength Constraints: Minimum length of 1.\nPattern: arn:[-a-zA-Z0-9:/]*
     * 
     * @return The ARN of the change set.\nLength Constraints: Minimum length of 1.\nPattern: arn:[-a-zA-Z0-9:/]*
     */
    public String changeSetId() {
        return changeSetId;
    }

    /**
     * The semantic version of the application:\n\n https://semver.org/
     * 
     * @return The semantic version of the application:\n\n https://semver.org/
     */
    public String semanticVersion() {
        return semanticVersion;
    }

    /**
     * The unique ID of the stack.
     * 
     * @return The unique ID of the stack.
     */
    public String stackId() {
        return stackId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(changeSetId());
        hashCode = 31 * hashCode + Objects.hashCode(semanticVersion());
        hashCode = 31 * hashCode + Objects.hashCode(stackId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCloudFormationChangeSetResponse)) {
            return false;
        }
        CreateCloudFormationChangeSetResponse other = (CreateCloudFormationChangeSetResponse) obj;
        return Objects.equals(applicationId(), other.applicationId()) && Objects.equals(changeSetId(), other.changeSetId())
                && Objects.equals(semanticVersion(), other.semanticVersion()) && Objects.equals(stackId(), other.stackId());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateCloudFormationChangeSetResponse").add("ApplicationId", applicationId())
                .add("ChangeSetId", changeSetId()).add("SemanticVersion", semanticVersion()).add("StackId", stackId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationId":
            return Optional.of(clazz.cast(applicationId()));
        case "ChangeSetId":
            return Optional.of(clazz.cast(changeSetId()));
        case "SemanticVersion":
            return Optional.of(clazz.cast(semanticVersion()));
        case "StackId":
            return Optional.of(clazz.cast(stackId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends ServerlessApplicationRepositoryResponse.Builder,
            CopyableBuilder<Builder, CreateCloudFormationChangeSetResponse> {
        /**
         * The application Amazon Resource Name (ARN).
         * 
         * @param applicationId
         *        The application Amazon Resource Name (ARN).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * The ARN of the change set.\nLength Constraints: Minimum length of 1.\nPattern: arn:[-a-zA-Z0-9:/]*
         * 
         * @param changeSetId
         *        The ARN of the change set.\nLength Constraints: Minimum length of 1.\nPattern: arn:[-a-zA-Z0-9:/]*
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changeSetId(String changeSetId);

        /**
         * The semantic version of the application:\n\n https://semver.org/
         * 
         * @param semanticVersion
         *        The semantic version of the application:\n\n https://semver.org/
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder semanticVersion(String semanticVersion);

        /**
         * The unique ID of the stack.
         * 
         * @param stackId
         *        The unique ID of the stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackId(String stackId);
    }

    static final class BuilderImpl extends ServerlessApplicationRepositoryResponse.BuilderImpl implements Builder {
        private String applicationId;

        private String changeSetId;

        private String semanticVersion;

        private String stackId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCloudFormationChangeSetResponse model) {
            super(model);
            applicationId(model.applicationId);
            changeSetId(model.changeSetId);
            semanticVersion(model.semanticVersion);
            stackId(model.stackId);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final String getChangeSetId() {
            return changeSetId;
        }

        @Override
        public final Builder changeSetId(String changeSetId) {
            this.changeSetId = changeSetId;
            return this;
        }

        public final void setChangeSetId(String changeSetId) {
            this.changeSetId = changeSetId;
        }

        public final String getSemanticVersion() {
            return semanticVersion;
        }

        @Override
        public final Builder semanticVersion(String semanticVersion) {
            this.semanticVersion = semanticVersion;
            return this;
        }

        public final void setSemanticVersion(String semanticVersion) {
            this.semanticVersion = semanticVersion;
        }

        public final String getStackId() {
            return stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        @Override
        public CreateCloudFormationChangeSetResponse build() {
            return new CreateCloudFormationChangeSetResponse(this);
        }
    }
}
