/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.serverlessapplicationrepository.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.serverlessapplicationrepository.ServerlessApplicationRepositoryClient;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationDependenciesRequest;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationDependenciesResponse;

public class ListApplicationDependenciesIterable
implements SdkIterable<ListApplicationDependenciesResponse> {
    private final ServerlessApplicationRepositoryClient client;
    private final ListApplicationDependenciesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListApplicationDependenciesIterable(ServerlessApplicationRepositoryClient client, ListApplicationDependenciesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListApplicationDependenciesResponseFetcher();
    }

    public Iterator<ListApplicationDependenciesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private final ListApplicationDependenciesIterable resume(ListApplicationDependenciesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListApplicationDependenciesIterable(this.client, (ListApplicationDependenciesRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListApplicationDependenciesIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListApplicationDependenciesResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListApplicationDependenciesResponseFetcher
    implements SyncPageFetcher<ListApplicationDependenciesResponse> {
        private ListApplicationDependenciesResponseFetcher() {
        }

        public boolean hasNextPage(ListApplicationDependenciesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListApplicationDependenciesResponse nextPage(ListApplicationDependenciesResponse previousPage) {
            if (previousPage == null) {
                return ListApplicationDependenciesIterable.this.client.listApplicationDependencies(ListApplicationDependenciesIterable.this.firstRequest);
            }
            return ListApplicationDependenciesIterable.this.client.listApplicationDependencies((ListApplicationDependenciesRequest)((Object)ListApplicationDependenciesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

