/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.serverlessapplicationrepository.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Application version details.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Version implements SdkPojo, Serializable, ToCopyableBuilder<Version.Builder, Version> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Version::applicationId)).setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationId").build()).build();

    private static final SdkField<String> CREATION_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Version::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()).build();

    private static final SdkField<List<ParameterDefinition>> PARAMETER_DEFINITIONS_FIELD = SdkField
            .<List<ParameterDefinition>> builder(MarshallingType.LIST)
            .getter(getter(Version::parameterDefinitions))
            .setter(setter(Builder::parameterDefinitions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameterDefinitions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ParameterDefinition> builder(MarshallingType.SDK_POJO)
                                            .constructor(ParameterDefinition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> REQUIRED_CAPABILITIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(Version::requiredCapabilitiesAsStrings))
            .setter(setter(Builder::requiredCapabilitiesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requiredCapabilities").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> RESOURCES_SUPPORTED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(Version::resourcesSupported)).setter(setter(Builder::resourcesSupported))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourcesSupported").build())
            .build();

    private static final SdkField<String> SEMANTIC_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Version::semanticVersion)).setter(setter(Builder::semanticVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("semanticVersion").build()).build();

    private static final SdkField<String> SOURCE_CODE_ARCHIVE_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Version::sourceCodeArchiveUrl)).setter(setter(Builder::sourceCodeArchiveUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceCodeArchiveUrl").build())
            .build();

    private static final SdkField<String> SOURCE_CODE_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Version::sourceCodeUrl)).setter(setter(Builder::sourceCodeUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceCodeUrl").build()).build();

    private static final SdkField<String> TEMPLATE_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Version::templateUrl)).setter(setter(Builder::templateUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateUrl").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            CREATION_TIME_FIELD, PARAMETER_DEFINITIONS_FIELD, REQUIRED_CAPABILITIES_FIELD, RESOURCES_SUPPORTED_FIELD,
            SEMANTIC_VERSION_FIELD, SOURCE_CODE_ARCHIVE_URL_FIELD, SOURCE_CODE_URL_FIELD, TEMPLATE_URL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String applicationId;

    private final String creationTime;

    private final List<ParameterDefinition> parameterDefinitions;

    private final List<String> requiredCapabilities;

    private final Boolean resourcesSupported;

    private final String semanticVersion;

    private final String sourceCodeArchiveUrl;

    private final String sourceCodeUrl;

    private final String templateUrl;

    private Version(BuilderImpl builder) {
        this.applicationId = builder.applicationId;
        this.creationTime = builder.creationTime;
        this.parameterDefinitions = builder.parameterDefinitions;
        this.requiredCapabilities = builder.requiredCapabilities;
        this.resourcesSupported = builder.resourcesSupported;
        this.semanticVersion = builder.semanticVersion;
        this.sourceCodeArchiveUrl = builder.sourceCodeArchiveUrl;
        this.sourceCodeUrl = builder.sourceCodeUrl;
        this.templateUrl = builder.templateUrl;
    }

    /**
     * <p>
     * The application Amazon Resource Name (ARN).
     * </p>
     * 
     * @return The application Amazon Resource Name (ARN).
     */
    public String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * The date and time this resource was created.
     * </p>
     * 
     * @return The date and time this resource was created.
     */
    public String creationTime() {
        return creationTime;
    }

    /**
     * Returns true if the ParameterDefinitions property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasParameterDefinitions() {
        return parameterDefinitions != null && !(parameterDefinitions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of parameter types supported by the application.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasParameterDefinitions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of parameter types supported by the application.
     */
    public List<ParameterDefinition> parameterDefinitions() {
        return parameterDefinitions;
    }

    /**
     * <p>
     * A list of values that you must specify before you can deploy certain applications. Some applications might
     * include resources that can affect permissions in your AWS account, for example, by creating new AWS Identity and
     * Access Management (IAM) users. For those applications, you must explicitly acknowledge their capabilities by
     * specifying this parameter.
     * </p>
     * <p>
     * The only valid values are CAPABILITY_IAM, CAPABILITY_NAMED_IAM, CAPABILITY_RESOURCE_POLICY, and
     * CAPABILITY_AUTO_EXPAND.
     * </p>
     * <p>
     * The following resources require you to specify CAPABILITY_IAM or CAPABILITY_NAMED_IAM: <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html"
     * >AWS::IAM::Group</a>, <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html"
     * >AWS::IAM::InstanceProfile</a>, <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-policy.html"
     * >AWS::IAM::Policy</a>, and <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html"
     * >AWS::IAM::Role</a>. If the application contains IAM resources, you can specify either CAPABILITY_IAM or
     * CAPABILITY_NAMED_IAM. If the application contains IAM resources with custom names, you must specify
     * CAPABILITY_NAMED_IAM.
     * </p>
     * <p>
     * The following resources require you to specify CAPABILITY_RESOURCE_POLICY: <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-permission.html"
     * >AWS::Lambda::Permission</a>, <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-policy.html"
     * >AWS::IAM:Policy</a>, <a href=
     * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html"
     * >AWS::ApplicationAutoScaling::ScalingPolicy</a>, <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-policy.html"
     * >AWS::S3::BucketPolicy</a>, <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-policy.html"
     * >AWS::SQS::QueuePolicy</a>, and <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sns-policy.html"
     * >AWS::SNS::TopicPolicy</a>.
     * </p>
     * <p>
     * Applications that contain one or more nested applications require you to specify CAPABILITY_AUTO_EXPAND.
     * </p>
     * <p>
     * If your application template contains any of the above resources, we recommend that you review all permissions
     * associated with the application before deploying. If you don't specify this parameter for an application that
     * requires capabilities, the call will fail.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRequiredCapabilities()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of values that you must specify before you can deploy certain applications. Some applications
     *         might include resources that can affect permissions in your AWS account, for example, by creating new AWS
     *         Identity and Access Management (IAM) users. For those applications, you must explicitly acknowledge their
     *         capabilities by specifying this parameter.</p>
     *         <p>
     *         The only valid values are CAPABILITY_IAM, CAPABILITY_NAMED_IAM, CAPABILITY_RESOURCE_POLICY, and
     *         CAPABILITY_AUTO_EXPAND.
     *         </p>
     *         <p>
     *         The following resources require you to specify CAPABILITY_IAM or CAPABILITY_NAMED_IAM: <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html"
     *         >AWS::IAM::Group</a>, <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html"
     *         >AWS::IAM::InstanceProfile</a>, <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-policy.html"
     *         >AWS::IAM::Policy</a>, and <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html"
     *         >AWS::IAM::Role</a>. If the application contains IAM resources, you can specify either CAPABILITY_IAM or
     *         CAPABILITY_NAMED_IAM. If the application contains IAM resources with custom names, you must specify
     *         CAPABILITY_NAMED_IAM.
     *         </p>
     *         <p>
     *         The following resources require you to specify CAPABILITY_RESOURCE_POLICY: <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-permission.html"
     *         >AWS::Lambda::Permission</a>, <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-policy.html"
     *         >AWS::IAM:Policy</a>, <a href=
     *         "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html"
     *         >AWS::ApplicationAutoScaling::ScalingPolicy</a>, <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-policy.html"
     *         >AWS::S3::BucketPolicy</a>, <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-policy.html"
     *         >AWS::SQS::QueuePolicy</a>, and <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sns-policy.html"
     *         >AWS::SNS::TopicPolicy</a>.
     *         </p>
     *         <p>
     *         Applications that contain one or more nested applications require you to specify CAPABILITY_AUTO_EXPAND.
     *         </p>
     *         <p>
     *         If your application template contains any of the above resources, we recommend that you review all
     *         permissions associated with the application before deploying. If you don't specify this parameter for an
     *         application that requires capabilities, the call will fail.
     */
    public List<Capability> requiredCapabilities() {
        return ___listOfCapabilityCopier.copyStringToEnum(requiredCapabilities);
    }

    /**
     * Returns true if the RequiredCapabilities property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasRequiredCapabilities() {
        return requiredCapabilities != null && !(requiredCapabilities instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of values that you must specify before you can deploy certain applications. Some applications might
     * include resources that can affect permissions in your AWS account, for example, by creating new AWS Identity and
     * Access Management (IAM) users. For those applications, you must explicitly acknowledge their capabilities by
     * specifying this parameter.
     * </p>
     * <p>
     * The only valid values are CAPABILITY_IAM, CAPABILITY_NAMED_IAM, CAPABILITY_RESOURCE_POLICY, and
     * CAPABILITY_AUTO_EXPAND.
     * </p>
     * <p>
     * The following resources require you to specify CAPABILITY_IAM or CAPABILITY_NAMED_IAM: <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html"
     * >AWS::IAM::Group</a>, <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html"
     * >AWS::IAM::InstanceProfile</a>, <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-policy.html"
     * >AWS::IAM::Policy</a>, and <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html"
     * >AWS::IAM::Role</a>. If the application contains IAM resources, you can specify either CAPABILITY_IAM or
     * CAPABILITY_NAMED_IAM. If the application contains IAM resources with custom names, you must specify
     * CAPABILITY_NAMED_IAM.
     * </p>
     * <p>
     * The following resources require you to specify CAPABILITY_RESOURCE_POLICY: <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-permission.html"
     * >AWS::Lambda::Permission</a>, <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-policy.html"
     * >AWS::IAM:Policy</a>, <a href=
     * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html"
     * >AWS::ApplicationAutoScaling::ScalingPolicy</a>, <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-policy.html"
     * >AWS::S3::BucketPolicy</a>, <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-policy.html"
     * >AWS::SQS::QueuePolicy</a>, and <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sns-policy.html"
     * >AWS::SNS::TopicPolicy</a>.
     * </p>
     * <p>
     * Applications that contain one or more nested applications require you to specify CAPABILITY_AUTO_EXPAND.
     * </p>
     * <p>
     * If your application template contains any of the above resources, we recommend that you review all permissions
     * associated with the application before deploying. If you don't specify this parameter for an application that
     * requires capabilities, the call will fail.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRequiredCapabilities()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of values that you must specify before you can deploy certain applications. Some applications
     *         might include resources that can affect permissions in your AWS account, for example, by creating new AWS
     *         Identity and Access Management (IAM) users. For those applications, you must explicitly acknowledge their
     *         capabilities by specifying this parameter.</p>
     *         <p>
     *         The only valid values are CAPABILITY_IAM, CAPABILITY_NAMED_IAM, CAPABILITY_RESOURCE_POLICY, and
     *         CAPABILITY_AUTO_EXPAND.
     *         </p>
     *         <p>
     *         The following resources require you to specify CAPABILITY_IAM or CAPABILITY_NAMED_IAM: <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html"
     *         >AWS::IAM::Group</a>, <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html"
     *         >AWS::IAM::InstanceProfile</a>, <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-policy.html"
     *         >AWS::IAM::Policy</a>, and <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html"
     *         >AWS::IAM::Role</a>. If the application contains IAM resources, you can specify either CAPABILITY_IAM or
     *         CAPABILITY_NAMED_IAM. If the application contains IAM resources with custom names, you must specify
     *         CAPABILITY_NAMED_IAM.
     *         </p>
     *         <p>
     *         The following resources require you to specify CAPABILITY_RESOURCE_POLICY: <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-permission.html"
     *         >AWS::Lambda::Permission</a>, <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-policy.html"
     *         >AWS::IAM:Policy</a>, <a href=
     *         "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html"
     *         >AWS::ApplicationAutoScaling::ScalingPolicy</a>, <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-policy.html"
     *         >AWS::S3::BucketPolicy</a>, <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-policy.html"
     *         >AWS::SQS::QueuePolicy</a>, and <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sns-policy.html"
     *         >AWS::SNS::TopicPolicy</a>.
     *         </p>
     *         <p>
     *         Applications that contain one or more nested applications require you to specify CAPABILITY_AUTO_EXPAND.
     *         </p>
     *         <p>
     *         If your application template contains any of the above resources, we recommend that you review all
     *         permissions associated with the application before deploying. If you don't specify this parameter for an
     *         application that requires capabilities, the call will fail.
     */
    public List<String> requiredCapabilitiesAsStrings() {
        return requiredCapabilities;
    }

    /**
     * <p>
     * Whether all of the AWS resources contained in this application are supported in the region in which it is being
     * retrieved.
     * </p>
     * 
     * @return Whether all of the AWS resources contained in this application are supported in the region in which it is
     *         being retrieved.
     */
    public Boolean resourcesSupported() {
        return resourcesSupported;
    }

    /**
     * <p>
     * The semantic version of the application:
     * </p>
     * <p>
     * <a href="https://semver.org/">https://semver.org/</a>
     * </p>
     * 
     * @return The semantic version of the application:</p>
     *         <p>
     *         <a href="https://semver.org/">https://semver.org/</a>
     */
    public String semanticVersion() {
        return semanticVersion;
    }

    /**
     * <p>
     * A link to the S3 object that contains the ZIP archive of the source code for this version of your application.
     * </p>
     * <p>
     * Maximum size 50 MB
     * </p>
     * 
     * @return A link to the S3 object that contains the ZIP archive of the source code for this version of your
     *         application.</p>
     *         <p>
     *         Maximum size 50 MB
     */
    public String sourceCodeArchiveUrl() {
        return sourceCodeArchiveUrl;
    }

    /**
     * <p>
     * A link to a public repository for the source code of your application, for example the URL of a specific GitHub
     * commit.
     * </p>
     * 
     * @return A link to a public repository for the source code of your application, for example the URL of a specific
     *         GitHub commit.
     */
    public String sourceCodeUrl() {
        return sourceCodeUrl;
    }

    /**
     * <p>
     * A link to the packaged AWS SAM template of your application.
     * </p>
     * 
     * @return A link to the packaged AWS SAM template of your application.
     */
    public String templateUrl() {
        return templateUrl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(parameterDefinitions());
        hashCode = 31 * hashCode + Objects.hashCode(requiredCapabilitiesAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(resourcesSupported());
        hashCode = 31 * hashCode + Objects.hashCode(semanticVersion());
        hashCode = 31 * hashCode + Objects.hashCode(sourceCodeArchiveUrl());
        hashCode = 31 * hashCode + Objects.hashCode(sourceCodeUrl());
        hashCode = 31 * hashCode + Objects.hashCode(templateUrl());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Version)) {
            return false;
        }
        Version other = (Version) obj;
        return Objects.equals(applicationId(), other.applicationId()) && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(parameterDefinitions(), other.parameterDefinitions())
                && Objects.equals(requiredCapabilitiesAsStrings(), other.requiredCapabilitiesAsStrings())
                && Objects.equals(resourcesSupported(), other.resourcesSupported())
                && Objects.equals(semanticVersion(), other.semanticVersion())
                && Objects.equals(sourceCodeArchiveUrl(), other.sourceCodeArchiveUrl())
                && Objects.equals(sourceCodeUrl(), other.sourceCodeUrl()) && Objects.equals(templateUrl(), other.templateUrl());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Version").add("ApplicationId", applicationId()).add("CreationTime", creationTime())
                .add("ParameterDefinitions", parameterDefinitions()).add("RequiredCapabilities", requiredCapabilitiesAsStrings())
                .add("ResourcesSupported", resourcesSupported()).add("SemanticVersion", semanticVersion())
                .add("SourceCodeArchiveUrl", sourceCodeArchiveUrl()).add("SourceCodeUrl", sourceCodeUrl())
                .add("TemplateUrl", templateUrl()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "ParameterDefinitions":
            return Optional.ofNullable(clazz.cast(parameterDefinitions()));
        case "RequiredCapabilities":
            return Optional.ofNullable(clazz.cast(requiredCapabilitiesAsStrings()));
        case "ResourcesSupported":
            return Optional.ofNullable(clazz.cast(resourcesSupported()));
        case "SemanticVersion":
            return Optional.ofNullable(clazz.cast(semanticVersion()));
        case "SourceCodeArchiveUrl":
            return Optional.ofNullable(clazz.cast(sourceCodeArchiveUrl()));
        case "SourceCodeUrl":
            return Optional.ofNullable(clazz.cast(sourceCodeUrl()));
        case "TemplateUrl":
            return Optional.ofNullable(clazz.cast(templateUrl()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Version, T> g) {
        return obj -> g.apply((Version) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Version> {
        /**
         * <p>
         * The application Amazon Resource Name (ARN).
         * </p>
         * 
         * @param applicationId
         *        The application Amazon Resource Name (ARN).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * The date and time this resource was created.
         * </p>
         * 
         * @param creationTime
         *        The date and time this resource was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(String creationTime);

        /**
         * <p>
         * An array of parameter types supported by the application.
         * </p>
         * 
         * @param parameterDefinitions
         *        An array of parameter types supported by the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterDefinitions(Collection<ParameterDefinition> parameterDefinitions);

        /**
         * <p>
         * An array of parameter types supported by the application.
         * </p>
         * 
         * @param parameterDefinitions
         *        An array of parameter types supported by the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterDefinitions(ParameterDefinition... parameterDefinitions);

        /**
         * <p>
         * An array of parameter types supported by the application.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ParameterDefinition>.Builder} avoiding the
         * need to create one manually via {@link List<ParameterDefinition>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ParameterDefinition>.Builder#build()} is called immediately
         * and its result is passed to {@link #parameterDefinitions(List<ParameterDefinition>)}.
         * 
         * @param parameterDefinitions
         *        a consumer that will call methods on {@link List<ParameterDefinition>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parameterDefinitions(List<ParameterDefinition>)
         */
        Builder parameterDefinitions(Consumer<ParameterDefinition.Builder>... parameterDefinitions);

        /**
         * <p>
         * A list of values that you must specify before you can deploy certain applications. Some applications might
         * include resources that can affect permissions in your AWS account, for example, by creating new AWS Identity
         * and Access Management (IAM) users. For those applications, you must explicitly acknowledge their capabilities
         * by specifying this parameter.
         * </p>
         * <p>
         * The only valid values are CAPABILITY_IAM, CAPABILITY_NAMED_IAM, CAPABILITY_RESOURCE_POLICY, and
         * CAPABILITY_AUTO_EXPAND.
         * </p>
         * <p>
         * The following resources require you to specify CAPABILITY_IAM or CAPABILITY_NAMED_IAM: <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html"
         * >AWS::IAM::Group</a>, <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html"
         * >AWS::IAM::InstanceProfile</a>, <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-policy.html"
         * >AWS::IAM::Policy</a>, and <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html"
         * >AWS::IAM::Role</a>. If the application contains IAM resources, you can specify either CAPABILITY_IAM or
         * CAPABILITY_NAMED_IAM. If the application contains IAM resources with custom names, you must specify
         * CAPABILITY_NAMED_IAM.
         * </p>
         * <p>
         * The following resources require you to specify CAPABILITY_RESOURCE_POLICY: <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-permission.html"
         * >AWS::Lambda::Permission</a>, <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-policy.html"
         * >AWS::IAM:Policy</a>, <a href=
         * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html"
         * >AWS::ApplicationAutoScaling::ScalingPolicy</a>, <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-policy.html"
         * >AWS::S3::BucketPolicy</a>, <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-policy.html"
         * >AWS::SQS::QueuePolicy</a>, and <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sns-policy.html"
         * >AWS::SNS::TopicPolicy</a>.
         * </p>
         * <p>
         * Applications that contain one or more nested applications require you to specify CAPABILITY_AUTO_EXPAND.
         * </p>
         * <p>
         * If your application template contains any of the above resources, we recommend that you review all
         * permissions associated with the application before deploying. If you don't specify this parameter for an
         * application that requires capabilities, the call will fail.
         * </p>
         * 
         * @param requiredCapabilities
         *        A list of values that you must specify before you can deploy certain applications. Some applications
         *        might include resources that can affect permissions in your AWS account, for example, by creating new
         *        AWS Identity and Access Management (IAM) users. For those applications, you must explicitly
         *        acknowledge their capabilities by specifying this parameter.</p>
         *        <p>
         *        The only valid values are CAPABILITY_IAM, CAPABILITY_NAMED_IAM, CAPABILITY_RESOURCE_POLICY, and
         *        CAPABILITY_AUTO_EXPAND.
         *        </p>
         *        <p>
         *        The following resources require you to specify CAPABILITY_IAM or CAPABILITY_NAMED_IAM: <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html"
         *        >AWS::IAM::Group</a>, <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html"
         *        >AWS::IAM::InstanceProfile</a>, <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-policy.html"
         *        >AWS::IAM::Policy</a>, and <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html"
         *        >AWS::IAM::Role</a>. If the application contains IAM resources, you can specify either CAPABILITY_IAM
         *        or CAPABILITY_NAMED_IAM. If the application contains IAM resources with custom names, you must specify
         *        CAPABILITY_NAMED_IAM.
         *        </p>
         *        <p>
         *        The following resources require you to specify CAPABILITY_RESOURCE_POLICY: <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-permission.html"
         *        >AWS::Lambda::Permission</a>, <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-policy.html"
         *        >AWS::IAM:Policy</a>, <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html"
         *        >AWS::ApplicationAutoScaling::ScalingPolicy</a>, <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-policy.html"
         *        >AWS::S3::BucketPolicy</a>, <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-policy.html"
         *        >AWS::SQS::QueuePolicy</a>, and <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sns-policy.html"
         *        >AWS::SNS::TopicPolicy</a>.
         *        </p>
         *        <p>
         *        Applications that contain one or more nested applications require you to specify
         *        CAPABILITY_AUTO_EXPAND.
         *        </p>
         *        <p>
         *        If your application template contains any of the above resources, we recommend that you review all
         *        permissions associated with the application before deploying. If you don't specify this parameter for
         *        an application that requires capabilities, the call will fail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requiredCapabilitiesWithStrings(Collection<String> requiredCapabilities);

        /**
         * <p>
         * A list of values that you must specify before you can deploy certain applications. Some applications might
         * include resources that can affect permissions in your AWS account, for example, by creating new AWS Identity
         * and Access Management (IAM) users. For those applications, you must explicitly acknowledge their capabilities
         * by specifying this parameter.
         * </p>
         * <p>
         * The only valid values are CAPABILITY_IAM, CAPABILITY_NAMED_IAM, CAPABILITY_RESOURCE_POLICY, and
         * CAPABILITY_AUTO_EXPAND.
         * </p>
         * <p>
         * The following resources require you to specify CAPABILITY_IAM or CAPABILITY_NAMED_IAM: <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html"
         * >AWS::IAM::Group</a>, <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html"
         * >AWS::IAM::InstanceProfile</a>, <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-policy.html"
         * >AWS::IAM::Policy</a>, and <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html"
         * >AWS::IAM::Role</a>. If the application contains IAM resources, you can specify either CAPABILITY_IAM or
         * CAPABILITY_NAMED_IAM. If the application contains IAM resources with custom names, you must specify
         * CAPABILITY_NAMED_IAM.
         * </p>
         * <p>
         * The following resources require you to specify CAPABILITY_RESOURCE_POLICY: <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-permission.html"
         * >AWS::Lambda::Permission</a>, <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-policy.html"
         * >AWS::IAM:Policy</a>, <a href=
         * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html"
         * >AWS::ApplicationAutoScaling::ScalingPolicy</a>, <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-policy.html"
         * >AWS::S3::BucketPolicy</a>, <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-policy.html"
         * >AWS::SQS::QueuePolicy</a>, and <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sns-policy.html"
         * >AWS::SNS::TopicPolicy</a>.
         * </p>
         * <p>
         * Applications that contain one or more nested applications require you to specify CAPABILITY_AUTO_EXPAND.
         * </p>
         * <p>
         * If your application template contains any of the above resources, we recommend that you review all
         * permissions associated with the application before deploying. If you don't specify this parameter for an
         * application that requires capabilities, the call will fail.
         * </p>
         * 
         * @param requiredCapabilities
         *        A list of values that you must specify before you can deploy certain applications. Some applications
         *        might include resources that can affect permissions in your AWS account, for example, by creating new
         *        AWS Identity and Access Management (IAM) users. For those applications, you must explicitly
         *        acknowledge their capabilities by specifying this parameter.</p>
         *        <p>
         *        The only valid values are CAPABILITY_IAM, CAPABILITY_NAMED_IAM, CAPABILITY_RESOURCE_POLICY, and
         *        CAPABILITY_AUTO_EXPAND.
         *        </p>
         *        <p>
         *        The following resources require you to specify CAPABILITY_IAM or CAPABILITY_NAMED_IAM: <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html"
         *        >AWS::IAM::Group</a>, <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html"
         *        >AWS::IAM::InstanceProfile</a>, <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-policy.html"
         *        >AWS::IAM::Policy</a>, and <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html"
         *        >AWS::IAM::Role</a>. If the application contains IAM resources, you can specify either CAPABILITY_IAM
         *        or CAPABILITY_NAMED_IAM. If the application contains IAM resources with custom names, you must specify
         *        CAPABILITY_NAMED_IAM.
         *        </p>
         *        <p>
         *        The following resources require you to specify CAPABILITY_RESOURCE_POLICY: <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-permission.html"
         *        >AWS::Lambda::Permission</a>, <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-policy.html"
         *        >AWS::IAM:Policy</a>, <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html"
         *        >AWS::ApplicationAutoScaling::ScalingPolicy</a>, <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-policy.html"
         *        >AWS::S3::BucketPolicy</a>, <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-policy.html"
         *        >AWS::SQS::QueuePolicy</a>, and <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sns-policy.html"
         *        >AWS::SNS::TopicPolicy</a>.
         *        </p>
         *        <p>
         *        Applications that contain one or more nested applications require you to specify
         *        CAPABILITY_AUTO_EXPAND.
         *        </p>
         *        <p>
         *        If your application template contains any of the above resources, we recommend that you review all
         *        permissions associated with the application before deploying. If you don't specify this parameter for
         *        an application that requires capabilities, the call will fail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requiredCapabilitiesWithStrings(String... requiredCapabilities);

        /**
         * <p>
         * A list of values that you must specify before you can deploy certain applications. Some applications might
         * include resources that can affect permissions in your AWS account, for example, by creating new AWS Identity
         * and Access Management (IAM) users. For those applications, you must explicitly acknowledge their capabilities
         * by specifying this parameter.
         * </p>
         * <p>
         * The only valid values are CAPABILITY_IAM, CAPABILITY_NAMED_IAM, CAPABILITY_RESOURCE_POLICY, and
         * CAPABILITY_AUTO_EXPAND.
         * </p>
         * <p>
         * The following resources require you to specify CAPABILITY_IAM or CAPABILITY_NAMED_IAM: <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html"
         * >AWS::IAM::Group</a>, <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html"
         * >AWS::IAM::InstanceProfile</a>, <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-policy.html"
         * >AWS::IAM::Policy</a>, and <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html"
         * >AWS::IAM::Role</a>. If the application contains IAM resources, you can specify either CAPABILITY_IAM or
         * CAPABILITY_NAMED_IAM. If the application contains IAM resources with custom names, you must specify
         * CAPABILITY_NAMED_IAM.
         * </p>
         * <p>
         * The following resources require you to specify CAPABILITY_RESOURCE_POLICY: <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-permission.html"
         * >AWS::Lambda::Permission</a>, <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-policy.html"
         * >AWS::IAM:Policy</a>, <a href=
         * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html"
         * >AWS::ApplicationAutoScaling::ScalingPolicy</a>, <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-policy.html"
         * >AWS::S3::BucketPolicy</a>, <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-policy.html"
         * >AWS::SQS::QueuePolicy</a>, and <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sns-policy.html"
         * >AWS::SNS::TopicPolicy</a>.
         * </p>
         * <p>
         * Applications that contain one or more nested applications require you to specify CAPABILITY_AUTO_EXPAND.
         * </p>
         * <p>
         * If your application template contains any of the above resources, we recommend that you review all
         * permissions associated with the application before deploying. If you don't specify this parameter for an
         * application that requires capabilities, the call will fail.
         * </p>
         * 
         * @param requiredCapabilities
         *        A list of values that you must specify before you can deploy certain applications. Some applications
         *        might include resources that can affect permissions in your AWS account, for example, by creating new
         *        AWS Identity and Access Management (IAM) users. For those applications, you must explicitly
         *        acknowledge their capabilities by specifying this parameter.</p>
         *        <p>
         *        The only valid values are CAPABILITY_IAM, CAPABILITY_NAMED_IAM, CAPABILITY_RESOURCE_POLICY, and
         *        CAPABILITY_AUTO_EXPAND.
         *        </p>
         *        <p>
         *        The following resources require you to specify CAPABILITY_IAM or CAPABILITY_NAMED_IAM: <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html"
         *        >AWS::IAM::Group</a>, <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html"
         *        >AWS::IAM::InstanceProfile</a>, <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-policy.html"
         *        >AWS::IAM::Policy</a>, and <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html"
         *        >AWS::IAM::Role</a>. If the application contains IAM resources, you can specify either CAPABILITY_IAM
         *        or CAPABILITY_NAMED_IAM. If the application contains IAM resources with custom names, you must specify
         *        CAPABILITY_NAMED_IAM.
         *        </p>
         *        <p>
         *        The following resources require you to specify CAPABILITY_RESOURCE_POLICY: <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-permission.html"
         *        >AWS::Lambda::Permission</a>, <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-policy.html"
         *        >AWS::IAM:Policy</a>, <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html"
         *        >AWS::ApplicationAutoScaling::ScalingPolicy</a>, <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-policy.html"
         *        >AWS::S3::BucketPolicy</a>, <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-policy.html"
         *        >AWS::SQS::QueuePolicy</a>, and <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sns-policy.html"
         *        >AWS::SNS::TopicPolicy</a>.
         *        </p>
         *        <p>
         *        Applications that contain one or more nested applications require you to specify
         *        CAPABILITY_AUTO_EXPAND.
         *        </p>
         *        <p>
         *        If your application template contains any of the above resources, we recommend that you review all
         *        permissions associated with the application before deploying. If you don't specify this parameter for
         *        an application that requires capabilities, the call will fail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requiredCapabilities(Collection<Capability> requiredCapabilities);

        /**
         * <p>
         * A list of values that you must specify before you can deploy certain applications. Some applications might
         * include resources that can affect permissions in your AWS account, for example, by creating new AWS Identity
         * and Access Management (IAM) users. For those applications, you must explicitly acknowledge their capabilities
         * by specifying this parameter.
         * </p>
         * <p>
         * The only valid values are CAPABILITY_IAM, CAPABILITY_NAMED_IAM, CAPABILITY_RESOURCE_POLICY, and
         * CAPABILITY_AUTO_EXPAND.
         * </p>
         * <p>
         * The following resources require you to specify CAPABILITY_IAM or CAPABILITY_NAMED_IAM: <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html"
         * >AWS::IAM::Group</a>, <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html"
         * >AWS::IAM::InstanceProfile</a>, <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-policy.html"
         * >AWS::IAM::Policy</a>, and <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html"
         * >AWS::IAM::Role</a>. If the application contains IAM resources, you can specify either CAPABILITY_IAM or
         * CAPABILITY_NAMED_IAM. If the application contains IAM resources with custom names, you must specify
         * CAPABILITY_NAMED_IAM.
         * </p>
         * <p>
         * The following resources require you to specify CAPABILITY_RESOURCE_POLICY: <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-permission.html"
         * >AWS::Lambda::Permission</a>, <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-policy.html"
         * >AWS::IAM:Policy</a>, <a href=
         * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html"
         * >AWS::ApplicationAutoScaling::ScalingPolicy</a>, <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-policy.html"
         * >AWS::S3::BucketPolicy</a>, <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-policy.html"
         * >AWS::SQS::QueuePolicy</a>, and <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sns-policy.html"
         * >AWS::SNS::TopicPolicy</a>.
         * </p>
         * <p>
         * Applications that contain one or more nested applications require you to specify CAPABILITY_AUTO_EXPAND.
         * </p>
         * <p>
         * If your application template contains any of the above resources, we recommend that you review all
         * permissions associated with the application before deploying. If you don't specify this parameter for an
         * application that requires capabilities, the call will fail.
         * </p>
         * 
         * @param requiredCapabilities
         *        A list of values that you must specify before you can deploy certain applications. Some applications
         *        might include resources that can affect permissions in your AWS account, for example, by creating new
         *        AWS Identity and Access Management (IAM) users. For those applications, you must explicitly
         *        acknowledge their capabilities by specifying this parameter.</p>
         *        <p>
         *        The only valid values are CAPABILITY_IAM, CAPABILITY_NAMED_IAM, CAPABILITY_RESOURCE_POLICY, and
         *        CAPABILITY_AUTO_EXPAND.
         *        </p>
         *        <p>
         *        The following resources require you to specify CAPABILITY_IAM or CAPABILITY_NAMED_IAM: <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html"
         *        >AWS::IAM::Group</a>, <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html"
         *        >AWS::IAM::InstanceProfile</a>, <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-policy.html"
         *        >AWS::IAM::Policy</a>, and <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html"
         *        >AWS::IAM::Role</a>. If the application contains IAM resources, you can specify either CAPABILITY_IAM
         *        or CAPABILITY_NAMED_IAM. If the application contains IAM resources with custom names, you must specify
         *        CAPABILITY_NAMED_IAM.
         *        </p>
         *        <p>
         *        The following resources require you to specify CAPABILITY_RESOURCE_POLICY: <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-permission.html"
         *        >AWS::Lambda::Permission</a>, <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-policy.html"
         *        >AWS::IAM:Policy</a>, <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html"
         *        >AWS::ApplicationAutoScaling::ScalingPolicy</a>, <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-policy.html"
         *        >AWS::S3::BucketPolicy</a>, <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-policy.html"
         *        >AWS::SQS::QueuePolicy</a>, and <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sns-policy.html"
         *        >AWS::SNS::TopicPolicy</a>.
         *        </p>
         *        <p>
         *        Applications that contain one or more nested applications require you to specify
         *        CAPABILITY_AUTO_EXPAND.
         *        </p>
         *        <p>
         *        If your application template contains any of the above resources, we recommend that you review all
         *        permissions associated with the application before deploying. If you don't specify this parameter for
         *        an application that requires capabilities, the call will fail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requiredCapabilities(Capability... requiredCapabilities);

        /**
         * <p>
         * Whether all of the AWS resources contained in this application are supported in the region in which it is
         * being retrieved.
         * </p>
         * 
         * @param resourcesSupported
         *        Whether all of the AWS resources contained in this application are supported in the region in which it
         *        is being retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourcesSupported(Boolean resourcesSupported);

        /**
         * <p>
         * The semantic version of the application:
         * </p>
         * <p>
         * <a href="https://semver.org/">https://semver.org/</a>
         * </p>
         * 
         * @param semanticVersion
         *        The semantic version of the application:</p>
         *        <p>
         *        <a href="https://semver.org/">https://semver.org/</a>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder semanticVersion(String semanticVersion);

        /**
         * <p>
         * A link to the S3 object that contains the ZIP archive of the source code for this version of your
         * application.
         * </p>
         * <p>
         * Maximum size 50 MB
         * </p>
         * 
         * @param sourceCodeArchiveUrl
         *        A link to the S3 object that contains the ZIP archive of the source code for this version of your
         *        application.</p>
         *        <p>
         *        Maximum size 50 MB
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceCodeArchiveUrl(String sourceCodeArchiveUrl);

        /**
         * <p>
         * A link to a public repository for the source code of your application, for example the URL of a specific
         * GitHub commit.
         * </p>
         * 
         * @param sourceCodeUrl
         *        A link to a public repository for the source code of your application, for example the URL of a
         *        specific GitHub commit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceCodeUrl(String sourceCodeUrl);

        /**
         * <p>
         * A link to the packaged AWS SAM template of your application.
         * </p>
         * 
         * @param templateUrl
         *        A link to the packaged AWS SAM template of your application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateUrl(String templateUrl);
    }

    static final class BuilderImpl implements Builder {
        private String applicationId;

        private String creationTime;

        private List<ParameterDefinition> parameterDefinitions = DefaultSdkAutoConstructList.getInstance();

        private List<String> requiredCapabilities = DefaultSdkAutoConstructList.getInstance();

        private Boolean resourcesSupported;

        private String semanticVersion;

        private String sourceCodeArchiveUrl;

        private String sourceCodeUrl;

        private String templateUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(Version model) {
            applicationId(model.applicationId);
            creationTime(model.creationTime);
            parameterDefinitions(model.parameterDefinitions);
            requiredCapabilitiesWithStrings(model.requiredCapabilities);
            resourcesSupported(model.resourcesSupported);
            semanticVersion(model.semanticVersion);
            sourceCodeArchiveUrl(model.sourceCodeArchiveUrl);
            sourceCodeUrl(model.sourceCodeUrl);
            templateUrl(model.templateUrl);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final String getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(String creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(String creationTime) {
            this.creationTime = creationTime;
        }

        public final Collection<ParameterDefinition.Builder> getParameterDefinitions() {
            return parameterDefinitions != null ? parameterDefinitions.stream().map(ParameterDefinition::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder parameterDefinitions(Collection<ParameterDefinition> parameterDefinitions) {
            this.parameterDefinitions = ___listOfParameterDefinitionCopier.copy(parameterDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterDefinitions(ParameterDefinition... parameterDefinitions) {
            parameterDefinitions(Arrays.asList(parameterDefinitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterDefinitions(Consumer<ParameterDefinition.Builder>... parameterDefinitions) {
            parameterDefinitions(Stream.of(parameterDefinitions).map(c -> ParameterDefinition.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setParameterDefinitions(Collection<ParameterDefinition.BuilderImpl> parameterDefinitions) {
            this.parameterDefinitions = ___listOfParameterDefinitionCopier.copyFromBuilder(parameterDefinitions);
        }

        public final Collection<String> getRequiredCapabilitiesAsStrings() {
            return requiredCapabilities;
        }

        @Override
        public final Builder requiredCapabilitiesWithStrings(Collection<String> requiredCapabilities) {
            this.requiredCapabilities = ___listOfCapabilityCopier.copy(requiredCapabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder requiredCapabilitiesWithStrings(String... requiredCapabilities) {
            requiredCapabilitiesWithStrings(Arrays.asList(requiredCapabilities));
            return this;
        }

        @Override
        public final Builder requiredCapabilities(Collection<Capability> requiredCapabilities) {
            this.requiredCapabilities = ___listOfCapabilityCopier.copyEnumToString(requiredCapabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder requiredCapabilities(Capability... requiredCapabilities) {
            requiredCapabilities(Arrays.asList(requiredCapabilities));
            return this;
        }

        public final void setRequiredCapabilitiesWithStrings(Collection<String> requiredCapabilities) {
            this.requiredCapabilities = ___listOfCapabilityCopier.copy(requiredCapabilities);
        }

        public final Boolean getResourcesSupported() {
            return resourcesSupported;
        }

        @Override
        public final Builder resourcesSupported(Boolean resourcesSupported) {
            this.resourcesSupported = resourcesSupported;
            return this;
        }

        public final void setResourcesSupported(Boolean resourcesSupported) {
            this.resourcesSupported = resourcesSupported;
        }

        public final String getSemanticVersion() {
            return semanticVersion;
        }

        @Override
        public final Builder semanticVersion(String semanticVersion) {
            this.semanticVersion = semanticVersion;
            return this;
        }

        public final void setSemanticVersion(String semanticVersion) {
            this.semanticVersion = semanticVersion;
        }

        public final String getSourceCodeArchiveUrl() {
            return sourceCodeArchiveUrl;
        }

        @Override
        public final Builder sourceCodeArchiveUrl(String sourceCodeArchiveUrl) {
            this.sourceCodeArchiveUrl = sourceCodeArchiveUrl;
            return this;
        }

        public final void setSourceCodeArchiveUrl(String sourceCodeArchiveUrl) {
            this.sourceCodeArchiveUrl = sourceCodeArchiveUrl;
        }

        public final String getSourceCodeUrl() {
            return sourceCodeUrl;
        }

        @Override
        public final Builder sourceCodeUrl(String sourceCodeUrl) {
            this.sourceCodeUrl = sourceCodeUrl;
            return this;
        }

        public final void setSourceCodeUrl(String sourceCodeUrl) {
            this.sourceCodeUrl = sourceCodeUrl;
        }

        public final String getTemplateUrl() {
            return templateUrl;
        }

        @Override
        public final Builder templateUrl(String templateUrl) {
            this.templateUrl = templateUrl;
            return this;
        }

        public final void setTemplateUrl(String templateUrl) {
            this.templateUrl = templateUrl;
        }

        @Override
        public Version build() {
            return new Version(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
