/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.serverlessapplicationrepository.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.CreateCloudFormationChangeSetRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CreateCloudFormationChangeSetRequestModelMarshaller {
    private static final MarshallingInfo<String> APPLICATIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("applicationId").isBinary(false).build();
    private static final MarshallingInfo<List> PARAMETEROVERRIDES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("parameterOverrides").isBinary(false).build();
    private static final MarshallingInfo<String> SEMANTICVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("semanticVersion").isBinary(false).build();
    private static final MarshallingInfo<String> STACKNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("stackName").isBinary(false).build();
    private static final CreateCloudFormationChangeSetRequestModelMarshaller INSTANCE = new CreateCloudFormationChangeSetRequestModelMarshaller();

    private CreateCloudFormationChangeSetRequestModelMarshaller() {
    }

    public static CreateCloudFormationChangeSetRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CreateCloudFormationChangeSetRequest createCloudFormationChangeSetRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)createCloudFormationChangeSetRequest), (String)"createCloudFormationChangeSetRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)createCloudFormationChangeSetRequest.applicationId(), APPLICATIONID_BINDING);
            protocolMarshaller.marshall(createCloudFormationChangeSetRequest.parameterOverrides(), PARAMETEROVERRIDES_BINDING);
            protocolMarshaller.marshall((Object)createCloudFormationChangeSetRequest.semanticVersion(), SEMANTICVERSION_BINDING);
            protocolMarshaller.marshall((Object)createCloudFormationChangeSetRequest.stackName(), STACKNAME_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

