/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securitylake.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securitylake.model.CustomLogSourceConfiguration;
import software.amazon.awssdk.services.securitylake.model.OcsfEventClassListCopier;
import software.amazon.awssdk.services.securitylake.model.SecurityLakeRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateCustomLogSourceRequest
extends SecurityLakeRequest
implements ToCopyableBuilder<Builder, CreateCustomLogSourceRequest> {
    private static final SdkField<CustomLogSourceConfiguration> CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("configuration").getter(CreateCustomLogSourceRequest.getter(CreateCustomLogSourceRequest::configuration)).setter(CreateCustomLogSourceRequest.setter(Builder::configuration)).constructor(CustomLogSourceConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()}).build();
    private static final SdkField<List<String>> EVENT_CLASSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("eventClasses").getter(CreateCustomLogSourceRequest.getter(CreateCustomLogSourceRequest::eventClasses)).setter(CreateCustomLogSourceRequest.setter(Builder::eventClasses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventClasses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SOURCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceName").getter(CreateCustomLogSourceRequest.getter(CreateCustomLogSourceRequest::sourceName)).setter(CreateCustomLogSourceRequest.setter(Builder::sourceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceName").build()}).build();
    private static final SdkField<String> SOURCE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceVersion").getter(CreateCustomLogSourceRequest.getter(CreateCustomLogSourceRequest::sourceVersion)).setter(CreateCustomLogSourceRequest.setter(Builder::sourceVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_FIELD, EVENT_CLASSES_FIELD, SOURCE_NAME_FIELD, SOURCE_VERSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateCustomLogSourceRequest.memberNameToFieldInitializer();
    private final CustomLogSourceConfiguration configuration;
    private final List<String> eventClasses;
    private final String sourceName;
    private final String sourceVersion;

    private CreateCustomLogSourceRequest(BuilderImpl builder) {
        super(builder);
        this.configuration = builder.configuration;
        this.eventClasses = builder.eventClasses;
        this.sourceName = builder.sourceName;
        this.sourceVersion = builder.sourceVersion;
    }

    public final CustomLogSourceConfiguration configuration() {
        return this.configuration;
    }

    public final boolean hasEventClasses() {
        return this.eventClasses != null && !(this.eventClasses instanceof SdkAutoConstructList);
    }

    public final List<String> eventClasses() {
        return this.eventClasses;
    }

    public final String sourceName() {
        return this.sourceName;
    }

    public final String sourceVersion() {
        return this.sourceVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.configuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEventClasses() ? this.eventClasses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCustomLogSourceRequest)) {
            return false;
        }
        CreateCustomLogSourceRequest other = (CreateCustomLogSourceRequest)((Object)obj);
        return Objects.equals(this.configuration(), other.configuration()) && this.hasEventClasses() == other.hasEventClasses() && Objects.equals(this.eventClasses(), other.eventClasses()) && Objects.equals(this.sourceName(), other.sourceName()) && Objects.equals(this.sourceVersion(), other.sourceVersion());
    }

    public final String toString() {
        return ToString.builder((String)"CreateCustomLogSourceRequest").add("Configuration", (Object)this.configuration()).add("EventClasses", this.hasEventClasses() ? this.eventClasses() : null).add("SourceName", (Object)this.sourceName()).add("SourceVersion", (Object)this.sourceVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "configuration": {
                return Optional.ofNullable(clazz.cast(this.configuration()));
            }
            case "eventClasses": {
                return Optional.ofNullable(clazz.cast(this.eventClasses()));
            }
            case "sourceName": {
                return Optional.ofNullable(clazz.cast(this.sourceName()));
            }
            case "sourceVersion": {
                return Optional.ofNullable(clazz.cast(this.sourceVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("configuration", CONFIGURATION_FIELD);
        map.put("eventClasses", EVENT_CLASSES_FIELD);
        map.put("sourceName", SOURCE_NAME_FIELD);
        map.put("sourceVersion", SOURCE_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateCustomLogSourceRequest, T> g) {
        return obj -> g.apply((CreateCustomLogSourceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SecurityLakeRequest.BuilderImpl
    implements Builder {
        private CustomLogSourceConfiguration configuration;
        private List<String> eventClasses = DefaultSdkAutoConstructList.getInstance();
        private String sourceName;
        private String sourceVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCustomLogSourceRequest model) {
            super(model);
            this.configuration(model.configuration);
            this.eventClasses(model.eventClasses);
            this.sourceName(model.sourceName);
            this.sourceVersion(model.sourceVersion);
        }

        public final CustomLogSourceConfiguration.Builder getConfiguration() {
            return this.configuration != null ? this.configuration.toBuilder() : null;
        }

        public final void setConfiguration(CustomLogSourceConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(CustomLogSourceConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final Collection<String> getEventClasses() {
            if (this.eventClasses instanceof SdkAutoConstructList) {
                return null;
            }
            return this.eventClasses;
        }

        public final void setEventClasses(Collection<String> eventClasses) {
            this.eventClasses = OcsfEventClassListCopier.copy(eventClasses);
        }

        @Override
        public final Builder eventClasses(Collection<String> eventClasses) {
            this.eventClasses = OcsfEventClassListCopier.copy(eventClasses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventClasses(String ... eventClasses) {
            this.eventClasses(Arrays.asList(eventClasses));
            return this;
        }

        public final String getSourceName() {
            return this.sourceName;
        }

        public final void setSourceName(String sourceName) {
            this.sourceName = sourceName;
        }

        @Override
        public final Builder sourceName(String sourceName) {
            this.sourceName = sourceName;
            return this;
        }

        public final String getSourceVersion() {
            return this.sourceVersion;
        }

        public final void setSourceVersion(String sourceVersion) {
            this.sourceVersion = sourceVersion;
        }

        @Override
        public final Builder sourceVersion(String sourceVersion) {
            this.sourceVersion = sourceVersion;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCustomLogSourceRequest build() {
            return new CreateCustomLogSourceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SecurityLakeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateCustomLogSourceRequest> {
        public Builder configuration(CustomLogSourceConfiguration var1);

        default public Builder configuration(Consumer<CustomLogSourceConfiguration.Builder> configuration) {
            return this.configuration((CustomLogSourceConfiguration)((CustomLogSourceConfiguration.Builder)CustomLogSourceConfiguration.builder().applyMutation(configuration)).build());
        }

        public Builder eventClasses(Collection<String> var1);

        public Builder eventClasses(String ... var1);

        public Builder sourceName(String var1);

        public Builder sourceVersion(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

