/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securitylake.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.securitylake.model.HttpMethod;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HttpsNotificationConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HttpsNotificationConfiguration> {
    private static final SdkField<String> AUTHORIZATION_API_KEY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("authorizationApiKeyName").getter(HttpsNotificationConfiguration.getter(HttpsNotificationConfiguration::authorizationApiKeyName)).setter(HttpsNotificationConfiguration.setter(Builder::authorizationApiKeyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorizationApiKeyName").build()}).build();
    private static final SdkField<String> AUTHORIZATION_API_KEY_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("authorizationApiKeyValue").getter(HttpsNotificationConfiguration.getter(HttpsNotificationConfiguration::authorizationApiKeyValue)).setter(HttpsNotificationConfiguration.setter(Builder::authorizationApiKeyValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorizationApiKeyValue").build()}).build();
    private static final SdkField<String> ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("endpoint").getter(HttpsNotificationConfiguration.getter(HttpsNotificationConfiguration::endpoint)).setter(HttpsNotificationConfiguration.setter(Builder::endpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpoint").build()}).build();
    private static final SdkField<String> HTTP_METHOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("httpMethod").getter(HttpsNotificationConfiguration.getter(HttpsNotificationConfiguration::httpMethodAsString)).setter(HttpsNotificationConfiguration.setter(Builder::httpMethod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("httpMethod").build()}).build();
    private static final SdkField<String> TARGET_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetRoleArn").getter(HttpsNotificationConfiguration.getter(HttpsNotificationConfiguration::targetRoleArn)).setter(HttpsNotificationConfiguration.setter(Builder::targetRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetRoleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHORIZATION_API_KEY_NAME_FIELD, AUTHORIZATION_API_KEY_VALUE_FIELD, ENDPOINT_FIELD, HTTP_METHOD_FIELD, TARGET_ROLE_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("authorizationApiKeyName", AUTHORIZATION_API_KEY_NAME_FIELD);
            this.put("authorizationApiKeyValue", AUTHORIZATION_API_KEY_VALUE_FIELD);
            this.put("endpoint", ENDPOINT_FIELD);
            this.put("httpMethod", HTTP_METHOD_FIELD);
            this.put("targetRoleArn", TARGET_ROLE_ARN_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String authorizationApiKeyName;
    private final String authorizationApiKeyValue;
    private final String endpoint;
    private final String httpMethod;
    private final String targetRoleArn;

    private HttpsNotificationConfiguration(BuilderImpl builder) {
        this.authorizationApiKeyName = builder.authorizationApiKeyName;
        this.authorizationApiKeyValue = builder.authorizationApiKeyValue;
        this.endpoint = builder.endpoint;
        this.httpMethod = builder.httpMethod;
        this.targetRoleArn = builder.targetRoleArn;
    }

    public final String authorizationApiKeyName() {
        return this.authorizationApiKeyName;
    }

    public final String authorizationApiKeyValue() {
        return this.authorizationApiKeyValue;
    }

    public final String endpoint() {
        return this.endpoint;
    }

    public final HttpMethod httpMethod() {
        return HttpMethod.fromValue(this.httpMethod);
    }

    public final String httpMethodAsString() {
        return this.httpMethod;
    }

    public final String targetRoleArn() {
        return this.targetRoleArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.authorizationApiKeyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.authorizationApiKeyValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.httpMethodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetRoleArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HttpsNotificationConfiguration)) {
            return false;
        }
        HttpsNotificationConfiguration other = (HttpsNotificationConfiguration)obj;
        return Objects.equals(this.authorizationApiKeyName(), other.authorizationApiKeyName()) && Objects.equals(this.authorizationApiKeyValue(), other.authorizationApiKeyValue()) && Objects.equals(this.endpoint(), other.endpoint()) && Objects.equals(this.httpMethodAsString(), other.httpMethodAsString()) && Objects.equals(this.targetRoleArn(), other.targetRoleArn());
    }

    public final String toString() {
        return ToString.builder((String)"HttpsNotificationConfiguration").add("AuthorizationApiKeyName", (Object)this.authorizationApiKeyName()).add("AuthorizationApiKeyValue", (Object)this.authorizationApiKeyValue()).add("Endpoint", (Object)this.endpoint()).add("HttpMethod", (Object)this.httpMethodAsString()).add("TargetRoleArn", (Object)this.targetRoleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "authorizationApiKeyName": {
                return Optional.ofNullable(clazz.cast(this.authorizationApiKeyName()));
            }
            case "authorizationApiKeyValue": {
                return Optional.ofNullable(clazz.cast(this.authorizationApiKeyValue()));
            }
            case "endpoint": {
                return Optional.ofNullable(clazz.cast(this.endpoint()));
            }
            case "httpMethod": {
                return Optional.ofNullable(clazz.cast(this.httpMethodAsString()));
            }
            case "targetRoleArn": {
                return Optional.ofNullable(clazz.cast(this.targetRoleArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<HttpsNotificationConfiguration, T> g) {
        return obj -> g.apply((HttpsNotificationConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String authorizationApiKeyName;
        private String authorizationApiKeyValue;
        private String endpoint;
        private String httpMethod;
        private String targetRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(HttpsNotificationConfiguration model) {
            this.authorizationApiKeyName(model.authorizationApiKeyName);
            this.authorizationApiKeyValue(model.authorizationApiKeyValue);
            this.endpoint(model.endpoint);
            this.httpMethod(model.httpMethod);
            this.targetRoleArn(model.targetRoleArn);
        }

        public final String getAuthorizationApiKeyName() {
            return this.authorizationApiKeyName;
        }

        public final void setAuthorizationApiKeyName(String authorizationApiKeyName) {
            this.authorizationApiKeyName = authorizationApiKeyName;
        }

        @Override
        public final Builder authorizationApiKeyName(String authorizationApiKeyName) {
            this.authorizationApiKeyName = authorizationApiKeyName;
            return this;
        }

        public final String getAuthorizationApiKeyValue() {
            return this.authorizationApiKeyValue;
        }

        public final void setAuthorizationApiKeyValue(String authorizationApiKeyValue) {
            this.authorizationApiKeyValue = authorizationApiKeyValue;
        }

        @Override
        public final Builder authorizationApiKeyValue(String authorizationApiKeyValue) {
            this.authorizationApiKeyValue = authorizationApiKeyValue;
            return this;
        }

        public final String getEndpoint() {
            return this.endpoint;
        }

        public final void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        @Override
        public final Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final String getHttpMethod() {
            return this.httpMethod;
        }

        public final void setHttpMethod(String httpMethod) {
            this.httpMethod = httpMethod;
        }

        @Override
        public final Builder httpMethod(String httpMethod) {
            this.httpMethod = httpMethod;
            return this;
        }

        @Override
        public final Builder httpMethod(HttpMethod httpMethod) {
            this.httpMethod(httpMethod == null ? null : httpMethod.toString());
            return this;
        }

        public final String getTargetRoleArn() {
            return this.targetRoleArn;
        }

        public final void setTargetRoleArn(String targetRoleArn) {
            this.targetRoleArn = targetRoleArn;
        }

        @Override
        public final Builder targetRoleArn(String targetRoleArn) {
            this.targetRoleArn = targetRoleArn;
            return this;
        }

        public HttpsNotificationConfiguration build() {
            return new HttpsNotificationConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HttpsNotificationConfiguration> {
        public Builder authorizationApiKeyName(String var1);

        public Builder authorizationApiKeyValue(String var1);

        public Builder endpoint(String var1);

        public Builder httpMethod(String var1);

        public Builder httpMethod(HttpMethod var1);

        public Builder targetRoleArn(String var1);
    }
}

