/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securitylake.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securitylake.model.AccountListCopier;
import software.amazon.awssdk.services.securitylake.model.LogSourceResource;
import software.amazon.awssdk.services.securitylake.model.LogSourceResourceListCopier;
import software.amazon.awssdk.services.securitylake.model.RegionListCopier;
import software.amazon.awssdk.services.securitylake.model.SecurityLakeRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListLogSourcesRequest
extends SecurityLakeRequest
implements ToCopyableBuilder<Builder, ListLogSourcesRequest> {
    private static final SdkField<List<String>> ACCOUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("accounts").getter(ListLogSourcesRequest.getter(ListLogSourcesRequest::accounts)).setter(ListLogSourcesRequest.setter(Builder::accounts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accounts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListLogSourcesRequest.getter(ListLogSourcesRequest::maxResults)).setter(ListLogSourcesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListLogSourcesRequest.getter(ListLogSourcesRequest::nextToken)).setter(ListLogSourcesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<String>> REGIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("regions").getter(ListLogSourcesRequest.getter(ListLogSourcesRequest::regions)).setter(ListLogSourcesRequest.setter(Builder::regions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("regions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<LogSourceResource>> SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("sources").getter(ListLogSourcesRequest.getter(ListLogSourcesRequest::sources)).setter(ListLogSourcesRequest.setter(Builder::sources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LogSourceResource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNTS_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, REGIONS_FIELD, SOURCES_FIELD));
    private final List<String> accounts;
    private final Integer maxResults;
    private final String nextToken;
    private final List<String> regions;
    private final List<LogSourceResource> sources;

    private ListLogSourcesRequest(BuilderImpl builder) {
        super(builder);
        this.accounts = builder.accounts;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.regions = builder.regions;
        this.sources = builder.sources;
    }

    public final boolean hasAccounts() {
        return this.accounts != null && !(this.accounts instanceof SdkAutoConstructList);
    }

    public final List<String> accounts() {
        return this.accounts;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasRegions() {
        return this.regions != null && !(this.regions instanceof SdkAutoConstructList);
    }

    public final List<String> regions() {
        return this.regions;
    }

    public final boolean hasSources() {
        return this.sources != null && !(this.sources instanceof SdkAutoConstructList);
    }

    public final List<LogSourceResource> sources() {
        return this.sources;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAccounts() ? this.accounts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRegions() ? this.regions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSources() ? this.sources() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLogSourcesRequest)) {
            return false;
        }
        ListLogSourcesRequest other = (ListLogSourcesRequest)((Object)obj);
        return this.hasAccounts() == other.hasAccounts() && Objects.equals(this.accounts(), other.accounts()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && this.hasRegions() == other.hasRegions() && Objects.equals(this.regions(), other.regions()) && this.hasSources() == other.hasSources() && Objects.equals(this.sources(), other.sources());
    }

    public final String toString() {
        return ToString.builder((String)"ListLogSourcesRequest").add("Accounts", this.hasAccounts() ? this.accounts() : null).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("Regions", this.hasRegions() ? this.regions() : null).add("Sources", this.hasSources() ? this.sources() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accounts": {
                return Optional.ofNullable(clazz.cast(this.accounts()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "regions": {
                return Optional.ofNullable(clazz.cast(this.regions()));
            }
            case "sources": {
                return Optional.ofNullable(clazz.cast(this.sources()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListLogSourcesRequest, T> g) {
        return obj -> g.apply((ListLogSourcesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SecurityLakeRequest.BuilderImpl
    implements Builder {
        private List<String> accounts = DefaultSdkAutoConstructList.getInstance();
        private Integer maxResults;
        private String nextToken;
        private List<String> regions = DefaultSdkAutoConstructList.getInstance();
        private List<LogSourceResource> sources = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListLogSourcesRequest model) {
            super(model);
            this.accounts(model.accounts);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.regions(model.regions);
            this.sources(model.sources);
        }

        public final Collection<String> getAccounts() {
            if (this.accounts instanceof SdkAutoConstructList) {
                return null;
            }
            return this.accounts;
        }

        public final void setAccounts(Collection<String> accounts) {
            this.accounts = AccountListCopier.copy(accounts);
        }

        @Override
        public final Builder accounts(Collection<String> accounts) {
            this.accounts = AccountListCopier.copy(accounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accounts(String ... accounts) {
            this.accounts(Arrays.asList(accounts));
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Collection<String> getRegions() {
            if (this.regions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.regions;
        }

        public final void setRegions(Collection<String> regions) {
            this.regions = RegionListCopier.copy(regions);
        }

        @Override
        public final Builder regions(Collection<String> regions) {
            this.regions = RegionListCopier.copy(regions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regions(String ... regions) {
            this.regions(Arrays.asList(regions));
            return this;
        }

        public final List<LogSourceResource.Builder> getSources() {
            List<LogSourceResource.Builder> result = LogSourceResourceListCopier.copyToBuilder(this.sources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSources(Collection<LogSourceResource.BuilderImpl> sources) {
            this.sources = LogSourceResourceListCopier.copyFromBuilder(sources);
        }

        @Override
        public final Builder sources(Collection<LogSourceResource> sources) {
            this.sources = LogSourceResourceListCopier.copy(sources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(LogSourceResource ... sources) {
            this.sources(Arrays.asList(sources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(Consumer<LogSourceResource.Builder> ... sources) {
            this.sources(Stream.of(sources).map(c -> (LogSourceResource)((LogSourceResource.Builder)LogSourceResource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListLogSourcesRequest build() {
            return new ListLogSourcesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SecurityLakeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListLogSourcesRequest> {
        public Builder accounts(Collection<String> var1);

        public Builder accounts(String ... var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder regions(Collection<String> var1);

        public Builder regions(String ... var1);

        public Builder sources(Collection<LogSourceResource> var1);

        public Builder sources(LogSourceResource ... var1);

        public Builder sources(Consumer<LogSourceResource.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

