/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securitylake.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securitylake.model.LogsStatus;
import software.amazon.awssdk.services.securitylake.model.LogsStatusListCopier;
import software.amazon.awssdk.services.securitylake.model.OcsfEventClass;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AccountSources
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AccountSources> {
    private static final SdkField<String> ACCOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("account").getter(AccountSources.getter(AccountSources::account)).setter(AccountSources.setter(Builder::account)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("account").build()}).build();
    private static final SdkField<String> EVENT_CLASS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("eventClass").getter(AccountSources.getter(AccountSources::eventClassAsString)).setter(AccountSources.setter(Builder::eventClass)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventClass").build()}).build();
    private static final SdkField<List<LogsStatus>> LOGS_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("logsStatus").getter(AccountSources.getter(AccountSources::logsStatus)).setter(AccountSources.setter(Builder::logsStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logsStatus").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LogsStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceType").getter(AccountSources.getter(AccountSources::sourceType)).setter(AccountSources.setter(Builder::sourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_FIELD, EVENT_CLASS_FIELD, LOGS_STATUS_FIELD, SOURCE_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String account;
    private final String eventClass;
    private final List<LogsStatus> logsStatus;
    private final String sourceType;

    private AccountSources(BuilderImpl builder) {
        this.account = builder.account;
        this.eventClass = builder.eventClass;
        this.logsStatus = builder.logsStatus;
        this.sourceType = builder.sourceType;
    }

    public final String account() {
        return this.account;
    }

    public final OcsfEventClass eventClass() {
        return OcsfEventClass.fromValue(this.eventClass);
    }

    public final String eventClassAsString() {
        return this.eventClass;
    }

    public final boolean hasLogsStatus() {
        return this.logsStatus != null && !(this.logsStatus instanceof SdkAutoConstructList);
    }

    public final List<LogsStatus> logsStatus() {
        return this.logsStatus;
    }

    public final String sourceType() {
        return this.sourceType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.account());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventClassAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLogsStatus() ? this.logsStatus() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceType());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountSources)) {
            return false;
        }
        AccountSources other = (AccountSources)obj;
        return Objects.equals(this.account(), other.account()) && Objects.equals(this.eventClassAsString(), other.eventClassAsString()) && this.hasLogsStatus() == other.hasLogsStatus() && Objects.equals(this.logsStatus(), other.logsStatus()) && Objects.equals(this.sourceType(), other.sourceType());
    }

    public final String toString() {
        return ToString.builder((String)"AccountSources").add("Account", (Object)this.account()).add("EventClass", (Object)this.eventClassAsString()).add("LogsStatus", this.hasLogsStatus() ? this.logsStatus() : null).add("SourceType", (Object)this.sourceType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "account": {
                return Optional.ofNullable(clazz.cast(this.account()));
            }
            case "eventClass": {
                return Optional.ofNullable(clazz.cast(this.eventClassAsString()));
            }
            case "logsStatus": {
                return Optional.ofNullable(clazz.cast(this.logsStatus()));
            }
            case "sourceType": {
                return Optional.ofNullable(clazz.cast(this.sourceType()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AccountSources, T> g) {
        return obj -> g.apply((AccountSources)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String account;
        private String eventClass;
        private List<LogsStatus> logsStatus = DefaultSdkAutoConstructList.getInstance();
        private String sourceType;

        private BuilderImpl() {
        }

        private BuilderImpl(AccountSources model) {
            this.account(model.account);
            this.eventClass(model.eventClass);
            this.logsStatus(model.logsStatus);
            this.sourceType(model.sourceType);
        }

        public final String getAccount() {
            return this.account;
        }

        public final void setAccount(String account) {
            this.account = account;
        }

        @Override
        public final Builder account(String account) {
            this.account = account;
            return this;
        }

        public final String getEventClass() {
            return this.eventClass;
        }

        public final void setEventClass(String eventClass) {
            this.eventClass = eventClass;
        }

        @Override
        public final Builder eventClass(String eventClass) {
            this.eventClass = eventClass;
            return this;
        }

        @Override
        public final Builder eventClass(OcsfEventClass eventClass) {
            this.eventClass(eventClass == null ? null : eventClass.toString());
            return this;
        }

        public final List<LogsStatus.Builder> getLogsStatus() {
            List<LogsStatus.Builder> result = LogsStatusListCopier.copyToBuilder(this.logsStatus);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLogsStatus(Collection<LogsStatus.BuilderImpl> logsStatus) {
            this.logsStatus = LogsStatusListCopier.copyFromBuilder(logsStatus);
        }

        @Override
        public final Builder logsStatus(Collection<LogsStatus> logsStatus) {
            this.logsStatus = LogsStatusListCopier.copy(logsStatus);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logsStatus(LogsStatus ... logsStatus) {
            this.logsStatus(Arrays.asList(logsStatus));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logsStatus(Consumer<LogsStatus.Builder> ... logsStatus) {
            this.logsStatus(Stream.of(logsStatus).map(c -> (LogsStatus)((LogsStatus.Builder)LogsStatus.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getSourceType() {
            return this.sourceType;
        }

        public final void setSourceType(String sourceType) {
            this.sourceType = sourceType;
        }

        @Override
        public final Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        public AccountSources build() {
            return new AccountSources(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AccountSources> {
        public Builder account(String var1);

        public Builder eventClass(String var1);

        public Builder eventClass(OcsfEventClass var1);

        public Builder logsStatus(Collection<LogsStatus> var1);

        public Builder logsStatus(LogsStatus ... var1);

        public Builder logsStatus(Consumer<LogsStatus.Builder> ... var1);

        public Builder sourceType(String var1);
    }
}

