/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securitylake.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.securitylake.model.SourceStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LogsStatus
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LogsStatus> {
    private static final SdkField<String> HEALTH_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("healthStatus").getter(LogsStatus.getter(LogsStatus::healthStatusAsString)).setter(LogsStatus.setter(Builder::healthStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("healthStatus").build()}).build();
    private static final SdkField<String> PATH_TO_LOGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("pathToLogs").getter(LogsStatus.getter(LogsStatus::pathToLogs)).setter(LogsStatus.setter(Builder::pathToLogs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pathToLogs").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HEALTH_STATUS_FIELD, PATH_TO_LOGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String healthStatus;
    private final String pathToLogs;

    private LogsStatus(BuilderImpl builder) {
        this.healthStatus = builder.healthStatus;
        this.pathToLogs = builder.pathToLogs;
    }

    public final SourceStatus healthStatus() {
        return SourceStatus.fromValue(this.healthStatus);
    }

    public final String healthStatusAsString() {
        return this.healthStatus;
    }

    public final String pathToLogs() {
        return this.pathToLogs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.healthStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.pathToLogs());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LogsStatus)) {
            return false;
        }
        LogsStatus other = (LogsStatus)obj;
        return Objects.equals(this.healthStatusAsString(), other.healthStatusAsString()) && Objects.equals(this.pathToLogs(), other.pathToLogs());
    }

    public final String toString() {
        return ToString.builder((String)"LogsStatus").add("HealthStatus", (Object)this.healthStatusAsString()).add("PathToLogs", (Object)this.pathToLogs()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "healthStatus": {
                return Optional.ofNullable(clazz.cast(this.healthStatusAsString()));
            }
            case "pathToLogs": {
                return Optional.ofNullable(clazz.cast(this.pathToLogs()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LogsStatus, T> g) {
        return obj -> g.apply((LogsStatus)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String healthStatus;
        private String pathToLogs;

        private BuilderImpl() {
        }

        private BuilderImpl(LogsStatus model) {
            this.healthStatus(model.healthStatus);
            this.pathToLogs(model.pathToLogs);
        }

        public final String getHealthStatus() {
            return this.healthStatus;
        }

        public final void setHealthStatus(String healthStatus) {
            this.healthStatus = healthStatus;
        }

        @Override
        public final Builder healthStatus(String healthStatus) {
            this.healthStatus = healthStatus;
            return this;
        }

        @Override
        public final Builder healthStatus(SourceStatus healthStatus) {
            this.healthStatus(healthStatus == null ? null : healthStatus.toString());
            return this;
        }

        public final String getPathToLogs() {
            return this.pathToLogs;
        }

        public final void setPathToLogs(String pathToLogs) {
            this.pathToLogs = pathToLogs;
        }

        @Override
        public final Builder pathToLogs(String pathToLogs) {
            this.pathToLogs = pathToLogs;
            return this;
        }

        public LogsStatus build() {
            return new LogsStatus(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LogsStatus> {
        public Builder healthStatus(String var1);

        public Builder healthStatus(SourceStatus var1);

        public Builder pathToLogs(String var1);
    }
}

