/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securitylake.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.securitylake.SecurityLakeClient;
import software.amazon.awssdk.services.securitylake.model.AccountSources;
import software.amazon.awssdk.services.securitylake.model.GetDatalakeStatusRequest;
import software.amazon.awssdk.services.securitylake.model.GetDatalakeStatusResponse;

public class GetDatalakeStatusIterable
implements SdkIterable<GetDatalakeStatusResponse> {
    private final SecurityLakeClient client;
    private final GetDatalakeStatusRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetDatalakeStatusIterable(SecurityLakeClient client, GetDatalakeStatusRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetDatalakeStatusResponseFetcher();
    }

    public Iterator<GetDatalakeStatusResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AccountSources> accountSourcesList() {
        Function<GetDatalakeStatusResponse, Iterator> getIterator = response -> {
            if (response != null && response.accountSourcesList() != null) {
                return response.accountSourcesList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetDatalakeStatusResponseFetcher
    implements SyncPageFetcher<GetDatalakeStatusResponse> {
        private GetDatalakeStatusResponseFetcher() {
        }

        public boolean hasNextPage(GetDatalakeStatusResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetDatalakeStatusResponse nextPage(GetDatalakeStatusResponse previousPage) {
            if (previousPage == null) {
                return GetDatalakeStatusIterable.this.client.getDatalakeStatus(GetDatalakeStatusIterable.this.firstRequest);
            }
            return GetDatalakeStatusIterable.this.client.getDatalakeStatus((GetDatalakeStatusRequest)((Object)GetDatalakeStatusIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

