/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securitylake.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.securitylake.SecurityLakeClient;
import software.amazon.awssdk.services.securitylake.model.FailuresResponse;
import software.amazon.awssdk.services.securitylake.model.ListDatalakeExceptionsRequest;
import software.amazon.awssdk.services.securitylake.model.ListDatalakeExceptionsResponse;

public class ListDatalakeExceptionsIterable
implements SdkIterable<ListDatalakeExceptionsResponse> {
    private final SecurityLakeClient client;
    private final ListDatalakeExceptionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDatalakeExceptionsIterable(SecurityLakeClient client, ListDatalakeExceptionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListDatalakeExceptionsResponseFetcher();
    }

    public Iterator<ListDatalakeExceptionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<FailuresResponse> nonRetryableFailures() {
        Function<ListDatalakeExceptionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.nonRetryableFailures() != null) {
                return response.nonRetryableFailures().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListDatalakeExceptionsResponseFetcher
    implements SyncPageFetcher<ListDatalakeExceptionsResponse> {
        private ListDatalakeExceptionsResponseFetcher() {
        }

        public boolean hasNextPage(ListDatalakeExceptionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDatalakeExceptionsResponse nextPage(ListDatalakeExceptionsResponse previousPage) {
            if (previousPage == null) {
                return ListDatalakeExceptionsIterable.this.client.listDatalakeExceptions(ListDatalakeExceptionsIterable.this.firstRequest);
            }
            return ListDatalakeExceptionsIterable.this.client.listDatalakeExceptions((ListDatalakeExceptionsRequest)((Object)ListDatalakeExceptionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

