/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securitylake.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum EndpointProtocol {
    HTTPS("HTTPS"),
    SQS("SQS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, EndpointProtocol> VALUE_MAP;
    private final String value;

    private EndpointProtocol(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EndpointProtocol fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EndpointProtocol> knownValues() {
        EnumSet<EndpointProtocol> knownValues = EnumSet.allOf(EndpointProtocol.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(EndpointProtocol.class, EndpointProtocol::toString);
    }
}

