/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securitylake.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.securitylake.model.LakeConfigurationRequest;
import software.amazon.awssdk.services.securitylake.model.LakeConfigurationRequestMapCopier;
import software.amazon.awssdk.services.securitylake.model.Region;
import software.amazon.awssdk.services.securitylake.model.SecurityLakeRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateDatalakeRequest
extends SecurityLakeRequest
implements ToCopyableBuilder<Builder, UpdateDatalakeRequest> {
    private static final SdkField<Map<String, LakeConfigurationRequest>> CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("configurations").getter(UpdateDatalakeRequest.getter(UpdateDatalakeRequest::configurationsAsStrings)).setter(UpdateDatalakeRequest.setter(Builder::configurationsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configurations").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LakeConfigurationRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATIONS_FIELD));
    private final Map<String, LakeConfigurationRequest> configurations;

    private UpdateDatalakeRequest(BuilderImpl builder) {
        super(builder);
        this.configurations = builder.configurations;
    }

    public final Map<Region, LakeConfigurationRequest> configurations() {
        return LakeConfigurationRequestMapCopier.copyStringToEnum(this.configurations);
    }

    public final boolean hasConfigurations() {
        return this.configurations != null && !(this.configurations instanceof SdkAutoConstructMap);
    }

    public final Map<String, LakeConfigurationRequest> configurationsAsStrings() {
        return this.configurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConfigurations() ? this.configurationsAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDatalakeRequest)) {
            return false;
        }
        UpdateDatalakeRequest other = (UpdateDatalakeRequest)((Object)obj);
        return this.hasConfigurations() == other.hasConfigurations() && Objects.equals(this.configurationsAsStrings(), other.configurationsAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateDatalakeRequest").add("Configurations", this.hasConfigurations() ? this.configurationsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "configurations": {
                return Optional.ofNullable(clazz.cast(this.configurationsAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDatalakeRequest, T> g) {
        return obj -> g.apply((UpdateDatalakeRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SecurityLakeRequest.BuilderImpl
    implements Builder {
        private Map<String, LakeConfigurationRequest> configurations = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDatalakeRequest model) {
            super(model);
            this.configurationsWithStrings(model.configurations);
        }

        public final Map<String, LakeConfigurationRequest.Builder> getConfigurations() {
            Map<String, LakeConfigurationRequest.Builder> result = LakeConfigurationRequestMapCopier.copyToBuilder(this.configurations);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setConfigurations(Map<String, LakeConfigurationRequest.BuilderImpl> configurations) {
            this.configurations = LakeConfigurationRequestMapCopier.copyFromBuilder(configurations);
        }

        @Override
        public final Builder configurationsWithStrings(Map<String, LakeConfigurationRequest> configurations) {
            this.configurations = LakeConfigurationRequestMapCopier.copy(configurations);
            return this;
        }

        @Override
        public final Builder configurations(Map<Region, LakeConfigurationRequest> configurations) {
            this.configurations = LakeConfigurationRequestMapCopier.copyEnumToString(configurations);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDatalakeRequest build() {
            return new UpdateDatalakeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SecurityLakeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateDatalakeRequest> {
        public Builder configurationsWithStrings(Map<String, LakeConfigurationRequest> var1);

        public Builder configurations(Map<Region, LakeConfigurationRequest> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

