/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securitylake.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securitylake.model.AwsLogSourceType;
import software.amazon.awssdk.services.securitylake.model.AwsSourceTypeListCopier;
import software.amazon.awssdk.services.securitylake.model.Region;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AutoEnableNewRegionConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AutoEnableNewRegionConfiguration> {
    private static final SdkField<String> REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("region").getter(AutoEnableNewRegionConfiguration.getter(AutoEnableNewRegionConfiguration::regionAsString)).setter(AutoEnableNewRegionConfiguration.setter(Builder::region)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("region").build()}).build();
    private static final SdkField<List<String>> SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("sources").getter(AutoEnableNewRegionConfiguration.getter(AutoEnableNewRegionConfiguration::sourcesAsStrings)).setter(AutoEnableNewRegionConfiguration.setter(Builder::sourcesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGION_FIELD, SOURCES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String region;
    private final List<String> sources;

    private AutoEnableNewRegionConfiguration(BuilderImpl builder) {
        this.region = builder.region;
        this.sources = builder.sources;
    }

    public final Region region() {
        return Region.fromValue(this.region);
    }

    public final String regionAsString() {
        return this.region;
    }

    public final List<AwsLogSourceType> sources() {
        return AwsSourceTypeListCopier.copyStringToEnum(this.sources);
    }

    public final boolean hasSources() {
        return this.sources != null && !(this.sources instanceof SdkAutoConstructList);
    }

    public final List<String> sourcesAsStrings() {
        return this.sources;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.regionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSources() ? this.sourcesAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoEnableNewRegionConfiguration)) {
            return false;
        }
        AutoEnableNewRegionConfiguration other = (AutoEnableNewRegionConfiguration)obj;
        return Objects.equals(this.regionAsString(), other.regionAsString()) && this.hasSources() == other.hasSources() && Objects.equals(this.sourcesAsStrings(), other.sourcesAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"AutoEnableNewRegionConfiguration").add("Region", (Object)this.regionAsString()).add("Sources", this.hasSources() ? this.sourcesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "region": {
                return Optional.ofNullable(clazz.cast(this.regionAsString()));
            }
            case "sources": {
                return Optional.ofNullable(clazz.cast(this.sourcesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AutoEnableNewRegionConfiguration, T> g) {
        return obj -> g.apply((AutoEnableNewRegionConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String region;
        private List<String> sources = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AutoEnableNewRegionConfiguration model) {
            this.region(model.region);
            this.sourcesWithStrings(model.sources);
        }

        public final String getRegion() {
            return this.region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        @Override
        public final Builder region(Region region) {
            this.region(region == null ? null : region.toString());
            return this;
        }

        public final Collection<String> getSources() {
            if (this.sources instanceof SdkAutoConstructList) {
                return null;
            }
            return this.sources;
        }

        public final void setSources(Collection<String> sources) {
            this.sources = AwsSourceTypeListCopier.copy(sources);
        }

        @Override
        public final Builder sourcesWithStrings(Collection<String> sources) {
            this.sources = AwsSourceTypeListCopier.copy(sources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourcesWithStrings(String ... sources) {
            this.sourcesWithStrings(Arrays.asList(sources));
            return this;
        }

        @Override
        public final Builder sources(Collection<AwsLogSourceType> sources) {
            this.sources = AwsSourceTypeListCopier.copyEnumToString(sources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(AwsLogSourceType ... sources) {
            this.sources(Arrays.asList(sources));
            return this;
        }

        public AutoEnableNewRegionConfiguration build() {
            return new AutoEnableNewRegionConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AutoEnableNewRegionConfiguration> {
        public Builder region(String var1);

        public Builder region(Region var1);

        public Builder sourcesWithStrings(Collection<String> var1);

        public Builder sourcesWithStrings(String ... var1);

        public Builder sources(Collection<AwsLogSourceType> var1);

        public Builder sources(AwsLogSourceType ... var1);
    }
}

