/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securitylake.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDataLakeExceptionSubscriptionResponse extends SecurityLakeResponse implements
        ToCopyableBuilder<GetDataLakeExceptionSubscriptionResponse.Builder, GetDataLakeExceptionSubscriptionResponse> {
    private static final SdkField<Long> EXCEPTION_TIME_TO_LIVE_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("exceptionTimeToLive").getter(getter(GetDataLakeExceptionSubscriptionResponse::exceptionTimeToLive))
            .setter(setter(Builder::exceptionTimeToLive))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exceptionTimeToLive").build())
            .build();

    private static final SdkField<String> NOTIFICATION_ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("notificationEndpoint").getter(getter(GetDataLakeExceptionSubscriptionResponse::notificationEndpoint))
            .setter(setter(Builder::notificationEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notificationEndpoint").build())
            .build();

    private static final SdkField<String> SUBSCRIPTION_PROTOCOL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("subscriptionProtocol").getter(getter(GetDataLakeExceptionSubscriptionResponse::subscriptionProtocol))
            .setter(setter(Builder::subscriptionProtocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subscriptionProtocol").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXCEPTION_TIME_TO_LIVE_FIELD,
            NOTIFICATION_ENDPOINT_FIELD, SUBSCRIPTION_PROTOCOL_FIELD));

    private final Long exceptionTimeToLive;

    private final String notificationEndpoint;

    private final String subscriptionProtocol;

    private GetDataLakeExceptionSubscriptionResponse(BuilderImpl builder) {
        super(builder);
        this.exceptionTimeToLive = builder.exceptionTimeToLive;
        this.notificationEndpoint = builder.notificationEndpoint;
        this.subscriptionProtocol = builder.subscriptionProtocol;
    }

    /**
     * <p>
     * The expiration period and time-to-live (TTL).
     * </p>
     * 
     * @return The expiration period and time-to-live (TTL).
     */
    public final Long exceptionTimeToLive() {
        return exceptionTimeToLive;
    }

    /**
     * <p>
     * The Amazon Web Services account where you receive exception notifications.
     * </p>
     * 
     * @return The Amazon Web Services account where you receive exception notifications.
     */
    public final String notificationEndpoint() {
        return notificationEndpoint;
    }

    /**
     * <p>
     * The subscription protocol to which exception notifications are posted.
     * </p>
     * 
     * @return The subscription protocol to which exception notifications are posted.
     */
    public final String subscriptionProtocol() {
        return subscriptionProtocol;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(exceptionTimeToLive());
        hashCode = 31 * hashCode + Objects.hashCode(notificationEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(subscriptionProtocol());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDataLakeExceptionSubscriptionResponse)) {
            return false;
        }
        GetDataLakeExceptionSubscriptionResponse other = (GetDataLakeExceptionSubscriptionResponse) obj;
        return Objects.equals(exceptionTimeToLive(), other.exceptionTimeToLive())
                && Objects.equals(notificationEndpoint(), other.notificationEndpoint())
                && Objects.equals(subscriptionProtocol(), other.subscriptionProtocol());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetDataLakeExceptionSubscriptionResponse").add("ExceptionTimeToLive", exceptionTimeToLive())
                .add("NotificationEndpoint", notificationEndpoint()).add("SubscriptionProtocol", subscriptionProtocol()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "exceptionTimeToLive":
            return Optional.ofNullable(clazz.cast(exceptionTimeToLive()));
        case "notificationEndpoint":
            return Optional.ofNullable(clazz.cast(notificationEndpoint()));
        case "subscriptionProtocol":
            return Optional.ofNullable(clazz.cast(subscriptionProtocol()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDataLakeExceptionSubscriptionResponse, T> g) {
        return obj -> g.apply((GetDataLakeExceptionSubscriptionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SecurityLakeResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetDataLakeExceptionSubscriptionResponse> {
        /**
         * <p>
         * The expiration period and time-to-live (TTL).
         * </p>
         * 
         * @param exceptionTimeToLive
         *        The expiration period and time-to-live (TTL).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exceptionTimeToLive(Long exceptionTimeToLive);

        /**
         * <p>
         * The Amazon Web Services account where you receive exception notifications.
         * </p>
         * 
         * @param notificationEndpoint
         *        The Amazon Web Services account where you receive exception notifications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationEndpoint(String notificationEndpoint);

        /**
         * <p>
         * The subscription protocol to which exception notifications are posted.
         * </p>
         * 
         * @param subscriptionProtocol
         *        The subscription protocol to which exception notifications are posted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscriptionProtocol(String subscriptionProtocol);
    }

    static final class BuilderImpl extends SecurityLakeResponse.BuilderImpl implements Builder {
        private Long exceptionTimeToLive;

        private String notificationEndpoint;

        private String subscriptionProtocol;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDataLakeExceptionSubscriptionResponse model) {
            super(model);
            exceptionTimeToLive(model.exceptionTimeToLive);
            notificationEndpoint(model.notificationEndpoint);
            subscriptionProtocol(model.subscriptionProtocol);
        }

        public final Long getExceptionTimeToLive() {
            return exceptionTimeToLive;
        }

        public final void setExceptionTimeToLive(Long exceptionTimeToLive) {
            this.exceptionTimeToLive = exceptionTimeToLive;
        }

        @Override
        public final Builder exceptionTimeToLive(Long exceptionTimeToLive) {
            this.exceptionTimeToLive = exceptionTimeToLive;
            return this;
        }

        public final String getNotificationEndpoint() {
            return notificationEndpoint;
        }

        public final void setNotificationEndpoint(String notificationEndpoint) {
            this.notificationEndpoint = notificationEndpoint;
        }

        @Override
        public final Builder notificationEndpoint(String notificationEndpoint) {
            this.notificationEndpoint = notificationEndpoint;
            return this;
        }

        public final String getSubscriptionProtocol() {
            return subscriptionProtocol;
        }

        public final void setSubscriptionProtocol(String subscriptionProtocol) {
            this.subscriptionProtocol = subscriptionProtocol;
        }

        @Override
        public final Builder subscriptionProtocol(String subscriptionProtocol) {
            this.subscriptionProtocol = subscriptionProtocol;
            return this;
        }

        @Override
        public GetDataLakeExceptionSubscriptionResponse build() {
            return new GetDataLakeExceptionSubscriptionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
