/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securitylake.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The attributes of a third-party custom source.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CustomLogSourceAttributes implements SdkPojo, Serializable,
        ToCopyableBuilder<CustomLogSourceAttributes.Builder, CustomLogSourceAttributes> {
    private static final SdkField<String> CRAWLER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("crawlerArn").getter(getter(CustomLogSourceAttributes::crawlerArn)).setter(setter(Builder::crawlerArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("crawlerArn").build()).build();

    private static final SdkField<String> DATABASE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("databaseArn").getter(getter(CustomLogSourceAttributes::databaseArn))
            .setter(setter(Builder::databaseArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("databaseArn").build()).build();

    private static final SdkField<String> TABLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("tableArn").getter(getter(CustomLogSourceAttributes::tableArn)).setter(setter(Builder::tableArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tableArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CRAWLER_ARN_FIELD,
            DATABASE_ARN_FIELD, TABLE_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String crawlerArn;

    private final String databaseArn;

    private final String tableArn;

    private CustomLogSourceAttributes(BuilderImpl builder) {
        this.crawlerArn = builder.crawlerArn;
        this.databaseArn = builder.databaseArn;
        this.tableArn = builder.tableArn;
    }

    /**
     * <p>
     * The ARN of the Glue crawler.
     * </p>
     * 
     * @return The ARN of the Glue crawler.
     */
    public final String crawlerArn() {
        return crawlerArn;
    }

    /**
     * <p>
     * The ARN of the Glue database where results are written, such as:
     * <code>arn:aws:daylight:us-east-1::database/sometable/*</code>.
     * </p>
     * 
     * @return The ARN of the Glue database where results are written, such as:
     *         <code>arn:aws:daylight:us-east-1::database/sometable/*</code>.
     */
    public final String databaseArn() {
        return databaseArn;
    }

    /**
     * <p>
     * The ARN of the Glue table.
     * </p>
     * 
     * @return The ARN of the Glue table.
     */
    public final String tableArn() {
        return tableArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(crawlerArn());
        hashCode = 31 * hashCode + Objects.hashCode(databaseArn());
        hashCode = 31 * hashCode + Objects.hashCode(tableArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomLogSourceAttributes)) {
            return false;
        }
        CustomLogSourceAttributes other = (CustomLogSourceAttributes) obj;
        return Objects.equals(crawlerArn(), other.crawlerArn()) && Objects.equals(databaseArn(), other.databaseArn())
                && Objects.equals(tableArn(), other.tableArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CustomLogSourceAttributes").add("CrawlerArn", crawlerArn()).add("DatabaseArn", databaseArn())
                .add("TableArn", tableArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "crawlerArn":
            return Optional.ofNullable(clazz.cast(crawlerArn()));
        case "databaseArn":
            return Optional.ofNullable(clazz.cast(databaseArn()));
        case "tableArn":
            return Optional.ofNullable(clazz.cast(tableArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CustomLogSourceAttributes, T> g) {
        return obj -> g.apply((CustomLogSourceAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CustomLogSourceAttributes> {
        /**
         * <p>
         * The ARN of the Glue crawler.
         * </p>
         * 
         * @param crawlerArn
         *        The ARN of the Glue crawler.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder crawlerArn(String crawlerArn);

        /**
         * <p>
         * The ARN of the Glue database where results are written, such as:
         * <code>arn:aws:daylight:us-east-1::database/sometable/*</code>.
         * </p>
         * 
         * @param databaseArn
         *        The ARN of the Glue database where results are written, such as:
         *        <code>arn:aws:daylight:us-east-1::database/sometable/*</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseArn(String databaseArn);

        /**
         * <p>
         * The ARN of the Glue table.
         * </p>
         * 
         * @param tableArn
         *        The ARN of the Glue table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableArn(String tableArn);
    }

    static final class BuilderImpl implements Builder {
        private String crawlerArn;

        private String databaseArn;

        private String tableArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomLogSourceAttributes model) {
            crawlerArn(model.crawlerArn);
            databaseArn(model.databaseArn);
            tableArn(model.tableArn);
        }

        public final String getCrawlerArn() {
            return crawlerArn;
        }

        public final void setCrawlerArn(String crawlerArn) {
            this.crawlerArn = crawlerArn;
        }

        @Override
        public final Builder crawlerArn(String crawlerArn) {
            this.crawlerArn = crawlerArn;
            return this;
        }

        public final String getDatabaseArn() {
            return databaseArn;
        }

        public final void setDatabaseArn(String databaseArn) {
            this.databaseArn = databaseArn;
        }

        @Override
        public final Builder databaseArn(String databaseArn) {
            this.databaseArn = databaseArn;
            return this;
        }

        public final String getTableArn() {
            return tableArn;
        }

        public final void setTableArn(String tableArn) {
            this.tableArn = tableArn;
        }

        @Override
        public final Builder tableArn(String tableArn) {
            this.tableArn = tableArn;
            return this;
        }

        @Override
        public CustomLogSourceAttributes build() {
            return new CustomLogSourceAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
