/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securitylake.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.securitylake.model.SecurityLakeRequest;
import software.amazon.awssdk.services.securitylake.model.SubscriptionProtocolType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateDatalakeExceptionsSubscriptionRequest
extends SecurityLakeRequest
implements ToCopyableBuilder<Builder, UpdateDatalakeExceptionsSubscriptionRequest> {
    private static final SdkField<String> NOTIFICATION_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("notificationEndpoint").getter(UpdateDatalakeExceptionsSubscriptionRequest.getter(UpdateDatalakeExceptionsSubscriptionRequest::notificationEndpoint)).setter(UpdateDatalakeExceptionsSubscriptionRequest.setter(Builder::notificationEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notificationEndpoint").build()}).build();
    private static final SdkField<String> SUBSCRIPTION_PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("subscriptionProtocol").getter(UpdateDatalakeExceptionsSubscriptionRequest.getter(UpdateDatalakeExceptionsSubscriptionRequest::subscriptionProtocolAsString)).setter(UpdateDatalakeExceptionsSubscriptionRequest.setter(Builder::subscriptionProtocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subscriptionProtocol").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NOTIFICATION_ENDPOINT_FIELD, SUBSCRIPTION_PROTOCOL_FIELD));
    private final String notificationEndpoint;
    private final String subscriptionProtocol;

    private UpdateDatalakeExceptionsSubscriptionRequest(BuilderImpl builder) {
        super(builder);
        this.notificationEndpoint = builder.notificationEndpoint;
        this.subscriptionProtocol = builder.subscriptionProtocol;
    }

    public final String notificationEndpoint() {
        return this.notificationEndpoint;
    }

    public final SubscriptionProtocolType subscriptionProtocol() {
        return SubscriptionProtocolType.fromValue(this.subscriptionProtocol);
    }

    public final String subscriptionProtocolAsString() {
        return this.subscriptionProtocol;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.notificationEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.subscriptionProtocolAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDatalakeExceptionsSubscriptionRequest)) {
            return false;
        }
        UpdateDatalakeExceptionsSubscriptionRequest other = (UpdateDatalakeExceptionsSubscriptionRequest)((Object)obj);
        return Objects.equals(this.notificationEndpoint(), other.notificationEndpoint()) && Objects.equals(this.subscriptionProtocolAsString(), other.subscriptionProtocolAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateDatalakeExceptionsSubscriptionRequest").add("NotificationEndpoint", (Object)this.notificationEndpoint()).add("SubscriptionProtocol", (Object)this.subscriptionProtocolAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "notificationEndpoint": {
                return Optional.ofNullable(clazz.cast(this.notificationEndpoint()));
            }
            case "subscriptionProtocol": {
                return Optional.ofNullable(clazz.cast(this.subscriptionProtocolAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDatalakeExceptionsSubscriptionRequest, T> g) {
        return obj -> g.apply((UpdateDatalakeExceptionsSubscriptionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SecurityLakeRequest.BuilderImpl
    implements Builder {
        private String notificationEndpoint;
        private String subscriptionProtocol;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDatalakeExceptionsSubscriptionRequest model) {
            super(model);
            this.notificationEndpoint(model.notificationEndpoint);
            this.subscriptionProtocol(model.subscriptionProtocol);
        }

        public final String getNotificationEndpoint() {
            return this.notificationEndpoint;
        }

        public final void setNotificationEndpoint(String notificationEndpoint) {
            this.notificationEndpoint = notificationEndpoint;
        }

        @Override
        public final Builder notificationEndpoint(String notificationEndpoint) {
            this.notificationEndpoint = notificationEndpoint;
            return this;
        }

        public final String getSubscriptionProtocol() {
            return this.subscriptionProtocol;
        }

        public final void setSubscriptionProtocol(String subscriptionProtocol) {
            this.subscriptionProtocol = subscriptionProtocol;
        }

        @Override
        public final Builder subscriptionProtocol(String subscriptionProtocol) {
            this.subscriptionProtocol = subscriptionProtocol;
            return this;
        }

        @Override
        public final Builder subscriptionProtocol(SubscriptionProtocolType subscriptionProtocol) {
            this.subscriptionProtocol(subscriptionProtocol == null ? null : subscriptionProtocol.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDatalakeExceptionsSubscriptionRequest build() {
            return new UpdateDatalakeExceptionsSubscriptionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SecurityLakeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateDatalakeExceptionsSubscriptionRequest> {
        public Builder notificationEndpoint(String var1);

        public Builder subscriptionProtocol(String var1);

        public Builder subscriptionProtocol(SubscriptionProtocolType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

