/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securitylake;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.securitylake.SecurityLakeClient;
import software.amazon.awssdk.services.securitylake.model.AccessDeniedException;
import software.amazon.awssdk.services.securitylake.model.AccountNotFoundException;
import software.amazon.awssdk.services.securitylake.model.BucketNotFoundException;
import software.amazon.awssdk.services.securitylake.model.ConcurrentModificationException;
import software.amazon.awssdk.services.securitylake.model.ConflictException;
import software.amazon.awssdk.services.securitylake.model.ConflictSourceNamesException;
import software.amazon.awssdk.services.securitylake.model.ConflictSubscriptionException;
import software.amazon.awssdk.services.securitylake.model.CreateAwsLogSourceRequest;
import software.amazon.awssdk.services.securitylake.model.CreateAwsLogSourceResponse;
import software.amazon.awssdk.services.securitylake.model.CreateCustomLogSourceRequest;
import software.amazon.awssdk.services.securitylake.model.CreateCustomLogSourceResponse;
import software.amazon.awssdk.services.securitylake.model.CreateDatalakeAutoEnableRequest;
import software.amazon.awssdk.services.securitylake.model.CreateDatalakeAutoEnableResponse;
import software.amazon.awssdk.services.securitylake.model.CreateDatalakeDelegatedAdminRequest;
import software.amazon.awssdk.services.securitylake.model.CreateDatalakeDelegatedAdminResponse;
import software.amazon.awssdk.services.securitylake.model.CreateDatalakeExceptionsSubscriptionRequest;
import software.amazon.awssdk.services.securitylake.model.CreateDatalakeExceptionsSubscriptionResponse;
import software.amazon.awssdk.services.securitylake.model.CreateDatalakeRequest;
import software.amazon.awssdk.services.securitylake.model.CreateDatalakeResponse;
import software.amazon.awssdk.services.securitylake.model.CreateSubscriberRequest;
import software.amazon.awssdk.services.securitylake.model.CreateSubscriberResponse;
import software.amazon.awssdk.services.securitylake.model.CreateSubscriptionNotificationConfigurationRequest;
import software.amazon.awssdk.services.securitylake.model.CreateSubscriptionNotificationConfigurationResponse;
import software.amazon.awssdk.services.securitylake.model.DeleteAwsLogSourceRequest;
import software.amazon.awssdk.services.securitylake.model.DeleteAwsLogSourceResponse;
import software.amazon.awssdk.services.securitylake.model.DeleteCustomLogSourceRequest;
import software.amazon.awssdk.services.securitylake.model.DeleteCustomLogSourceResponse;
import software.amazon.awssdk.services.securitylake.model.DeleteDatalakeAutoEnableRequest;
import software.amazon.awssdk.services.securitylake.model.DeleteDatalakeAutoEnableResponse;
import software.amazon.awssdk.services.securitylake.model.DeleteDatalakeDelegatedAdminRequest;
import software.amazon.awssdk.services.securitylake.model.DeleteDatalakeDelegatedAdminResponse;
import software.amazon.awssdk.services.securitylake.model.DeleteDatalakeExceptionsSubscriptionRequest;
import software.amazon.awssdk.services.securitylake.model.DeleteDatalakeExceptionsSubscriptionResponse;
import software.amazon.awssdk.services.securitylake.model.DeleteDatalakeRequest;
import software.amazon.awssdk.services.securitylake.model.DeleteDatalakeResponse;
import software.amazon.awssdk.services.securitylake.model.DeleteSubscriberRequest;
import software.amazon.awssdk.services.securitylake.model.DeleteSubscriberResponse;
import software.amazon.awssdk.services.securitylake.model.DeleteSubscriptionNotificationConfigurationRequest;
import software.amazon.awssdk.services.securitylake.model.DeleteSubscriptionNotificationConfigurationResponse;
import software.amazon.awssdk.services.securitylake.model.EventBridgeException;
import software.amazon.awssdk.services.securitylake.model.GetDatalakeAutoEnableRequest;
import software.amazon.awssdk.services.securitylake.model.GetDatalakeAutoEnableResponse;
import software.amazon.awssdk.services.securitylake.model.GetDatalakeExceptionsExpiryRequest;
import software.amazon.awssdk.services.securitylake.model.GetDatalakeExceptionsExpiryResponse;
import software.amazon.awssdk.services.securitylake.model.GetDatalakeExceptionsSubscriptionRequest;
import software.amazon.awssdk.services.securitylake.model.GetDatalakeExceptionsSubscriptionResponse;
import software.amazon.awssdk.services.securitylake.model.GetDatalakeRequest;
import software.amazon.awssdk.services.securitylake.model.GetDatalakeResponse;
import software.amazon.awssdk.services.securitylake.model.GetDatalakeStatusRequest;
import software.amazon.awssdk.services.securitylake.model.GetDatalakeStatusResponse;
import software.amazon.awssdk.services.securitylake.model.GetSubscriberRequest;
import software.amazon.awssdk.services.securitylake.model.GetSubscriberResponse;
import software.amazon.awssdk.services.securitylake.model.InternalServerException;
import software.amazon.awssdk.services.securitylake.model.InvalidInputException;
import software.amazon.awssdk.services.securitylake.model.ListDatalakeExceptionsRequest;
import software.amazon.awssdk.services.securitylake.model.ListDatalakeExceptionsResponse;
import software.amazon.awssdk.services.securitylake.model.ListLogSourcesRequest;
import software.amazon.awssdk.services.securitylake.model.ListLogSourcesResponse;
import software.amazon.awssdk.services.securitylake.model.ListSubscribersRequest;
import software.amazon.awssdk.services.securitylake.model.ListSubscribersResponse;
import software.amazon.awssdk.services.securitylake.model.ResourceNotFoundException;
import software.amazon.awssdk.services.securitylake.model.S3Exception;
import software.amazon.awssdk.services.securitylake.model.SecurityLakeException;
import software.amazon.awssdk.services.securitylake.model.SecurityLakeRequest;
import software.amazon.awssdk.services.securitylake.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.securitylake.model.ThrottlingException;
import software.amazon.awssdk.services.securitylake.model.UpdateDatalakeExceptionsExpiryRequest;
import software.amazon.awssdk.services.securitylake.model.UpdateDatalakeExceptionsExpiryResponse;
import software.amazon.awssdk.services.securitylake.model.UpdateDatalakeExceptionsSubscriptionRequest;
import software.amazon.awssdk.services.securitylake.model.UpdateDatalakeExceptionsSubscriptionResponse;
import software.amazon.awssdk.services.securitylake.model.UpdateDatalakeRequest;
import software.amazon.awssdk.services.securitylake.model.UpdateDatalakeResponse;
import software.amazon.awssdk.services.securitylake.model.UpdateSubscriberRequest;
import software.amazon.awssdk.services.securitylake.model.UpdateSubscriberResponse;
import software.amazon.awssdk.services.securitylake.model.UpdateSubscriptionNotificationConfigurationRequest;
import software.amazon.awssdk.services.securitylake.model.UpdateSubscriptionNotificationConfigurationResponse;
import software.amazon.awssdk.services.securitylake.model.ValidationException;
import software.amazon.awssdk.services.securitylake.paginators.GetDatalakeStatusIterable;
import software.amazon.awssdk.services.securitylake.paginators.ListDatalakeExceptionsIterable;
import software.amazon.awssdk.services.securitylake.paginators.ListLogSourcesIterable;
import software.amazon.awssdk.services.securitylake.paginators.ListSubscribersIterable;
import software.amazon.awssdk.services.securitylake.transform.CreateAwsLogSourceRequestMarshaller;
import software.amazon.awssdk.services.securitylake.transform.CreateCustomLogSourceRequestMarshaller;
import software.amazon.awssdk.services.securitylake.transform.CreateDatalakeAutoEnableRequestMarshaller;
import software.amazon.awssdk.services.securitylake.transform.CreateDatalakeDelegatedAdminRequestMarshaller;
import software.amazon.awssdk.services.securitylake.transform.CreateDatalakeExceptionsSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.securitylake.transform.CreateDatalakeRequestMarshaller;
import software.amazon.awssdk.services.securitylake.transform.CreateSubscriberRequestMarshaller;
import software.amazon.awssdk.services.securitylake.transform.CreateSubscriptionNotificationConfigurationRequestMarshaller;
import software.amazon.awssdk.services.securitylake.transform.DeleteAwsLogSourceRequestMarshaller;
import software.amazon.awssdk.services.securitylake.transform.DeleteCustomLogSourceRequestMarshaller;
import software.amazon.awssdk.services.securitylake.transform.DeleteDatalakeAutoEnableRequestMarshaller;
import software.amazon.awssdk.services.securitylake.transform.DeleteDatalakeDelegatedAdminRequestMarshaller;
import software.amazon.awssdk.services.securitylake.transform.DeleteDatalakeExceptionsSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.securitylake.transform.DeleteDatalakeRequestMarshaller;
import software.amazon.awssdk.services.securitylake.transform.DeleteSubscriberRequestMarshaller;
import software.amazon.awssdk.services.securitylake.transform.DeleteSubscriptionNotificationConfigurationRequestMarshaller;
import software.amazon.awssdk.services.securitylake.transform.GetDatalakeAutoEnableRequestMarshaller;
import software.amazon.awssdk.services.securitylake.transform.GetDatalakeExceptionsExpiryRequestMarshaller;
import software.amazon.awssdk.services.securitylake.transform.GetDatalakeExceptionsSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.securitylake.transform.GetDatalakeRequestMarshaller;
import software.amazon.awssdk.services.securitylake.transform.GetDatalakeStatusRequestMarshaller;
import software.amazon.awssdk.services.securitylake.transform.GetSubscriberRequestMarshaller;
import software.amazon.awssdk.services.securitylake.transform.ListDatalakeExceptionsRequestMarshaller;
import software.amazon.awssdk.services.securitylake.transform.ListLogSourcesRequestMarshaller;
import software.amazon.awssdk.services.securitylake.transform.ListSubscribersRequestMarshaller;
import software.amazon.awssdk.services.securitylake.transform.UpdateDatalakeExceptionsExpiryRequestMarshaller;
import software.amazon.awssdk.services.securitylake.transform.UpdateDatalakeExceptionsSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.securitylake.transform.UpdateDatalakeRequestMarshaller;
import software.amazon.awssdk.services.securitylake.transform.UpdateSubscriberRequestMarshaller;
import software.amazon.awssdk.services.securitylake.transform.UpdateSubscriptionNotificationConfigurationRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultSecurityLakeClient
implements SecurityLakeClient {
    private static final Logger log = Logger.loggerFor(DefaultSecurityLakeClient.class);
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultSecurityLakeClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "securitylake";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateAwsLogSourceResponse createAwsLogSource(CreateAwsLogSourceRequest createAwsLogSourceRequest) throws InternalServerException, ValidationException, S3Exception, AccessDeniedException, ResourceNotFoundException, AccountNotFoundException, AwsServiceException, SdkClientException, SecurityLakeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateAwsLogSourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultSecurityLakeClient.resolveMetricPublishers(this.clientConfiguration, createAwsLogSourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SecurityLake");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateAwsLogSource");
            CreateAwsLogSourceResponse createAwsLogSourceResponse = (CreateAwsLogSourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateAwsLogSource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createAwsLogSourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateAwsLogSourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createAwsLogSourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSecurityLakeClient.lambda$createAwsLogSource$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateCustomLogSourceResponse createCustomLogSource(CreateCustomLogSourceRequest createCustomLogSourceRequest) throws InternalServerException, ValidationException, ConflictSourceNamesException, AccessDeniedException, BucketNotFoundException, ResourceNotFoundException, AccountNotFoundException, AwsServiceException, SdkClientException, SecurityLakeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateCustomLogSourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultSecurityLakeClient.resolveMetricPublishers(this.clientConfiguration, createCustomLogSourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SecurityLake");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateCustomLogSource");
            CreateCustomLogSourceResponse createCustomLogSourceResponse = (CreateCustomLogSourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateCustomLogSource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createCustomLogSourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateCustomLogSourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createCustomLogSourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSecurityLakeClient.lambda$createCustomLogSource$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateDatalakeResponse createDatalake(CreateDatalakeRequest createDatalakeRequest) throws ServiceQuotaExceededException, ConflictException, InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, SecurityLakeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateDatalakeResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultSecurityLakeClient.resolveMetricPublishers(this.clientConfiguration, createDatalakeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SecurityLake");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDatalake");
            CreateDatalakeResponse createDatalakeResponse = (CreateDatalakeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDatalake").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createDatalakeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateDatalakeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createDatalakeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSecurityLakeClient.lambda$createDatalake$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateDatalakeAutoEnableResponse createDatalakeAutoEnable(CreateDatalakeAutoEnableRequest createDatalakeAutoEnableRequest) throws InternalServerException, ValidationException, AccessDeniedException, AccountNotFoundException, AwsServiceException, SdkClientException, SecurityLakeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateDatalakeAutoEnableResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultSecurityLakeClient.resolveMetricPublishers(this.clientConfiguration, createDatalakeAutoEnableRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SecurityLake");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDatalakeAutoEnable");
            CreateDatalakeAutoEnableResponse createDatalakeAutoEnableResponse = (CreateDatalakeAutoEnableResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDatalakeAutoEnable").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createDatalakeAutoEnableRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateDatalakeAutoEnableRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createDatalakeAutoEnableResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSecurityLakeClient.lambda$createDatalakeAutoEnable$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateDatalakeDelegatedAdminResponse createDatalakeDelegatedAdmin(CreateDatalakeDelegatedAdminRequest createDatalakeDelegatedAdminRequest) throws InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, SecurityLakeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateDatalakeDelegatedAdminResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultSecurityLakeClient.resolveMetricPublishers(this.clientConfiguration, createDatalakeDelegatedAdminRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SecurityLake");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDatalakeDelegatedAdmin");
            CreateDatalakeDelegatedAdminResponse createDatalakeDelegatedAdminResponse = (CreateDatalakeDelegatedAdminResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDatalakeDelegatedAdmin").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createDatalakeDelegatedAdminRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateDatalakeDelegatedAdminRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createDatalakeDelegatedAdminResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSecurityLakeClient.lambda$createDatalakeDelegatedAdmin$4((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateDatalakeExceptionsSubscriptionResponse createDatalakeExceptionsSubscription(CreateDatalakeExceptionsSubscriptionRequest createDatalakeExceptionsSubscriptionRequest) throws InternalServerException, ValidationException, AccessDeniedException, AccountNotFoundException, AwsServiceException, SdkClientException, SecurityLakeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateDatalakeExceptionsSubscriptionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultSecurityLakeClient.resolveMetricPublishers(this.clientConfiguration, createDatalakeExceptionsSubscriptionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SecurityLake");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDatalakeExceptionsSubscription");
            CreateDatalakeExceptionsSubscriptionResponse createDatalakeExceptionsSubscriptionResponse = (CreateDatalakeExceptionsSubscriptionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDatalakeExceptionsSubscription").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createDatalakeExceptionsSubscriptionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateDatalakeExceptionsSubscriptionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createDatalakeExceptionsSubscriptionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSecurityLakeClient.lambda$createDatalakeExceptionsSubscription$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateSubscriberResponse createSubscriber(CreateSubscriberRequest createSubscriberRequest) throws ConflictSubscriptionException, InternalServerException, ValidationException, AccessDeniedException, BucketNotFoundException, ResourceNotFoundException, AccountNotFoundException, InvalidInputException, AwsServiceException, SdkClientException, SecurityLakeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateSubscriberResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultSecurityLakeClient.resolveMetricPublishers(this.clientConfiguration, createSubscriberRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SecurityLake");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateSubscriber");
            CreateSubscriberResponse createSubscriberResponse = (CreateSubscriberResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateSubscriber").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createSubscriberRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateSubscriberRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createSubscriberResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSecurityLakeClient.lambda$createSubscriber$6((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateSubscriptionNotificationConfigurationResponse createSubscriptionNotificationConfiguration(CreateSubscriptionNotificationConfigurationRequest createSubscriptionNotificationConfigurationRequest) throws ConcurrentModificationException, InternalServerException, ValidationException, AccessDeniedException, ResourceNotFoundException, AccountNotFoundException, InvalidInputException, AwsServiceException, SdkClientException, SecurityLakeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateSubscriptionNotificationConfigurationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultSecurityLakeClient.resolveMetricPublishers(this.clientConfiguration, createSubscriptionNotificationConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SecurityLake");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateSubscriptionNotificationConfiguration");
            CreateSubscriptionNotificationConfigurationResponse createSubscriptionNotificationConfigurationResponse = (CreateSubscriptionNotificationConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateSubscriptionNotificationConfiguration").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createSubscriptionNotificationConfigurationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateSubscriptionNotificationConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createSubscriptionNotificationConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSecurityLakeClient.lambda$createSubscriptionNotificationConfiguration$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteAwsLogSourceResponse deleteAwsLogSource(DeleteAwsLogSourceRequest deleteAwsLogSourceRequest) throws InternalServerException, ValidationException, AccessDeniedException, AccountNotFoundException, AwsServiceException, SdkClientException, SecurityLakeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteAwsLogSourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultSecurityLakeClient.resolveMetricPublishers(this.clientConfiguration, deleteAwsLogSourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SecurityLake");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteAwsLogSource");
            DeleteAwsLogSourceResponse deleteAwsLogSourceResponse = (DeleteAwsLogSourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteAwsLogSource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteAwsLogSourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteAwsLogSourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteAwsLogSourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSecurityLakeClient.lambda$deleteAwsLogSource$8((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteCustomLogSourceResponse deleteCustomLogSource(DeleteCustomLogSourceRequest deleteCustomLogSourceRequest) throws InternalServerException, ValidationException, ConflictSourceNamesException, AccessDeniedException, BucketNotFoundException, ResourceNotFoundException, AccountNotFoundException, AwsServiceException, SdkClientException, SecurityLakeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteCustomLogSourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultSecurityLakeClient.resolveMetricPublishers(this.clientConfiguration, deleteCustomLogSourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SecurityLake");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteCustomLogSource");
            DeleteCustomLogSourceResponse deleteCustomLogSourceResponse = (DeleteCustomLogSourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteCustomLogSource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteCustomLogSourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteCustomLogSourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteCustomLogSourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSecurityLakeClient.lambda$deleteCustomLogSource$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteDatalakeResponse deleteDatalake(DeleteDatalakeRequest deleteDatalakeRequest) throws ServiceQuotaExceededException, ConflictException, InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, SecurityLakeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteDatalakeResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultSecurityLakeClient.resolveMetricPublishers(this.clientConfiguration, deleteDatalakeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SecurityLake");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDatalake");
            DeleteDatalakeResponse deleteDatalakeResponse = (DeleteDatalakeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDatalake").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteDatalakeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteDatalakeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteDatalakeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSecurityLakeClient.lambda$deleteDatalake$10((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteDatalakeAutoEnableResponse deleteDatalakeAutoEnable(DeleteDatalakeAutoEnableRequest deleteDatalakeAutoEnableRequest) throws InternalServerException, ValidationException, AccessDeniedException, AccountNotFoundException, AwsServiceException, SdkClientException, SecurityLakeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteDatalakeAutoEnableResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultSecurityLakeClient.resolveMetricPublishers(this.clientConfiguration, deleteDatalakeAutoEnableRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SecurityLake");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDatalakeAutoEnable");
            DeleteDatalakeAutoEnableResponse deleteDatalakeAutoEnableResponse = (DeleteDatalakeAutoEnableResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDatalakeAutoEnable").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteDatalakeAutoEnableRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteDatalakeAutoEnableRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteDatalakeAutoEnableResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSecurityLakeClient.lambda$deleteDatalakeAutoEnable$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteDatalakeDelegatedAdminResponse deleteDatalakeDelegatedAdmin(DeleteDatalakeDelegatedAdminRequest deleteDatalakeDelegatedAdminRequest) throws InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, SecurityLakeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteDatalakeDelegatedAdminResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultSecurityLakeClient.resolveMetricPublishers(this.clientConfiguration, deleteDatalakeDelegatedAdminRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SecurityLake");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDatalakeDelegatedAdmin");
            DeleteDatalakeDelegatedAdminResponse deleteDatalakeDelegatedAdminResponse = (DeleteDatalakeDelegatedAdminResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDatalakeDelegatedAdmin").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteDatalakeDelegatedAdminRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteDatalakeDelegatedAdminRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteDatalakeDelegatedAdminResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSecurityLakeClient.lambda$deleteDatalakeDelegatedAdmin$12((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteDatalakeExceptionsSubscriptionResponse deleteDatalakeExceptionsSubscription(DeleteDatalakeExceptionsSubscriptionRequest deleteDatalakeExceptionsSubscriptionRequest) throws InternalServerException, ValidationException, AccessDeniedException, AccountNotFoundException, AwsServiceException, SdkClientException, SecurityLakeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteDatalakeExceptionsSubscriptionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultSecurityLakeClient.resolveMetricPublishers(this.clientConfiguration, deleteDatalakeExceptionsSubscriptionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SecurityLake");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDatalakeExceptionsSubscription");
            DeleteDatalakeExceptionsSubscriptionResponse deleteDatalakeExceptionsSubscriptionResponse = (DeleteDatalakeExceptionsSubscriptionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDatalakeExceptionsSubscription").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteDatalakeExceptionsSubscriptionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteDatalakeExceptionsSubscriptionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteDatalakeExceptionsSubscriptionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSecurityLakeClient.lambda$deleteDatalakeExceptionsSubscription$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteSubscriberResponse deleteSubscriber(DeleteSubscriberRequest deleteSubscriberRequest) throws ConcurrentModificationException, InternalServerException, ValidationException, AccessDeniedException, BucketNotFoundException, ResourceNotFoundException, AccountNotFoundException, InvalidInputException, AwsServiceException, SdkClientException, SecurityLakeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteSubscriberResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultSecurityLakeClient.resolveMetricPublishers(this.clientConfiguration, deleteSubscriberRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SecurityLake");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteSubscriber");
            DeleteSubscriberResponse deleteSubscriberResponse = (DeleteSubscriberResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteSubscriber").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteSubscriberRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteSubscriberRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteSubscriberResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSecurityLakeClient.lambda$deleteSubscriber$14((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteSubscriptionNotificationConfigurationResponse deleteSubscriptionNotificationConfiguration(DeleteSubscriptionNotificationConfigurationRequest deleteSubscriptionNotificationConfigurationRequest) throws ConcurrentModificationException, InternalServerException, ValidationException, AccessDeniedException, ResourceNotFoundException, AccountNotFoundException, InvalidInputException, AwsServiceException, SdkClientException, SecurityLakeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteSubscriptionNotificationConfigurationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultSecurityLakeClient.resolveMetricPublishers(this.clientConfiguration, deleteSubscriptionNotificationConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SecurityLake");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteSubscriptionNotificationConfiguration");
            DeleteSubscriptionNotificationConfigurationResponse deleteSubscriptionNotificationConfigurationResponse = (DeleteSubscriptionNotificationConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteSubscriptionNotificationConfiguration").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteSubscriptionNotificationConfigurationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteSubscriptionNotificationConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteSubscriptionNotificationConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSecurityLakeClient.lambda$deleteSubscriptionNotificationConfiguration$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetDatalakeResponse getDatalake(GetDatalakeRequest getDatalakeRequest) throws InternalServerException, ValidationException, AccessDeniedException, ResourceNotFoundException, AccountNotFoundException, AwsServiceException, SdkClientException, SecurityLakeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDatalakeResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultSecurityLakeClient.resolveMetricPublishers(this.clientConfiguration, getDatalakeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SecurityLake");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDatalake");
            GetDatalakeResponse getDatalakeResponse = (GetDatalakeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDatalake").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getDatalakeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetDatalakeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getDatalakeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSecurityLakeClient.lambda$getDatalake$16((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetDatalakeAutoEnableResponse getDatalakeAutoEnable(GetDatalakeAutoEnableRequest getDatalakeAutoEnableRequest) throws InternalServerException, ValidationException, AccessDeniedException, AccountNotFoundException, AwsServiceException, SdkClientException, SecurityLakeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDatalakeAutoEnableResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultSecurityLakeClient.resolveMetricPublishers(this.clientConfiguration, getDatalakeAutoEnableRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SecurityLake");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDatalakeAutoEnable");
            GetDatalakeAutoEnableResponse getDatalakeAutoEnableResponse = (GetDatalakeAutoEnableResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDatalakeAutoEnable").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getDatalakeAutoEnableRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetDatalakeAutoEnableRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getDatalakeAutoEnableResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSecurityLakeClient.lambda$getDatalakeAutoEnable$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetDatalakeExceptionsExpiryResponse getDatalakeExceptionsExpiry(GetDatalakeExceptionsExpiryRequest getDatalakeExceptionsExpiryRequest) throws InternalServerException, ValidationException, AccessDeniedException, AccountNotFoundException, AwsServiceException, SdkClientException, SecurityLakeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDatalakeExceptionsExpiryResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultSecurityLakeClient.resolveMetricPublishers(this.clientConfiguration, getDatalakeExceptionsExpiryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SecurityLake");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDatalakeExceptionsExpiry");
            GetDatalakeExceptionsExpiryResponse getDatalakeExceptionsExpiryResponse = (GetDatalakeExceptionsExpiryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDatalakeExceptionsExpiry").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getDatalakeExceptionsExpiryRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetDatalakeExceptionsExpiryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getDatalakeExceptionsExpiryResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSecurityLakeClient.lambda$getDatalakeExceptionsExpiry$18((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetDatalakeExceptionsSubscriptionResponse getDatalakeExceptionsSubscription(GetDatalakeExceptionsSubscriptionRequest getDatalakeExceptionsSubscriptionRequest) throws InternalServerException, ValidationException, AccessDeniedException, AccountNotFoundException, AwsServiceException, SdkClientException, SecurityLakeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDatalakeExceptionsSubscriptionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultSecurityLakeClient.resolveMetricPublishers(this.clientConfiguration, getDatalakeExceptionsSubscriptionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SecurityLake");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDatalakeExceptionsSubscription");
            GetDatalakeExceptionsSubscriptionResponse getDatalakeExceptionsSubscriptionResponse = (GetDatalakeExceptionsSubscriptionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDatalakeExceptionsSubscription").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getDatalakeExceptionsSubscriptionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetDatalakeExceptionsSubscriptionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getDatalakeExceptionsSubscriptionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSecurityLakeClient.lambda$getDatalakeExceptionsSubscription$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetDatalakeStatusResponse getDatalakeStatus(GetDatalakeStatusRequest getDatalakeStatusRequest) throws InternalServerException, ValidationException, AccessDeniedException, AccountNotFoundException, AwsServiceException, SdkClientException, SecurityLakeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDatalakeStatusResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultSecurityLakeClient.resolveMetricPublishers(this.clientConfiguration, getDatalakeStatusRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SecurityLake");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDatalakeStatus");
            GetDatalakeStatusResponse getDatalakeStatusResponse = (GetDatalakeStatusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDatalakeStatus").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getDatalakeStatusRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetDatalakeStatusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getDatalakeStatusResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSecurityLakeClient.lambda$getDatalakeStatus$20((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public GetDatalakeStatusIterable getDatalakeStatusPaginator(GetDatalakeStatusRequest getDatalakeStatusRequest) throws InternalServerException, ValidationException, AccessDeniedException, AccountNotFoundException, AwsServiceException, SdkClientException, SecurityLakeException {
        return new GetDatalakeStatusIterable(this, this.applyPaginatorUserAgent(getDatalakeStatusRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetSubscriberResponse getSubscriber(GetSubscriberRequest getSubscriberRequest) throws InternalServerException, AccessDeniedException, ResourceNotFoundException, AccountNotFoundException, InvalidInputException, AwsServiceException, SdkClientException, SecurityLakeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetSubscriberResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultSecurityLakeClient.resolveMetricPublishers(this.clientConfiguration, getSubscriberRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SecurityLake");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetSubscriber");
            GetSubscriberResponse getSubscriberResponse = (GetSubscriberResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSubscriber").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getSubscriberRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetSubscriberRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getSubscriberResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSecurityLakeClient.lambda$getSubscriber$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListDatalakeExceptionsResponse listDatalakeExceptions(ListDatalakeExceptionsRequest listDatalakeExceptionsRequest) throws InternalServerException, ValidationException, AccessDeniedException, AccountNotFoundException, AwsServiceException, SdkClientException, SecurityLakeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDatalakeExceptionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultSecurityLakeClient.resolveMetricPublishers(this.clientConfiguration, listDatalakeExceptionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SecurityLake");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListDatalakeExceptions");
            ListDatalakeExceptionsResponse listDatalakeExceptionsResponse = (ListDatalakeExceptionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDatalakeExceptions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listDatalakeExceptionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListDatalakeExceptionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listDatalakeExceptionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSecurityLakeClient.lambda$listDatalakeExceptions$22((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListDatalakeExceptionsIterable listDatalakeExceptionsPaginator(ListDatalakeExceptionsRequest listDatalakeExceptionsRequest) throws InternalServerException, ValidationException, AccessDeniedException, AccountNotFoundException, AwsServiceException, SdkClientException, SecurityLakeException {
        return new ListDatalakeExceptionsIterable(this, this.applyPaginatorUserAgent(listDatalakeExceptionsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListLogSourcesResponse listLogSources(ListLogSourcesRequest listLogSourcesRequest) throws InternalServerException, ValidationException, AccessDeniedException, ResourceNotFoundException, AccountNotFoundException, AwsServiceException, SdkClientException, SecurityLakeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListLogSourcesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultSecurityLakeClient.resolveMetricPublishers(this.clientConfiguration, listLogSourcesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SecurityLake");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListLogSources");
            ListLogSourcesResponse listLogSourcesResponse = (ListLogSourcesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListLogSources").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listLogSourcesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListLogSourcesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listLogSourcesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSecurityLakeClient.lambda$listLogSources$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListLogSourcesIterable listLogSourcesPaginator(ListLogSourcesRequest listLogSourcesRequest) throws InternalServerException, ValidationException, AccessDeniedException, ResourceNotFoundException, AccountNotFoundException, AwsServiceException, SdkClientException, SecurityLakeException {
        return new ListLogSourcesIterable(this, this.applyPaginatorUserAgent(listLogSourcesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListSubscribersResponse listSubscribers(ListSubscribersRequest listSubscribersRequest) throws InternalServerException, ValidationException, AccessDeniedException, ResourceNotFoundException, AccountNotFoundException, InvalidInputException, AwsServiceException, SdkClientException, SecurityLakeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListSubscribersResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultSecurityLakeClient.resolveMetricPublishers(this.clientConfiguration, listSubscribersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SecurityLake");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListSubscribers");
            ListSubscribersResponse listSubscribersResponse = (ListSubscribersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListSubscribers").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listSubscribersRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListSubscribersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listSubscribersResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSecurityLakeClient.lambda$listSubscribers$24((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListSubscribersIterable listSubscribersPaginator(ListSubscribersRequest listSubscribersRequest) throws InternalServerException, ValidationException, AccessDeniedException, ResourceNotFoundException, AccountNotFoundException, InvalidInputException, AwsServiceException, SdkClientException, SecurityLakeException {
        return new ListSubscribersIterable(this, this.applyPaginatorUserAgent(listSubscribersRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateDatalakeResponse updateDatalake(UpdateDatalakeRequest updateDatalakeRequest) throws EventBridgeException, InternalServerException, ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, SecurityLakeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateDatalakeResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultSecurityLakeClient.resolveMetricPublishers(this.clientConfiguration, updateDatalakeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SecurityLake");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateDatalake");
            UpdateDatalakeResponse updateDatalakeResponse = (UpdateDatalakeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateDatalake").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateDatalakeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateDatalakeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateDatalakeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSecurityLakeClient.lambda$updateDatalake$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateDatalakeExceptionsExpiryResponse updateDatalakeExceptionsExpiry(UpdateDatalakeExceptionsExpiryRequest updateDatalakeExceptionsExpiryRequest) throws InternalServerException, ValidationException, AccessDeniedException, AccountNotFoundException, AwsServiceException, SdkClientException, SecurityLakeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateDatalakeExceptionsExpiryResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultSecurityLakeClient.resolveMetricPublishers(this.clientConfiguration, updateDatalakeExceptionsExpiryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SecurityLake");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateDatalakeExceptionsExpiry");
            UpdateDatalakeExceptionsExpiryResponse updateDatalakeExceptionsExpiryResponse = (UpdateDatalakeExceptionsExpiryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateDatalakeExceptionsExpiry").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateDatalakeExceptionsExpiryRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateDatalakeExceptionsExpiryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateDatalakeExceptionsExpiryResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSecurityLakeClient.lambda$updateDatalakeExceptionsExpiry$26((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateDatalakeExceptionsSubscriptionResponse updateDatalakeExceptionsSubscription(UpdateDatalakeExceptionsSubscriptionRequest updateDatalakeExceptionsSubscriptionRequest) throws InternalServerException, ValidationException, AccessDeniedException, AccountNotFoundException, AwsServiceException, SdkClientException, SecurityLakeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateDatalakeExceptionsSubscriptionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultSecurityLakeClient.resolveMetricPublishers(this.clientConfiguration, updateDatalakeExceptionsSubscriptionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SecurityLake");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateDatalakeExceptionsSubscription");
            UpdateDatalakeExceptionsSubscriptionResponse updateDatalakeExceptionsSubscriptionResponse = (UpdateDatalakeExceptionsSubscriptionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateDatalakeExceptionsSubscription").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateDatalakeExceptionsSubscriptionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateDatalakeExceptionsSubscriptionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateDatalakeExceptionsSubscriptionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSecurityLakeClient.lambda$updateDatalakeExceptionsSubscription$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateSubscriberResponse updateSubscriber(UpdateSubscriberRequest updateSubscriberRequest) throws ConflictSubscriptionException, ConcurrentModificationException, InternalServerException, ValidationException, AccessDeniedException, AccountNotFoundException, InvalidInputException, AwsServiceException, SdkClientException, SecurityLakeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateSubscriberResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultSecurityLakeClient.resolveMetricPublishers(this.clientConfiguration, updateSubscriberRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SecurityLake");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateSubscriber");
            UpdateSubscriberResponse updateSubscriberResponse = (UpdateSubscriberResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateSubscriber").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateSubscriberRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateSubscriberRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateSubscriberResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSecurityLakeClient.lambda$updateSubscriber$28((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateSubscriptionNotificationConfigurationResponse updateSubscriptionNotificationConfiguration(UpdateSubscriptionNotificationConfigurationRequest updateSubscriptionNotificationConfigurationRequest) throws ConcurrentModificationException, InternalServerException, ValidationException, AccessDeniedException, ResourceNotFoundException, AccountNotFoundException, InvalidInputException, AwsServiceException, SdkClientException, SecurityLakeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateSubscriptionNotificationConfigurationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultSecurityLakeClient.resolveMetricPublishers(this.clientConfiguration, updateSubscriptionNotificationConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SecurityLake");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateSubscriptionNotificationConfiguration");
            UpdateSubscriptionNotificationConfigurationResponse updateSubscriptionNotificationConfigurationResponse = (UpdateSubscriptionNotificationConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateSubscriptionNotificationConfiguration").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateSubscriptionNotificationConfigurationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateSubscriptionNotificationConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateSubscriptionNotificationConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSecurityLakeClient.lambda$updateSubscriptionNotificationConfiguration$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(SecurityLakeException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ConflictSourceNamesException").exceptionBuilderSupplier(ConflictSourceNamesException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ThrottlingException").exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(Integer.valueOf(429)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").exceptionBuilderSupplier(ServiceQuotaExceededException::builder).httpStatusCode(Integer.valueOf(402)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalServerException").exceptionBuilderSupplier(InternalServerException::builder).httpStatusCode(Integer.valueOf(500)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("S3Exception").exceptionBuilderSupplier(S3Exception::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("BucketNotFoundException").exceptionBuilderSupplier(BucketNotFoundException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AccessDeniedException").exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(Integer.valueOf(403)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ConflictException").exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ConflictSubscriptionException").exceptionBuilderSupplier(ConflictSubscriptionException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidInputException").exceptionBuilderSupplier(InvalidInputException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AccountNotFoundException").exceptionBuilderSupplier(AccountNotFoundException::builder).httpStatusCode(Integer.valueOf(403)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ValidationException").exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("EventBridgeException").exceptionBuilderSupplier(EventBridgeException::builder).httpStatusCode(Integer.valueOf(400)).build());
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends SecurityLakeRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.19.27").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((SecurityLakeRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    private static /* synthetic */ void lambda$updateSubscriptionNotificationConfiguration$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateSubscriber$28(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateDatalakeExceptionsSubscription$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateDatalakeExceptionsExpiry$26(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateDatalake$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listSubscribers$24(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listLogSources$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listDatalakeExceptions$22(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getSubscriber$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getDatalakeStatus$20(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getDatalakeExceptionsSubscription$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getDatalakeExceptionsExpiry$18(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getDatalakeAutoEnable$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getDatalake$16(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteSubscriptionNotificationConfiguration$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteSubscriber$14(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteDatalakeExceptionsSubscription$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteDatalakeDelegatedAdmin$12(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteDatalakeAutoEnable$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteDatalake$10(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteCustomLogSource$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteAwsLogSource$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createSubscriptionNotificationConfiguration$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createSubscriber$6(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createDatalakeExceptionsSubscription$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createDatalakeDelegatedAdmin$4(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createDatalakeAutoEnable$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createDatalake$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createCustomLogSource$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createAwsLogSource$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

