/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securitylake.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.securitylake.SecurityLakeClient;
import software.amazon.awssdk.services.securitylake.model.ListSubscribersRequest;
import software.amazon.awssdk.services.securitylake.model.ListSubscribersResponse;
import software.amazon.awssdk.services.securitylake.model.SubscriberResource;

public class ListSubscribersIterable
implements SdkIterable<ListSubscribersResponse> {
    private final SecurityLakeClient client;
    private final ListSubscribersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSubscribersIterable(SecurityLakeClient client, ListSubscribersRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListSubscribersResponseFetcher();
    }

    public Iterator<ListSubscribersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<SubscriberResource> subscribers() {
        Function<ListSubscribersResponse, Iterator> getIterator = response -> {
            if (response != null && response.subscribers() != null) {
                return response.subscribers().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListSubscribersResponseFetcher
    implements SyncPageFetcher<ListSubscribersResponse> {
        private ListSubscribersResponseFetcher() {
        }

        public boolean hasNextPage(ListSubscribersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSubscribersResponse nextPage(ListSubscribersResponse previousPage) {
            if (previousPage == null) {
                return ListSubscribersIterable.this.client.listSubscribers(ListSubscribersIterable.this.firstRequest);
            }
            return ListSubscribersIterable.this.client.listSubscribers((ListSubscribersRequest)((Object)ListSubscribersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

