/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityir.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityir.model.MembershipAccountsConfigurationsUpdateOrganizationalUnitsToAddListCopier;
import software.amazon.awssdk.services.securityir.model.MembershipAccountsConfigurationsUpdateOrganizationalUnitsToRemoveListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MembershipAccountsConfigurationsUpdate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MembershipAccountsConfigurationsUpdate> {
    private static final SdkField<Boolean> COVER_ENTIRE_ORGANIZATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("coverEntireOrganization").getter(MembershipAccountsConfigurationsUpdate.getter(MembershipAccountsConfigurationsUpdate::coverEntireOrganization)).setter(MembershipAccountsConfigurationsUpdate.setter(Builder::coverEntireOrganization)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("coverEntireOrganization").build()}).build();
    private static final SdkField<List<String>> ORGANIZATIONAL_UNITS_TO_ADD_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("organizationalUnitsToAdd").getter(MembershipAccountsConfigurationsUpdate.getter(MembershipAccountsConfigurationsUpdate::organizationalUnitsToAdd)).setter(MembershipAccountsConfigurationsUpdate.setter(Builder::organizationalUnitsToAdd)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("organizationalUnitsToAdd").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ORGANIZATIONAL_UNITS_TO_REMOVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("organizationalUnitsToRemove").getter(MembershipAccountsConfigurationsUpdate.getter(MembershipAccountsConfigurationsUpdate::organizationalUnitsToRemove)).setter(MembershipAccountsConfigurationsUpdate.setter(Builder::organizationalUnitsToRemove)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("organizationalUnitsToRemove").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COVER_ENTIRE_ORGANIZATION_FIELD, ORGANIZATIONAL_UNITS_TO_ADD_FIELD, ORGANIZATIONAL_UNITS_TO_REMOVE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MembershipAccountsConfigurationsUpdate.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Boolean coverEntireOrganization;
    private final List<String> organizationalUnitsToAdd;
    private final List<String> organizationalUnitsToRemove;

    private MembershipAccountsConfigurationsUpdate(BuilderImpl builder) {
        this.coverEntireOrganization = builder.coverEntireOrganization;
        this.organizationalUnitsToAdd = builder.organizationalUnitsToAdd;
        this.organizationalUnitsToRemove = builder.organizationalUnitsToRemove;
    }

    public final Boolean coverEntireOrganization() {
        return this.coverEntireOrganization;
    }

    public final boolean hasOrganizationalUnitsToAdd() {
        return this.organizationalUnitsToAdd != null && !(this.organizationalUnitsToAdd instanceof SdkAutoConstructList);
    }

    public final List<String> organizationalUnitsToAdd() {
        return this.organizationalUnitsToAdd;
    }

    public final boolean hasOrganizationalUnitsToRemove() {
        return this.organizationalUnitsToRemove != null && !(this.organizationalUnitsToRemove instanceof SdkAutoConstructList);
    }

    public final List<String> organizationalUnitsToRemove() {
        return this.organizationalUnitsToRemove;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.coverEntireOrganization());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOrganizationalUnitsToAdd() ? this.organizationalUnitsToAdd() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOrganizationalUnitsToRemove() ? this.organizationalUnitsToRemove() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MembershipAccountsConfigurationsUpdate)) {
            return false;
        }
        MembershipAccountsConfigurationsUpdate other = (MembershipAccountsConfigurationsUpdate)obj;
        return Objects.equals(this.coverEntireOrganization(), other.coverEntireOrganization()) && this.hasOrganizationalUnitsToAdd() == other.hasOrganizationalUnitsToAdd() && Objects.equals(this.organizationalUnitsToAdd(), other.organizationalUnitsToAdd()) && this.hasOrganizationalUnitsToRemove() == other.hasOrganizationalUnitsToRemove() && Objects.equals(this.organizationalUnitsToRemove(), other.organizationalUnitsToRemove());
    }

    public final String toString() {
        return ToString.builder((String)"MembershipAccountsConfigurationsUpdate").add("CoverEntireOrganization", (Object)this.coverEntireOrganization()).add("OrganizationalUnitsToAdd", this.hasOrganizationalUnitsToAdd() ? this.organizationalUnitsToAdd() : null).add("OrganizationalUnitsToRemove", this.hasOrganizationalUnitsToRemove() ? this.organizationalUnitsToRemove() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "coverEntireOrganization": {
                return Optional.ofNullable(clazz.cast(this.coverEntireOrganization()));
            }
            case "organizationalUnitsToAdd": {
                return Optional.ofNullable(clazz.cast(this.organizationalUnitsToAdd()));
            }
            case "organizationalUnitsToRemove": {
                return Optional.ofNullable(clazz.cast(this.organizationalUnitsToRemove()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("coverEntireOrganization", COVER_ENTIRE_ORGANIZATION_FIELD);
        map.put("organizationalUnitsToAdd", ORGANIZATIONAL_UNITS_TO_ADD_FIELD);
        map.put("organizationalUnitsToRemove", ORGANIZATIONAL_UNITS_TO_REMOVE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MembershipAccountsConfigurationsUpdate, T> g) {
        return obj -> g.apply((MembershipAccountsConfigurationsUpdate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean coverEntireOrganization;
        private List<String> organizationalUnitsToAdd = DefaultSdkAutoConstructList.getInstance();
        private List<String> organizationalUnitsToRemove = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MembershipAccountsConfigurationsUpdate model) {
            this.coverEntireOrganization(model.coverEntireOrganization);
            this.organizationalUnitsToAdd(model.organizationalUnitsToAdd);
            this.organizationalUnitsToRemove(model.organizationalUnitsToRemove);
        }

        public final Boolean getCoverEntireOrganization() {
            return this.coverEntireOrganization;
        }

        public final void setCoverEntireOrganization(Boolean coverEntireOrganization) {
            this.coverEntireOrganization = coverEntireOrganization;
        }

        @Override
        public final Builder coverEntireOrganization(Boolean coverEntireOrganization) {
            this.coverEntireOrganization = coverEntireOrganization;
            return this;
        }

        public final Collection<String> getOrganizationalUnitsToAdd() {
            if (this.organizationalUnitsToAdd instanceof SdkAutoConstructList) {
                return null;
            }
            return this.organizationalUnitsToAdd;
        }

        public final void setOrganizationalUnitsToAdd(Collection<String> organizationalUnitsToAdd) {
            this.organizationalUnitsToAdd = MembershipAccountsConfigurationsUpdateOrganizationalUnitsToAddListCopier.copy(organizationalUnitsToAdd);
        }

        @Override
        public final Builder organizationalUnitsToAdd(Collection<String> organizationalUnitsToAdd) {
            this.organizationalUnitsToAdd = MembershipAccountsConfigurationsUpdateOrganizationalUnitsToAddListCopier.copy(organizationalUnitsToAdd);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder organizationalUnitsToAdd(String ... organizationalUnitsToAdd) {
            this.organizationalUnitsToAdd(Arrays.asList(organizationalUnitsToAdd));
            return this;
        }

        public final Collection<String> getOrganizationalUnitsToRemove() {
            if (this.organizationalUnitsToRemove instanceof SdkAutoConstructList) {
                return null;
            }
            return this.organizationalUnitsToRemove;
        }

        public final void setOrganizationalUnitsToRemove(Collection<String> organizationalUnitsToRemove) {
            this.organizationalUnitsToRemove = MembershipAccountsConfigurationsUpdateOrganizationalUnitsToRemoveListCopier.copy(organizationalUnitsToRemove);
        }

        @Override
        public final Builder organizationalUnitsToRemove(Collection<String> organizationalUnitsToRemove) {
            this.organizationalUnitsToRemove = MembershipAccountsConfigurationsUpdateOrganizationalUnitsToRemoveListCopier.copy(organizationalUnitsToRemove);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder organizationalUnitsToRemove(String ... organizationalUnitsToRemove) {
            this.organizationalUnitsToRemove(Arrays.asList(organizationalUnitsToRemove));
            return this;
        }

        public MembershipAccountsConfigurationsUpdate build() {
            return new MembershipAccountsConfigurationsUpdate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MembershipAccountsConfigurationsUpdate> {
        public Builder coverEntireOrganization(Boolean var1);

        public Builder organizationalUnitsToAdd(Collection<String> var1);

        public Builder organizationalUnitsToAdd(String ... var1);

        public Builder organizationalUnitsToRemove(Collection<String> var1);

        public Builder organizationalUnitsToRemove(String ... var1);
    }
}

