/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityir.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents user feedback for an investigation result. This structure captures the user's evaluation of the
 * investigation's quality, usefulness, and any additional comments.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InvestigationFeedback implements SdkPojo, Serializable,
        ToCopyableBuilder<InvestigationFeedback.Builder, InvestigationFeedback> {
    private static final SdkField<String> USEFULNESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("usefulness").getter(getter(InvestigationFeedback::usefulnessAsString))
            .setter(setter(Builder::usefulness))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usefulness").build()).build();

    private static final SdkField<String> COMMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("comment")
            .getter(getter(InvestigationFeedback::comment)).setter(setter(Builder::comment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("comment").build()).build();

    private static final SdkField<Instant> SUBMITTED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("submittedAt").getter(getter(InvestigationFeedback::submittedAt)).setter(setter(Builder::submittedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("submittedAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USEFULNESS_FIELD,
            COMMENT_FIELD, SUBMITTED_AT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String usefulness;

    private final String comment;

    private final Instant submittedAt;

    private InvestigationFeedback(BuilderImpl builder) {
        this.usefulness = builder.usefulness;
        this.comment = builder.comment;
        this.submittedAt = builder.submittedAt;
    }

    /**
     * <p>
     * User assessment of the investigation result's quality and helpfulness. This rating indicates how valuable the
     * investigation findings were in addressing the case.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #usefulness} will
     * return {@link UsefulnessRating#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #usefulnessAsString}.
     * </p>
     * 
     * @return User assessment of the investigation result's quality and helpfulness. This rating indicates how valuable
     *         the investigation findings were in addressing the case.
     * @see UsefulnessRating
     */
    public final UsefulnessRating usefulness() {
        return UsefulnessRating.fromValue(usefulness);
    }

    /**
     * <p>
     * User assessment of the investigation result's quality and helpfulness. This rating indicates how valuable the
     * investigation findings were in addressing the case.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #usefulness} will
     * return {@link UsefulnessRating#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #usefulnessAsString}.
     * </p>
     * 
     * @return User assessment of the investigation result's quality and helpfulness. This rating indicates how valuable
     *         the investigation findings were in addressing the case.
     * @see UsefulnessRating
     */
    public final String usefulnessAsString() {
        return usefulness;
    }

    /**
     * <p>
     * Optional user comments providing additional context about the investigation feedback. This allows users to
     * explain their rating or provide suggestions for improvement.
     * </p>
     * 
     * @return Optional user comments providing additional context about the investigation feedback. This allows users
     *         to explain their rating or provide suggestions for improvement.
     */
    public final String comment() {
        return comment;
    }

    /**
     * <p>
     * ISO 8601 timestamp when the feedback was submitted. This records when the user provided their assessment of the
     * investigation results.
     * </p>
     * 
     * @return ISO 8601 timestamp when the feedback was submitted. This records when the user provided their assessment
     *         of the investigation results.
     */
    public final Instant submittedAt() {
        return submittedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(usefulnessAsString());
        hashCode = 31 * hashCode + Objects.hashCode(comment());
        hashCode = 31 * hashCode + Objects.hashCode(submittedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InvestigationFeedback)) {
            return false;
        }
        InvestigationFeedback other = (InvestigationFeedback) obj;
        return Objects.equals(usefulnessAsString(), other.usefulnessAsString()) && Objects.equals(comment(), other.comment())
                && Objects.equals(submittedAt(), other.submittedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InvestigationFeedback").add("Usefulness", usefulnessAsString()).add("Comment", comment())
                .add("SubmittedAt", submittedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "usefulness":
            return Optional.ofNullable(clazz.cast(usefulnessAsString()));
        case "comment":
            return Optional.ofNullable(clazz.cast(comment()));
        case "submittedAt":
            return Optional.ofNullable(clazz.cast(submittedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("usefulness", USEFULNESS_FIELD);
        map.put("comment", COMMENT_FIELD);
        map.put("submittedAt", SUBMITTED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InvestigationFeedback, T> g) {
        return obj -> g.apply((InvestigationFeedback) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InvestigationFeedback> {
        /**
         * <p>
         * User assessment of the investigation result's quality and helpfulness. This rating indicates how valuable the
         * investigation findings were in addressing the case.
         * </p>
         * 
         * @param usefulness
         *        User assessment of the investigation result's quality and helpfulness. This rating indicates how
         *        valuable the investigation findings were in addressing the case.
         * @see UsefulnessRating
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UsefulnessRating
         */
        Builder usefulness(String usefulness);

        /**
         * <p>
         * User assessment of the investigation result's quality and helpfulness. This rating indicates how valuable the
         * investigation findings were in addressing the case.
         * </p>
         * 
         * @param usefulness
         *        User assessment of the investigation result's quality and helpfulness. This rating indicates how
         *        valuable the investigation findings were in addressing the case.
         * @see UsefulnessRating
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UsefulnessRating
         */
        Builder usefulness(UsefulnessRating usefulness);

        /**
         * <p>
         * Optional user comments providing additional context about the investigation feedback. This allows users to
         * explain their rating or provide suggestions for improvement.
         * </p>
         * 
         * @param comment
         *        Optional user comments providing additional context about the investigation feedback. This allows
         *        users to explain their rating or provide suggestions for improvement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comment(String comment);

        /**
         * <p>
         * ISO 8601 timestamp when the feedback was submitted. This records when the user provided their assessment of
         * the investigation results.
         * </p>
         * 
         * @param submittedAt
         *        ISO 8601 timestamp when the feedback was submitted. This records when the user provided their
         *        assessment of the investigation results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder submittedAt(Instant submittedAt);
    }

    static final class BuilderImpl implements Builder {
        private String usefulness;

        private String comment;

        private Instant submittedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(InvestigationFeedback model) {
            usefulness(model.usefulness);
            comment(model.comment);
            submittedAt(model.submittedAt);
        }

        public final String getUsefulness() {
            return usefulness;
        }

        public final void setUsefulness(String usefulness) {
            this.usefulness = usefulness;
        }

        @Override
        public final Builder usefulness(String usefulness) {
            this.usefulness = usefulness;
            return this;
        }

        @Override
        public final Builder usefulness(UsefulnessRating usefulness) {
            this.usefulness(usefulness == null ? null : usefulness.toString());
            return this;
        }

        public final String getComment() {
            return comment;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final Instant getSubmittedAt() {
            return submittedAt;
        }

        public final void setSubmittedAt(Instant submittedAt) {
            this.submittedAt = submittedAt;
        }

        @Override
        public final Builder submittedAt(Instant submittedAt) {
            this.submittedAt = submittedAt;
            return this;
        }

        @Override
        public InvestigationFeedback build() {
            return new InvestigationFeedback(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
