/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityir.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateCaseRequest extends SecurityIrRequest implements
        ToCopyableBuilder<CreateCaseRequest.Builder, CreateCaseRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateCaseRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> RESOLVER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resolverType").getter(getter(CreateCaseRequest::resolverTypeAsString))
            .setter(setter(Builder::resolverType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resolverType").build()).build();

    private static final SdkField<String> TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("title")
            .getter(getter(CreateCaseRequest::title)).setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("title").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateCaseRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> ENGAGEMENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("engagementType").getter(getter(CreateCaseRequest::engagementTypeAsString))
            .setter(setter(Builder::engagementType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("engagementType").build()).build();

    private static final SdkField<Instant> REPORTED_INCIDENT_START_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT).memberName("reportedIncidentStartDate")
            .getter(getter(CreateCaseRequest::reportedIncidentStartDate)).setter(setter(Builder::reportedIncidentStartDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reportedIncidentStartDate").build())
            .build();

    private static final SdkField<List<String>> IMPACTED_ACCOUNTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("impactedAccounts")
            .getter(getter(CreateCaseRequest::impactedAccounts))
            .setter(setter(Builder::impactedAccounts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("impactedAccounts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Watcher>> WATCHERS_FIELD = SdkField
            .<List<Watcher>> builder(MarshallingType.LIST)
            .memberName("watchers")
            .getter(getter(CreateCaseRequest::watchers))
            .setter(setter(Builder::watchers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("watchers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Watcher> builder(MarshallingType.SDK_POJO)
                                            .constructor(Watcher::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ThreatActorIp>> THREAT_ACTOR_IP_ADDRESSES_FIELD = SdkField
            .<List<ThreatActorIp>> builder(MarshallingType.LIST)
            .memberName("threatActorIpAddresses")
            .getter(getter(CreateCaseRequest::threatActorIpAddresses))
            .setter(setter(Builder::threatActorIpAddresses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("threatActorIpAddresses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ThreatActorIp> builder(MarshallingType.SDK_POJO)
                                            .constructor(ThreatActorIp::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> IMPACTED_SERVICES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("impactedServices")
            .getter(getter(CreateCaseRequest::impactedServices))
            .setter(setter(Builder::impactedServices))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("impactedServices").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ImpactedAwsRegion>> IMPACTED_AWS_REGIONS_FIELD = SdkField
            .<List<ImpactedAwsRegion>> builder(MarshallingType.LIST)
            .memberName("impactedAwsRegions")
            .getter(getter(CreateCaseRequest::impactedAwsRegions))
            .setter(setter(Builder::impactedAwsRegions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("impactedAwsRegions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ImpactedAwsRegion> builder(MarshallingType.SDK_POJO)
                                            .constructor(ImpactedAwsRegion::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateCaseRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            RESOLVER_TYPE_FIELD, TITLE_FIELD, DESCRIPTION_FIELD, ENGAGEMENT_TYPE_FIELD, REPORTED_INCIDENT_START_DATE_FIELD,
            IMPACTED_ACCOUNTS_FIELD, WATCHERS_FIELD, THREAT_ACTOR_IP_ADDRESSES_FIELD, IMPACTED_SERVICES_FIELD,
            IMPACTED_AWS_REGIONS_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clientToken;

    private final String resolverType;

    private final String title;

    private final String description;

    private final String engagementType;

    private final Instant reportedIncidentStartDate;

    private final List<String> impactedAccounts;

    private final List<Watcher> watchers;

    private final List<ThreatActorIp> threatActorIpAddresses;

    private final List<String> impactedServices;

    private final List<ImpactedAwsRegion> impactedAwsRegions;

    private final Map<String, String> tags;

    private CreateCaseRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.resolverType = builder.resolverType;
        this.title = builder.title;
        this.description = builder.description;
        this.engagementType = builder.engagementType;
        this.reportedIncidentStartDate = builder.reportedIncidentStartDate;
        this.impactedAccounts = builder.impactedAccounts;
        this.watchers = builder.watchers;
        this.threatActorIpAddresses = builder.threatActorIpAddresses;
        this.impactedServices = builder.impactedServices;
        this.impactedAwsRegions = builder.impactedAwsRegions;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * <note>
     * <p>
     * The <code>clientToken</code> field is an idempotency key used to ensure that repeated attempts for a single
     * action will be ignored by the server during retries. A caller supplied unique ID (typically a UUID) should be
     * provided.
     * </p>
     * </note></p>
     * 
     * @return <p>
     *         The <code>clientToken</code> field is an idempotency key used to ensure that repeated attempts for a
     *         single action will be ignored by the server during retries. A caller supplied unique ID (typically a
     *         UUID) should be provided.
     *         </p>
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * Required element used in combination with CreateCase to identify the resolver type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resolverType} will
     * return {@link ResolverType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resolverTypeAsString}.
     * </p>
     * 
     * @return Required element used in combination with CreateCase to identify the resolver type.
     * @see ResolverType
     */
    public final ResolverType resolverType() {
        return ResolverType.fromValue(resolverType);
    }

    /**
     * <p>
     * Required element used in combination with CreateCase to identify the resolver type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resolverType} will
     * return {@link ResolverType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resolverTypeAsString}.
     * </p>
     * 
     * @return Required element used in combination with CreateCase to identify the resolver type.
     * @see ResolverType
     */
    public final String resolverTypeAsString() {
        return resolverType;
    }

    /**
     * <p>
     * Required element used in combination with CreateCase to provide a title for the new case.
     * </p>
     * 
     * @return Required element used in combination with CreateCase to provide a title for the new case.
     */
    public final String title() {
        return title;
    }

    /**
     * <p>
     * Required element used in combination with CreateCase
     * </p>
     * <p>
     * to provide a description for the new case.
     * </p>
     * 
     * @return Required element used in combination with CreateCase</p>
     *         <p>
     *         to provide a description for the new case.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Required element used in combination with CreateCase to provide an engagement type for the new cases. Available
     * engagement types include Security Incident | Investigation
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #engagementType}
     * will return {@link EngagementType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #engagementTypeAsString}.
     * </p>
     * 
     * @return Required element used in combination with CreateCase to provide an engagement type for the new cases.
     *         Available engagement types include Security Incident | Investigation
     * @see EngagementType
     */
    public final EngagementType engagementType() {
        return EngagementType.fromValue(engagementType);
    }

    /**
     * <p>
     * Required element used in combination with CreateCase to provide an engagement type for the new cases. Available
     * engagement types include Security Incident | Investigation
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #engagementType}
     * will return {@link EngagementType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #engagementTypeAsString}.
     * </p>
     * 
     * @return Required element used in combination with CreateCase to provide an engagement type for the new cases.
     *         Available engagement types include Security Incident | Investigation
     * @see EngagementType
     */
    public final String engagementTypeAsString() {
        return engagementType;
    }

    /**
     * <p>
     * Required element used in combination with CreateCase to provide an initial start date for the unauthorized
     * activity.
     * </p>
     * 
     * @return Required element used in combination with CreateCase to provide an initial start date for the
     *         unauthorized activity.
     */
    public final Instant reportedIncidentStartDate() {
        return reportedIncidentStartDate;
    }

    /**
     * For responses, this returns true if the service returned a value for the ImpactedAccounts property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasImpactedAccounts() {
        return impactedAccounts != null && !(impactedAccounts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Required element used in combination with CreateCase to provide a list of impacted accounts.
     * </p>
     * <note>
     * <p>
     * AWS account ID's may appear less than 12 characters and need to be zero-prepended. An example would be
     * <code>123123123</code> which is nine digits, and with zero-prepend would be <code>000123123123</code>. Not
     * zero-prepending to 12 digits could result in errors.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasImpactedAccounts} method.
     * </p>
     * 
     * @return Required element used in combination with CreateCase to provide a list of impacted accounts.</p> <note>
     *         <p>
     *         AWS account ID's may appear less than 12 characters and need to be zero-prepended. An example would be
     *         <code>123123123</code> which is nine digits, and with zero-prepend would be <code>000123123123</code>.
     *         Not zero-prepending to 12 digits could result in errors.
     *         </p>
     */
    public final List<String> impactedAccounts() {
        return impactedAccounts;
    }

    /**
     * For responses, this returns true if the service returned a value for the Watchers property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasWatchers() {
        return watchers != null && !(watchers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Required element used in combination with CreateCase to provide a list of entities to receive notifications for
     * case updates.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasWatchers} method.
     * </p>
     * 
     * @return Required element used in combination with CreateCase to provide a list of entities to receive
     *         notifications for case updates.
     */
    public final List<Watcher> watchers() {
        return watchers;
    }

    /**
     * For responses, this returns true if the service returned a value for the ThreatActorIpAddresses property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasThreatActorIpAddresses() {
        return threatActorIpAddresses != null && !(threatActorIpAddresses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An optional element used in combination with CreateCase to provide a list of suspicious internet protocol
     * addresses associated with unauthorized activity.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasThreatActorIpAddresses} method.
     * </p>
     * 
     * @return An optional element used in combination with CreateCase to provide a list of suspicious internet protocol
     *         addresses associated with unauthorized activity.
     */
    public final List<ThreatActorIp> threatActorIpAddresses() {
        return threatActorIpAddresses;
    }

    /**
     * For responses, this returns true if the service returned a value for the ImpactedServices property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasImpactedServices() {
        return impactedServices != null && !(impactedServices instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An optional element used in combination with CreateCase to provide a list of services impacted.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasImpactedServices} method.
     * </p>
     * 
     * @return An optional element used in combination with CreateCase to provide a list of services impacted.
     */
    public final List<String> impactedServices() {
        return impactedServices;
    }

    /**
     * For responses, this returns true if the service returned a value for the ImpactedAwsRegions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasImpactedAwsRegions() {
        return impactedAwsRegions != null && !(impactedAwsRegions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An optional element used in combination with CreateCase to provide a list of impacted regions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasImpactedAwsRegions} method.
     * </p>
     * 
     * @return An optional element used in combination with CreateCase to provide a list of impacted regions.
     */
    public final List<ImpactedAwsRegion> impactedAwsRegions() {
        return impactedAwsRegions;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * An optional element used in combination with CreateCase to add customer specified tags to a case.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return An optional element used in combination with CreateCase to add customer specified tags to a case.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(resolverTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(title());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(engagementTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(reportedIncidentStartDate());
        hashCode = 31 * hashCode + Objects.hashCode(hasImpactedAccounts() ? impactedAccounts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasWatchers() ? watchers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasThreatActorIpAddresses() ? threatActorIpAddresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasImpactedServices() ? impactedServices() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasImpactedAwsRegions() ? impactedAwsRegions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCaseRequest)) {
            return false;
        }
        CreateCaseRequest other = (CreateCaseRequest) obj;
        return Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(resolverTypeAsString(), other.resolverTypeAsString()) && Objects.equals(title(), other.title())
                && Objects.equals(description(), other.description())
                && Objects.equals(engagementTypeAsString(), other.engagementTypeAsString())
                && Objects.equals(reportedIncidentStartDate(), other.reportedIncidentStartDate())
                && hasImpactedAccounts() == other.hasImpactedAccounts()
                && Objects.equals(impactedAccounts(), other.impactedAccounts()) && hasWatchers() == other.hasWatchers()
                && Objects.equals(watchers(), other.watchers())
                && hasThreatActorIpAddresses() == other.hasThreatActorIpAddresses()
                && Objects.equals(threatActorIpAddresses(), other.threatActorIpAddresses())
                && hasImpactedServices() == other.hasImpactedServices()
                && Objects.equals(impactedServices(), other.impactedServices())
                && hasImpactedAwsRegions() == other.hasImpactedAwsRegions()
                && Objects.equals(impactedAwsRegions(), other.impactedAwsRegions()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateCaseRequest").add("ClientToken", clientToken())
                .add("ResolverType", resolverTypeAsString())
                .add("Title", title() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("EngagementType", engagementTypeAsString()).add("ReportedIncidentStartDate", reportedIncidentStartDate())
                .add("ImpactedAccounts", hasImpactedAccounts() ? impactedAccounts() : null)
                .add("Watchers", hasWatchers() ? watchers() : null)
                .add("ThreatActorIpAddresses", hasThreatActorIpAddresses() ? threatActorIpAddresses() : null)
                .add("ImpactedServices", hasImpactedServices() ? impactedServices() : null)
                .add("ImpactedAwsRegions", hasImpactedAwsRegions() ? impactedAwsRegions() : null)
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "resolverType":
            return Optional.ofNullable(clazz.cast(resolverTypeAsString()));
        case "title":
            return Optional.ofNullable(clazz.cast(title()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "engagementType":
            return Optional.ofNullable(clazz.cast(engagementTypeAsString()));
        case "reportedIncidentStartDate":
            return Optional.ofNullable(clazz.cast(reportedIncidentStartDate()));
        case "impactedAccounts":
            return Optional.ofNullable(clazz.cast(impactedAccounts()));
        case "watchers":
            return Optional.ofNullable(clazz.cast(watchers()));
        case "threatActorIpAddresses":
            return Optional.ofNullable(clazz.cast(threatActorIpAddresses()));
        case "impactedServices":
            return Optional.ofNullable(clazz.cast(impactedServices()));
        case "impactedAwsRegions":
            return Optional.ofNullable(clazz.cast(impactedAwsRegions()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("resolverType", RESOLVER_TYPE_FIELD);
        map.put("title", TITLE_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("engagementType", ENGAGEMENT_TYPE_FIELD);
        map.put("reportedIncidentStartDate", REPORTED_INCIDENT_START_DATE_FIELD);
        map.put("impactedAccounts", IMPACTED_ACCOUNTS_FIELD);
        map.put("watchers", WATCHERS_FIELD);
        map.put("threatActorIpAddresses", THREAT_ACTOR_IP_ADDRESSES_FIELD);
        map.put("impactedServices", IMPACTED_SERVICES_FIELD);
        map.put("impactedAwsRegions", IMPACTED_AWS_REGIONS_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateCaseRequest, T> g) {
        return obj -> g.apply((CreateCaseRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SecurityIrRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateCaseRequest> {
        /**
         * <p>
         * <note>
         * <p>
         * The <code>clientToken</code> field is an idempotency key used to ensure that repeated attempts for a single
         * action will be ignored by the server during retries. A caller supplied unique ID (typically a UUID) should be
         * provided.
         * </p>
         * </note></p>
         * 
         * @param clientToken
         *        <p>
         *        The <code>clientToken</code> field is an idempotency key used to ensure that repeated attempts for a
         *        single action will be ignored by the server during retries. A caller supplied unique ID (typically a
         *        UUID) should be provided.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * Required element used in combination with CreateCase to identify the resolver type.
         * </p>
         * 
         * @param resolverType
         *        Required element used in combination with CreateCase to identify the resolver type.
         * @see ResolverType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResolverType
         */
        Builder resolverType(String resolverType);

        /**
         * <p>
         * Required element used in combination with CreateCase to identify the resolver type.
         * </p>
         * 
         * @param resolverType
         *        Required element used in combination with CreateCase to identify the resolver type.
         * @see ResolverType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResolverType
         */
        Builder resolverType(ResolverType resolverType);

        /**
         * <p>
         * Required element used in combination with CreateCase to provide a title for the new case.
         * </p>
         * 
         * @param title
         *        Required element used in combination with CreateCase to provide a title for the new case.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(String title);

        /**
         * <p>
         * Required element used in combination with CreateCase
         * </p>
         * <p>
         * to provide a description for the new case.
         * </p>
         * 
         * @param description
         *        Required element used in combination with CreateCase</p>
         *        <p>
         *        to provide a description for the new case.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Required element used in combination with CreateCase to provide an engagement type for the new cases.
         * Available engagement types include Security Incident | Investigation
         * </p>
         * 
         * @param engagementType
         *        Required element used in combination with CreateCase to provide an engagement type for the new cases.
         *        Available engagement types include Security Incident | Investigation
         * @see EngagementType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EngagementType
         */
        Builder engagementType(String engagementType);

        /**
         * <p>
         * Required element used in combination with CreateCase to provide an engagement type for the new cases.
         * Available engagement types include Security Incident | Investigation
         * </p>
         * 
         * @param engagementType
         *        Required element used in combination with CreateCase to provide an engagement type for the new cases.
         *        Available engagement types include Security Incident | Investigation
         * @see EngagementType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EngagementType
         */
        Builder engagementType(EngagementType engagementType);

        /**
         * <p>
         * Required element used in combination with CreateCase to provide an initial start date for the unauthorized
         * activity.
         * </p>
         * 
         * @param reportedIncidentStartDate
         *        Required element used in combination with CreateCase to provide an initial start date for the
         *        unauthorized activity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reportedIncidentStartDate(Instant reportedIncidentStartDate);

        /**
         * <p>
         * Required element used in combination with CreateCase to provide a list of impacted accounts.
         * </p>
         * <note>
         * <p>
         * AWS account ID's may appear less than 12 characters and need to be zero-prepended. An example would be
         * <code>123123123</code> which is nine digits, and with zero-prepend would be <code>000123123123</code>. Not
         * zero-prepending to 12 digits could result in errors.
         * </p>
         * </note>
         * 
         * @param impactedAccounts
         *        Required element used in combination with CreateCase to provide a list of impacted accounts.</p>
         *        <note>
         *        <p>
         *        AWS account ID's may appear less than 12 characters and need to be zero-prepended. An example would be
         *        <code>123123123</code> which is nine digits, and with zero-prepend would be <code>000123123123</code>.
         *        Not zero-prepending to 12 digits could result in errors.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder impactedAccounts(Collection<String> impactedAccounts);

        /**
         * <p>
         * Required element used in combination with CreateCase to provide a list of impacted accounts.
         * </p>
         * <note>
         * <p>
         * AWS account ID's may appear less than 12 characters and need to be zero-prepended. An example would be
         * <code>123123123</code> which is nine digits, and with zero-prepend would be <code>000123123123</code>. Not
         * zero-prepending to 12 digits could result in errors.
         * </p>
         * </note>
         * 
         * @param impactedAccounts
         *        Required element used in combination with CreateCase to provide a list of impacted accounts.</p>
         *        <note>
         *        <p>
         *        AWS account ID's may appear less than 12 characters and need to be zero-prepended. An example would be
         *        <code>123123123</code> which is nine digits, and with zero-prepend would be <code>000123123123</code>.
         *        Not zero-prepending to 12 digits could result in errors.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder impactedAccounts(String... impactedAccounts);

        /**
         * <p>
         * Required element used in combination with CreateCase to provide a list of entities to receive notifications
         * for case updates.
         * </p>
         * 
         * @param watchers
         *        Required element used in combination with CreateCase to provide a list of entities to receive
         *        notifications for case updates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder watchers(Collection<Watcher> watchers);

        /**
         * <p>
         * Required element used in combination with CreateCase to provide a list of entities to receive notifications
         * for case updates.
         * </p>
         * 
         * @param watchers
         *        Required element used in combination with CreateCase to provide a list of entities to receive
         *        notifications for case updates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder watchers(Watcher... watchers);

        /**
         * <p>
         * Required element used in combination with CreateCase to provide a list of entities to receive notifications
         * for case updates.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityir.model.Watcher.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.securityir.model.Watcher#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityir.model.Watcher.Builder#build()} is called immediately and
         * its result is passed to {@link #watchers(List<Watcher>)}.
         * 
         * @param watchers
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityir.model.Watcher.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #watchers(java.util.Collection<Watcher>)
         */
        Builder watchers(Consumer<Watcher.Builder>... watchers);

        /**
         * <p>
         * An optional element used in combination with CreateCase to provide a list of suspicious internet protocol
         * addresses associated with unauthorized activity.
         * </p>
         * 
         * @param threatActorIpAddresses
         *        An optional element used in combination with CreateCase to provide a list of suspicious internet
         *        protocol addresses associated with unauthorized activity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder threatActorIpAddresses(Collection<ThreatActorIp> threatActorIpAddresses);

        /**
         * <p>
         * An optional element used in combination with CreateCase to provide a list of suspicious internet protocol
         * addresses associated with unauthorized activity.
         * </p>
         * 
         * @param threatActorIpAddresses
         *        An optional element used in combination with CreateCase to provide a list of suspicious internet
         *        protocol addresses associated with unauthorized activity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder threatActorIpAddresses(ThreatActorIp... threatActorIpAddresses);

        /**
         * <p>
         * An optional element used in combination with CreateCase to provide a list of suspicious internet protocol
         * addresses associated with unauthorized activity.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityir.model.ThreatActorIp.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.securityir.model.ThreatActorIp#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityir.model.ThreatActorIp.Builder#build()} is called immediately
         * and its result is passed to {@link #threatActorIpAddresses(List<ThreatActorIp>)}.
         * 
         * @param threatActorIpAddresses
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityir.model.ThreatActorIp.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #threatActorIpAddresses(java.util.Collection<ThreatActorIp>)
         */
        Builder threatActorIpAddresses(Consumer<ThreatActorIp.Builder>... threatActorIpAddresses);

        /**
         * <p>
         * An optional element used in combination with CreateCase to provide a list of services impacted.
         * </p>
         * 
         * @param impactedServices
         *        An optional element used in combination with CreateCase to provide a list of services impacted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder impactedServices(Collection<String> impactedServices);

        /**
         * <p>
         * An optional element used in combination with CreateCase to provide a list of services impacted.
         * </p>
         * 
         * @param impactedServices
         *        An optional element used in combination with CreateCase to provide a list of services impacted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder impactedServices(String... impactedServices);

        /**
         * <p>
         * An optional element used in combination with CreateCase to provide a list of impacted regions.
         * </p>
         * 
         * @param impactedAwsRegions
         *        An optional element used in combination with CreateCase to provide a list of impacted regions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder impactedAwsRegions(Collection<ImpactedAwsRegion> impactedAwsRegions);

        /**
         * <p>
         * An optional element used in combination with CreateCase to provide a list of impacted regions.
         * </p>
         * 
         * @param impactedAwsRegions
         *        An optional element used in combination with CreateCase to provide a list of impacted regions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder impactedAwsRegions(ImpactedAwsRegion... impactedAwsRegions);

        /**
         * <p>
         * An optional element used in combination with CreateCase to provide a list of impacted regions.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityir.model.ImpactedAwsRegion.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.securityir.model.ImpactedAwsRegion#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityir.model.ImpactedAwsRegion.Builder#build()} is called
         * immediately and its result is passed to {@link #impactedAwsRegions(List<ImpactedAwsRegion>)}.
         * 
         * @param impactedAwsRegions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityir.model.ImpactedAwsRegion.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #impactedAwsRegions(java.util.Collection<ImpactedAwsRegion>)
         */
        Builder impactedAwsRegions(Consumer<ImpactedAwsRegion.Builder>... impactedAwsRegions);

        /**
         * <p>
         * An optional element used in combination with CreateCase to add customer specified tags to a case.
         * </p>
         * 
         * @param tags
         *        An optional element used in combination with CreateCase to add customer specified tags to a case.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SecurityIrRequest.BuilderImpl implements Builder {
        private String clientToken;

        private String resolverType;

        private String title;

        private String description;

        private String engagementType;

        private Instant reportedIncidentStartDate;

        private List<String> impactedAccounts = DefaultSdkAutoConstructList.getInstance();

        private List<Watcher> watchers = DefaultSdkAutoConstructList.getInstance();

        private List<ThreatActorIp> threatActorIpAddresses = DefaultSdkAutoConstructList.getInstance();

        private List<String> impactedServices = DefaultSdkAutoConstructList.getInstance();

        private List<ImpactedAwsRegion> impactedAwsRegions = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCaseRequest model) {
            super(model);
            clientToken(model.clientToken);
            resolverType(model.resolverType);
            title(model.title);
            description(model.description);
            engagementType(model.engagementType);
            reportedIncidentStartDate(model.reportedIncidentStartDate);
            impactedAccounts(model.impactedAccounts);
            watchers(model.watchers);
            threatActorIpAddresses(model.threatActorIpAddresses);
            impactedServices(model.impactedServices);
            impactedAwsRegions(model.impactedAwsRegions);
            tags(model.tags);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getResolverType() {
            return resolverType;
        }

        public final void setResolverType(String resolverType) {
            this.resolverType = resolverType;
        }

        @Override
        public final Builder resolverType(String resolverType) {
            this.resolverType = resolverType;
            return this;
        }

        @Override
        public final Builder resolverType(ResolverType resolverType) {
            this.resolverType(resolverType == null ? null : resolverType.toString());
            return this;
        }

        public final String getTitle() {
            return title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getEngagementType() {
            return engagementType;
        }

        public final void setEngagementType(String engagementType) {
            this.engagementType = engagementType;
        }

        @Override
        public final Builder engagementType(String engagementType) {
            this.engagementType = engagementType;
            return this;
        }

        @Override
        public final Builder engagementType(EngagementType engagementType) {
            this.engagementType(engagementType == null ? null : engagementType.toString());
            return this;
        }

        public final Instant getReportedIncidentStartDate() {
            return reportedIncidentStartDate;
        }

        public final void setReportedIncidentStartDate(Instant reportedIncidentStartDate) {
            this.reportedIncidentStartDate = reportedIncidentStartDate;
        }

        @Override
        public final Builder reportedIncidentStartDate(Instant reportedIncidentStartDate) {
            this.reportedIncidentStartDate = reportedIncidentStartDate;
            return this;
        }

        public final Collection<String> getImpactedAccounts() {
            if (impactedAccounts instanceof SdkAutoConstructList) {
                return null;
            }
            return impactedAccounts;
        }

        public final void setImpactedAccounts(Collection<String> impactedAccounts) {
            this.impactedAccounts = ImpactedAccountsCopier.copy(impactedAccounts);
        }

        @Override
        public final Builder impactedAccounts(Collection<String> impactedAccounts) {
            this.impactedAccounts = ImpactedAccountsCopier.copy(impactedAccounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder impactedAccounts(String... impactedAccounts) {
            impactedAccounts(Arrays.asList(impactedAccounts));
            return this;
        }

        public final List<Watcher.Builder> getWatchers() {
            List<Watcher.Builder> result = WatchersCopier.copyToBuilder(this.watchers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWatchers(Collection<Watcher.BuilderImpl> watchers) {
            this.watchers = WatchersCopier.copyFromBuilder(watchers);
        }

        @Override
        public final Builder watchers(Collection<Watcher> watchers) {
            this.watchers = WatchersCopier.copy(watchers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder watchers(Watcher... watchers) {
            watchers(Arrays.asList(watchers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder watchers(Consumer<Watcher.Builder>... watchers) {
            watchers(Stream.of(watchers).map(c -> Watcher.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ThreatActorIp.Builder> getThreatActorIpAddresses() {
            List<ThreatActorIp.Builder> result = ThreatActorIpListCopier.copyToBuilder(this.threatActorIpAddresses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setThreatActorIpAddresses(Collection<ThreatActorIp.BuilderImpl> threatActorIpAddresses) {
            this.threatActorIpAddresses = ThreatActorIpListCopier.copyFromBuilder(threatActorIpAddresses);
        }

        @Override
        public final Builder threatActorIpAddresses(Collection<ThreatActorIp> threatActorIpAddresses) {
            this.threatActorIpAddresses = ThreatActorIpListCopier.copy(threatActorIpAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder threatActorIpAddresses(ThreatActorIp... threatActorIpAddresses) {
            threatActorIpAddresses(Arrays.asList(threatActorIpAddresses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder threatActorIpAddresses(Consumer<ThreatActorIp.Builder>... threatActorIpAddresses) {
            threatActorIpAddresses(Stream.of(threatActorIpAddresses).map(c -> ThreatActorIp.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getImpactedServices() {
            if (impactedServices instanceof SdkAutoConstructList) {
                return null;
            }
            return impactedServices;
        }

        public final void setImpactedServices(Collection<String> impactedServices) {
            this.impactedServices = ImpactedServicesListCopier.copy(impactedServices);
        }

        @Override
        public final Builder impactedServices(Collection<String> impactedServices) {
            this.impactedServices = ImpactedServicesListCopier.copy(impactedServices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder impactedServices(String... impactedServices) {
            impactedServices(Arrays.asList(impactedServices));
            return this;
        }

        public final List<ImpactedAwsRegion.Builder> getImpactedAwsRegions() {
            List<ImpactedAwsRegion.Builder> result = ImpactedAwsRegionListCopier.copyToBuilder(this.impactedAwsRegions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setImpactedAwsRegions(Collection<ImpactedAwsRegion.BuilderImpl> impactedAwsRegions) {
            this.impactedAwsRegions = ImpactedAwsRegionListCopier.copyFromBuilder(impactedAwsRegions);
        }

        @Override
        public final Builder impactedAwsRegions(Collection<ImpactedAwsRegion> impactedAwsRegions) {
            this.impactedAwsRegions = ImpactedAwsRegionListCopier.copy(impactedAwsRegions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder impactedAwsRegions(ImpactedAwsRegion... impactedAwsRegions) {
            impactedAwsRegions(Arrays.asList(impactedAwsRegions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder impactedAwsRegions(Consumer<ImpactedAwsRegion.Builder>... impactedAwsRegions) {
            impactedAwsRegions(Stream.of(impactedAwsRegions).map(c -> ImpactedAwsRegion.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCaseRequest build() {
            return new CreateCaseRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
