/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityir.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum CommunicationType {
    CASE_CREATED("Case Created"),

    CASE_UPDATED("Case Updated"),

    CASE_ACKNOWLEDGED("Case Acknowledged"),

    CASE_CLOSED("Case Closed"),

    CASE_UPDATED_TO_SERVICE_MANAGED("Case Updated To Service Managed"),

    CASE_STATUS_UPDATED("Case Status Updated"),

    CASE_PENDING_CUSTOMER_ACTION_REMINDER("Case Pending Customer Action Reminder"),

    CASE_ATTACHMENT_URL_UPLOADED("Case Attachment Url Uploaded"),

    CASE_COMMENT_ADDED("Case Comment Added"),

    CASE_COMMENT_UPDATED("Case Comment Updated"),

    MEMBERSHIP_CREATED("Membership Created"),

    MEMBERSHIP_UPDATED("Membership Updated"),

    MEMBERSHIP_CANCELLED("Membership Cancelled"),

    REGISTER_DELEGATED_ADMINISTRATOR("Register Delegated Administrator"),

    DEREGISTER_DELEGATED_ADMINISTRATOR("Deregister Delegated Administrator"),

    DISABLE_AWS_SERVICE_ACCESS("Disable AWS Service Access"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CommunicationType> VALUE_MAP = EnumUtils.uniqueIndex(CommunicationType.class,
            CommunicationType::toString);

    private final String value;

    private CommunicationType(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return CommunicationType corresponding to the value
     */
    public static CommunicationType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link CommunicationType}s
     */
    public static Set<CommunicationType> knownValues() {
        Set<CommunicationType> knownValues = EnumSet.allOf(CommunicationType.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
