/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum MalwareType {
    ADWARE("ADWARE"),
    BLENDED_THREAT("BLENDED_THREAT"),
    BOTNET_AGENT("BOTNET_AGENT"),
    COIN_MINER("COIN_MINER"),
    EXPLOIT_KIT("EXPLOIT_KIT"),
    KEYLOGGER("KEYLOGGER"),
    MACRO("MACRO"),
    POTENTIALLY_UNWANTED("POTENTIALLY_UNWANTED"),
    SPYWARE("SPYWARE"),
    RANSOMWARE("RANSOMWARE"),
    REMOTE_ACCESS("REMOTE_ACCESS"),
    ROOTKIT("ROOTKIT"),
    TROJAN("TROJAN"),
    VIRUS("VIRUS"),
    WORM("WORM"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private MalwareType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MalwareType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(MalwareType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MalwareType> knownValues() {
        return Stream.of(MalwareType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

