/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.securityhub.model.ThreatIntelIndicatorCategory;
import software.amazon.awssdk.services.securityhub.model.ThreatIntelIndicatorType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ThreatIntelIndicator
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ThreatIntelIndicator> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ThreatIntelIndicator.getter(ThreatIntelIndicator::typeAsString)).setter(ThreatIntelIndicator.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ThreatIntelIndicator.getter(ThreatIntelIndicator::value)).setter(ThreatIntelIndicator.setter(Builder::value)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()}).build();
    private static final SdkField<String> CATEGORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ThreatIntelIndicator.getter(ThreatIntelIndicator::categoryAsString)).setter(ThreatIntelIndicator.setter(Builder::category)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Category").build()}).build();
    private static final SdkField<String> LAST_OBSERVED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ThreatIntelIndicator.getter(ThreatIntelIndicator::lastObservedAt)).setter(ThreatIntelIndicator.setter(Builder::lastObservedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastObservedAt").build()}).build();
    private static final SdkField<String> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ThreatIntelIndicator.getter(ThreatIntelIndicator::source)).setter(ThreatIntelIndicator.setter(Builder::source)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()}).build();
    private static final SdkField<String> SOURCE_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ThreatIntelIndicator.getter(ThreatIntelIndicator::sourceUrl)).setter(ThreatIntelIndicator.setter(Builder::sourceUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceUrl").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, VALUE_FIELD, CATEGORY_FIELD, LAST_OBSERVED_AT_FIELD, SOURCE_FIELD, SOURCE_URL_FIELD));
    private static final long serialVersionUID = 1L;
    private final String type;
    private final String value;
    private final String category;
    private final String lastObservedAt;
    private final String source;
    private final String sourceUrl;

    private ThreatIntelIndicator(BuilderImpl builder) {
        this.type = builder.type;
        this.value = builder.value;
        this.category = builder.category;
        this.lastObservedAt = builder.lastObservedAt;
        this.source = builder.source;
        this.sourceUrl = builder.sourceUrl;
    }

    public ThreatIntelIndicatorType type() {
        return ThreatIntelIndicatorType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public String value() {
        return this.value;
    }

    public ThreatIntelIndicatorCategory category() {
        return ThreatIntelIndicatorCategory.fromValue(this.category);
    }

    public String categoryAsString() {
        return this.category;
    }

    public String lastObservedAt() {
        return this.lastObservedAt;
    }

    public String source() {
        return this.source;
    }

    public String sourceUrl() {
        return this.sourceUrl;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        hashCode = 31 * hashCode + Objects.hashCode(this.categoryAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastObservedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceUrl());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ThreatIntelIndicator)) {
            return false;
        }
        ThreatIntelIndicator other = (ThreatIntelIndicator)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.value(), other.value()) && Objects.equals(this.categoryAsString(), other.categoryAsString()) && Objects.equals(this.lastObservedAt(), other.lastObservedAt()) && Objects.equals(this.source(), other.source()) && Objects.equals(this.sourceUrl(), other.sourceUrl());
    }

    public String toString() {
        return ToString.builder((String)"ThreatIntelIndicator").add("Type", (Object)this.typeAsString()).add("Value", (Object)this.value()).add("Category", (Object)this.categoryAsString()).add("LastObservedAt", (Object)this.lastObservedAt()).add("Source", (Object)this.source()).add("SourceUrl", (Object)this.sourceUrl()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "Value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
            case "Category": {
                return Optional.ofNullable(clazz.cast(this.categoryAsString()));
            }
            case "LastObservedAt": {
                return Optional.ofNullable(clazz.cast(this.lastObservedAt()));
            }
            case "Source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
            case "SourceUrl": {
                return Optional.ofNullable(clazz.cast(this.sourceUrl()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ThreatIntelIndicator, T> g) {
        return obj -> g.apply((ThreatIntelIndicator)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private String value;
        private String category;
        private String lastObservedAt;
        private String source;
        private String sourceUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(ThreatIntelIndicator model) {
            this.type(model.type);
            this.value(model.value);
            this.category(model.category);
            this.lastObservedAt(model.lastObservedAt);
            this.source(model.source);
            this.sourceUrl(model.sourceUrl);
        }

        public final String getTypeAsString() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ThreatIntelIndicatorType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getValue() {
            return this.value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        public final String getCategoryAsString() {
            return this.category;
        }

        @Override
        public final Builder category(String category) {
            this.category = category;
            return this;
        }

        @Override
        public final Builder category(ThreatIntelIndicatorCategory category) {
            this.category(category.toString());
            return this;
        }

        public final void setCategory(String category) {
            this.category = category;
        }

        public final String getLastObservedAt() {
            return this.lastObservedAt;
        }

        @Override
        public final Builder lastObservedAt(String lastObservedAt) {
            this.lastObservedAt = lastObservedAt;
            return this;
        }

        public final void setLastObservedAt(String lastObservedAt) {
            this.lastObservedAt = lastObservedAt;
        }

        public final String getSource() {
            return this.source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        public final String getSourceUrl() {
            return this.sourceUrl;
        }

        @Override
        public final Builder sourceUrl(String sourceUrl) {
            this.sourceUrl = sourceUrl;
            return this;
        }

        public final void setSourceUrl(String sourceUrl) {
            this.sourceUrl = sourceUrl;
        }

        public ThreatIntelIndicator build() {
            return new ThreatIntelIndicator(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ThreatIntelIndicator> {
        public Builder type(String var1);

        public Builder type(ThreatIntelIndicatorType var1);

        public Builder value(String var1);

        public Builder category(String var1);

        public Builder category(ThreatIntelIndicatorCategory var1);

        public Builder lastObservedAt(String var1);

        public Builder source(String var1);

        public Builder sourceUrl(String var1);
    }
}

