/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.securityhub.model.AwsSecurityFindingFilters;
import software.amazon.awssdk.services.securityhub.model.SecurityHubRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateInsightRequest
extends SecurityHubRequest
implements ToCopyableBuilder<Builder, CreateInsightRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateInsightRequest.getter(CreateInsightRequest::name)).setter(CreateInsightRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<AwsSecurityFindingFilters> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateInsightRequest.getter(CreateInsightRequest::filters)).setter(CreateInsightRequest.setter(Builder::filters)).constructor(AwsSecurityFindingFilters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build()}).build();
    private static final SdkField<String> GROUP_BY_ATTRIBUTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateInsightRequest.getter(CreateInsightRequest::groupByAttribute)).setter(CreateInsightRequest.setter(Builder::groupByAttribute)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupByAttribute").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, FILTERS_FIELD, GROUP_BY_ATTRIBUTE_FIELD));
    private final String name;
    private final AwsSecurityFindingFilters filters;
    private final String groupByAttribute;

    private CreateInsightRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.filters = builder.filters;
        this.groupByAttribute = builder.groupByAttribute;
    }

    public String name() {
        return this.name;
    }

    public AwsSecurityFindingFilters filters() {
        return this.filters;
    }

    public String groupByAttribute() {
        return this.groupByAttribute;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.filters());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupByAttribute());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateInsightRequest)) {
            return false;
        }
        CreateInsightRequest other = (CreateInsightRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.filters(), other.filters()) && Objects.equals(this.groupByAttribute(), other.groupByAttribute());
    }

    public String toString() {
        return ToString.builder((String)"CreateInsightRequest").add("Name", (Object)this.name()).add("Filters", (Object)this.filters()).add("GroupByAttribute", (Object)this.groupByAttribute()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "GroupByAttribute": {
                return Optional.ofNullable(clazz.cast(this.groupByAttribute()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateInsightRequest, T> g) {
        return obj -> g.apply((CreateInsightRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SecurityHubRequest.BuilderImpl
    implements Builder {
        private String name;
        private AwsSecurityFindingFilters filters;
        private String groupByAttribute;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateInsightRequest model) {
            super(model);
            this.name(model.name);
            this.filters(model.filters);
            this.groupByAttribute(model.groupByAttribute);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final AwsSecurityFindingFilters.Builder getFilters() {
            return this.filters != null ? this.filters.toBuilder() : null;
        }

        @Override
        public final Builder filters(AwsSecurityFindingFilters filters) {
            this.filters = filters;
            return this;
        }

        public final void setFilters(AwsSecurityFindingFilters.BuilderImpl filters) {
            this.filters = filters != null ? filters.build() : null;
        }

        public final String getGroupByAttribute() {
            return this.groupByAttribute;
        }

        @Override
        public final Builder groupByAttribute(String groupByAttribute) {
            this.groupByAttribute = groupByAttribute;
            return this;
        }

        public final void setGroupByAttribute(String groupByAttribute) {
            this.groupByAttribute = groupByAttribute;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateInsightRequest build() {
            return new CreateInsightRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SecurityHubRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateInsightRequest> {
        public Builder name(String var1);

        public Builder filters(AwsSecurityFindingFilters var1);

        default public Builder filters(Consumer<AwsSecurityFindingFilters.Builder> filters) {
            return this.filters((AwsSecurityFindingFilters)((AwsSecurityFindingFilters.Builder)AwsSecurityFindingFilters.builder().applyMutation(filters)).build());
        }

        public Builder groupByAttribute(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

