/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum OcsfDateField {
    FINDING_INFO_CREATED_TIME_DT("finding_info.created_time_dt"),
    FINDING_INFO_FIRST_SEEN_TIME_DT("finding_info.first_seen_time_dt"),
    FINDING_INFO_LAST_SEEN_TIME_DT("finding_info.last_seen_time_dt"),
    FINDING_INFO_MODIFIED_TIME_DT("finding_info.modified_time_dt"),
    RESOURCES_IMAGE_CREATED_TIME_DT("resources.image.created_time_dt"),
    RESOURCES_IMAGE_LAST_USED_TIME_DT("resources.image.last_used_time_dt"),
    RESOURCES_MODIFIED_TIME_DT("resources.modified_time_dt"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, OcsfDateField> VALUE_MAP;
    private final String value;

    private OcsfDateField(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static OcsfDateField fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<OcsfDateField> knownValues() {
        EnumSet<OcsfDateField> knownValues = EnumSet.allOf(OcsfDateField.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(OcsfDateField.class, OcsfDateField::toString);
    }
}

