/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.securityhub.model.SecurityHubRequest;
import software.amazon.awssdk.services.securityhub.model.TicketCreationMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateTicketV2Request
extends SecurityHubRequest
implements ToCopyableBuilder<Builder, CreateTicketV2Request> {
    private static final SdkField<String> CONNECTOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectorId").getter(CreateTicketV2Request.getter(CreateTicketV2Request::connectorId)).setter(CreateTicketV2Request.setter(Builder::connectorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectorId").build()}).build();
    private static final SdkField<String> FINDING_METADATA_UID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FindingMetadataUid").getter(CreateTicketV2Request.getter(CreateTicketV2Request::findingMetadataUid)).setter(CreateTicketV2Request.setter(Builder::findingMetadataUid)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FindingMetadataUid").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateTicketV2Request.getter(CreateTicketV2Request::clientToken)).setter(CreateTicketV2Request.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Mode").getter(CreateTicketV2Request.getter(CreateTicketV2Request::modeAsString)).setter(CreateTicketV2Request.setter(Builder::mode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTOR_ID_FIELD, FINDING_METADATA_UID_FIELD, CLIENT_TOKEN_FIELD, MODE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateTicketV2Request.memberNameToFieldInitializer();
    private final String connectorId;
    private final String findingMetadataUid;
    private final String clientToken;
    private final String mode;

    private CreateTicketV2Request(BuilderImpl builder) {
        super(builder);
        this.connectorId = builder.connectorId;
        this.findingMetadataUid = builder.findingMetadataUid;
        this.clientToken = builder.clientToken;
        this.mode = builder.mode;
    }

    public final String connectorId() {
        return this.connectorId;
    }

    public final String findingMetadataUid() {
        return this.findingMetadataUid;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final TicketCreationMode mode() {
        return TicketCreationMode.fromValue(this.mode);
    }

    public final String modeAsString() {
        return this.mode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.connectorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.findingMetadataUid());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.modeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTicketV2Request)) {
            return false;
        }
        CreateTicketV2Request other = (CreateTicketV2Request)((Object)obj);
        return Objects.equals(this.connectorId(), other.connectorId()) && Objects.equals(this.findingMetadataUid(), other.findingMetadataUid()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.modeAsString(), other.modeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CreateTicketV2Request").add("ConnectorId", (Object)this.connectorId()).add("FindingMetadataUid", (Object)this.findingMetadataUid()).add("ClientToken", (Object)this.clientToken()).add("Mode", (Object)this.modeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConnectorId": {
                return Optional.ofNullable(clazz.cast(this.connectorId()));
            }
            case "FindingMetadataUid": {
                return Optional.ofNullable(clazz.cast(this.findingMetadataUid()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "Mode": {
                return Optional.ofNullable(clazz.cast(this.modeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("ConnectorId", CONNECTOR_ID_FIELD);
        map.put("FindingMetadataUid", FINDING_METADATA_UID_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("Mode", MODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateTicketV2Request, T> g) {
        return obj -> g.apply((CreateTicketV2Request)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SecurityHubRequest.BuilderImpl
    implements Builder {
        private String connectorId;
        private String findingMetadataUid;
        private String clientToken;
        private String mode;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTicketV2Request model) {
            super(model);
            this.connectorId(model.connectorId);
            this.findingMetadataUid(model.findingMetadataUid);
            this.clientToken(model.clientToken);
            this.mode(model.mode);
        }

        public final String getConnectorId() {
            return this.connectorId;
        }

        public final void setConnectorId(String connectorId) {
            this.connectorId = connectorId;
        }

        @Override
        public final Builder connectorId(String connectorId) {
            this.connectorId = connectorId;
            return this;
        }

        public final String getFindingMetadataUid() {
            return this.findingMetadataUid;
        }

        public final void setFindingMetadataUid(String findingMetadataUid) {
            this.findingMetadataUid = findingMetadataUid;
        }

        @Override
        public final Builder findingMetadataUid(String findingMetadataUid) {
            this.findingMetadataUid = findingMetadataUid;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getMode() {
            return this.mode;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(TicketCreationMode mode) {
            this.mode(mode == null ? null : mode.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateTicketV2Request build() {
            return new CreateTicketV2Request(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SecurityHubRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateTicketV2Request> {
        public Builder connectorId(String var1);

        public Builder findingMetadataUid(String var1);

        public Builder clientToken(String var1);

        public Builder mode(String var1);

        public Builder mode(TicketCreationMode var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

