/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.securityhub.model.SecurityHubRequest;
import software.amazon.awssdk.services.securityhub.model.StringListCopier;
import software.amazon.awssdk.services.securityhub.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateAggregatorV2Request
extends SecurityHubRequest
implements ToCopyableBuilder<Builder, CreateAggregatorV2Request> {
    private static final SdkField<String> REGION_LINKING_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RegionLinkingMode").getter(CreateAggregatorV2Request.getter(CreateAggregatorV2Request::regionLinkingMode)).setter(CreateAggregatorV2Request.setter(Builder::regionLinkingMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegionLinkingMode").build()}).build();
    private static final SdkField<List<String>> LINKED_REGIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LinkedRegions").getter(CreateAggregatorV2Request.getter(CreateAggregatorV2Request::linkedRegions)).setter(CreateAggregatorV2Request.setter(Builder::linkedRegions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LinkedRegions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(CreateAggregatorV2Request.getter(CreateAggregatorV2Request::tags)).setter(CreateAggregatorV2Request.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateAggregatorV2Request.getter(CreateAggregatorV2Request::clientToken)).setter(CreateAggregatorV2Request.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGION_LINKING_MODE_FIELD, LINKED_REGIONS_FIELD, TAGS_FIELD, CLIENT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateAggregatorV2Request.memberNameToFieldInitializer();
    private final String regionLinkingMode;
    private final List<String> linkedRegions;
    private final Map<String, String> tags;
    private final String clientToken;

    private CreateAggregatorV2Request(BuilderImpl builder) {
        super(builder);
        this.regionLinkingMode = builder.regionLinkingMode;
        this.linkedRegions = builder.linkedRegions;
        this.tags = builder.tags;
        this.clientToken = builder.clientToken;
    }

    public final String regionLinkingMode() {
        return this.regionLinkingMode;
    }

    public final boolean hasLinkedRegions() {
        return this.linkedRegions != null && !(this.linkedRegions instanceof SdkAutoConstructList);
    }

    public final List<String> linkedRegions() {
        return this.linkedRegions;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.regionLinkingMode());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLinkedRegions() ? this.linkedRegions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAggregatorV2Request)) {
            return false;
        }
        CreateAggregatorV2Request other = (CreateAggregatorV2Request)((Object)obj);
        return Objects.equals(this.regionLinkingMode(), other.regionLinkingMode()) && this.hasLinkedRegions() == other.hasLinkedRegions() && Objects.equals(this.linkedRegions(), other.linkedRegions()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"CreateAggregatorV2Request").add("RegionLinkingMode", (Object)this.regionLinkingMode()).add("LinkedRegions", this.hasLinkedRegions() ? this.linkedRegions() : null).add("Tags", this.hasTags() ? this.tags() : null).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RegionLinkingMode": {
                return Optional.ofNullable(clazz.cast(this.regionLinkingMode()));
            }
            case "LinkedRegions": {
                return Optional.ofNullable(clazz.cast(this.linkedRegions()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("RegionLinkingMode", REGION_LINKING_MODE_FIELD);
        map.put("LinkedRegions", LINKED_REGIONS_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateAggregatorV2Request, T> g) {
        return obj -> g.apply((CreateAggregatorV2Request)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SecurityHubRequest.BuilderImpl
    implements Builder {
        private String regionLinkingMode;
        private List<String> linkedRegions = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAggregatorV2Request model) {
            super(model);
            this.regionLinkingMode(model.regionLinkingMode);
            this.linkedRegions(model.linkedRegions);
            this.tags(model.tags);
            this.clientToken(model.clientToken);
        }

        public final String getRegionLinkingMode() {
            return this.regionLinkingMode;
        }

        public final void setRegionLinkingMode(String regionLinkingMode) {
            this.regionLinkingMode = regionLinkingMode;
        }

        @Override
        public final Builder regionLinkingMode(String regionLinkingMode) {
            this.regionLinkingMode = regionLinkingMode;
            return this;
        }

        public final Collection<String> getLinkedRegions() {
            if (this.linkedRegions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.linkedRegions;
        }

        public final void setLinkedRegions(Collection<String> linkedRegions) {
            this.linkedRegions = StringListCopier.copy(linkedRegions);
        }

        @Override
        public final Builder linkedRegions(Collection<String> linkedRegions) {
            this.linkedRegions = StringListCopier.copy(linkedRegions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder linkedRegions(String ... linkedRegions) {
            this.linkedRegions(Arrays.asList(linkedRegions));
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAggregatorV2Request build() {
            return new CreateAggregatorV2Request(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SecurityHubRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateAggregatorV2Request> {
        public Builder regionLinkingMode(String var1);

        public Builder linkedRegions(Collection<String> var1);

        public Builder linkedRegions(String ... var1);

        public Builder tags(Map<String, String> var1);

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

