/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.securityhub.SecurityHubAsyncClient;
import software.amazon.awssdk.services.securityhub.internal.UserAgentUtils;
import software.amazon.awssdk.services.securityhub.model.DescribeStandardsRequest;
import software.amazon.awssdk.services.securityhub.model.DescribeStandardsResponse;
import software.amazon.awssdk.services.securityhub.model.Standard;

public class DescribeStandardsPublisher
implements SdkPublisher<DescribeStandardsResponse> {
    private final SecurityHubAsyncClient client;
    private final DescribeStandardsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeStandardsPublisher(SecurityHubAsyncClient client, DescribeStandardsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeStandardsPublisher(SecurityHubAsyncClient client, DescribeStandardsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeStandardsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeStandardsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Standard> standards() {
        Function<DescribeStandardsResponse, Iterator> getIterator = response -> {
            if (response != null && response.standards() != null) {
                return response.standards().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeStandardsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeStandardsResponseFetcher
    implements AsyncPageFetcher<DescribeStandardsResponse> {
        private DescribeStandardsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeStandardsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeStandardsResponse> nextPage(DescribeStandardsResponse previousPage) {
            if (previousPage == null) {
                return DescribeStandardsPublisher.this.client.describeStandards(DescribeStandardsPublisher.this.firstRequest);
            }
            return DescribeStandardsPublisher.this.client.describeStandards((DescribeStandardsRequest)((Object)DescribeStandardsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

