/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.ProductSubscriptionArnListCopier;
import software.amazon.awssdk.services.securityhub.model.SecurityHubResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListEnabledProductsForImportResponse
extends SecurityHubResponse
implements ToCopyableBuilder<Builder, ListEnabledProductsForImportResponse> {
    private static final SdkField<List<String>> PRODUCT_SUBSCRIPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ProductSubscriptions").getter(ListEnabledProductsForImportResponse.getter(ListEnabledProductsForImportResponse::productSubscriptions)).setter(ListEnabledProductsForImportResponse.setter(Builder::productSubscriptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductSubscriptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListEnabledProductsForImportResponse.getter(ListEnabledProductsForImportResponse::nextToken)).setter(ListEnabledProductsForImportResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRODUCT_SUBSCRIPTIONS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListEnabledProductsForImportResponse.memberNameToFieldInitializer();
    private final List<String> productSubscriptions;
    private final String nextToken;

    private ListEnabledProductsForImportResponse(BuilderImpl builder) {
        super(builder);
        this.productSubscriptions = builder.productSubscriptions;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasProductSubscriptions() {
        return this.productSubscriptions != null && !(this.productSubscriptions instanceof SdkAutoConstructList);
    }

    public final List<String> productSubscriptions() {
        return this.productSubscriptions;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProductSubscriptions() ? this.productSubscriptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEnabledProductsForImportResponse)) {
            return false;
        }
        ListEnabledProductsForImportResponse other = (ListEnabledProductsForImportResponse)((Object)obj);
        return this.hasProductSubscriptions() == other.hasProductSubscriptions() && Objects.equals(this.productSubscriptions(), other.productSubscriptions()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListEnabledProductsForImportResponse").add("ProductSubscriptions", this.hasProductSubscriptions() ? this.productSubscriptions() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProductSubscriptions": {
                return Optional.ofNullable(clazz.cast(this.productSubscriptions()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ProductSubscriptions", PRODUCT_SUBSCRIPTIONS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListEnabledProductsForImportResponse, T> g) {
        return obj -> g.apply((ListEnabledProductsForImportResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SecurityHubResponse.BuilderImpl
    implements Builder {
        private List<String> productSubscriptions = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEnabledProductsForImportResponse model) {
            super(model);
            this.productSubscriptions(model.productSubscriptions);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getProductSubscriptions() {
            if (this.productSubscriptions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.productSubscriptions;
        }

        public final void setProductSubscriptions(Collection<String> productSubscriptions) {
            this.productSubscriptions = ProductSubscriptionArnListCopier.copy(productSubscriptions);
        }

        @Override
        public final Builder productSubscriptions(Collection<String> productSubscriptions) {
            this.productSubscriptions = ProductSubscriptionArnListCopier.copy(productSubscriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productSubscriptions(String ... productSubscriptions) {
            this.productSubscriptions(Arrays.asList(productSubscriptions));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListEnabledProductsForImportResponse build() {
            return new ListEnabledProductsForImportResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SecurityHubResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListEnabledProductsForImportResponse> {
        public Builder productSubscriptions(Collection<String> var1);

        public Builder productSubscriptions(String ... var1);

        public Builder nextToken(String var1);
    }
}

