/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.securityhub.model.FieldMapCopier;
import software.amazon.awssdk.services.securityhub.model.NoteUpdate;
import software.amazon.awssdk.services.securityhub.model.RelatedFinding;
import software.amazon.awssdk.services.securityhub.model.RelatedFindingListCopier;
import software.amazon.awssdk.services.securityhub.model.SeverityUpdate;
import software.amazon.awssdk.services.securityhub.model.TypeListCopier;
import software.amazon.awssdk.services.securityhub.model.VerificationState;
import software.amazon.awssdk.services.securityhub.model.WorkflowUpdate;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AutomationRulesFindingFieldsUpdate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AutomationRulesFindingFieldsUpdate> {
    private static final SdkField<NoteUpdate> NOTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Note").getter(AutomationRulesFindingFieldsUpdate.getter(AutomationRulesFindingFieldsUpdate::note)).setter(AutomationRulesFindingFieldsUpdate.setter(Builder::note)).constructor(NoteUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Note").build()}).build();
    private static final SdkField<SeverityUpdate> SEVERITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Severity").getter(AutomationRulesFindingFieldsUpdate.getter(AutomationRulesFindingFieldsUpdate::severity)).setter(AutomationRulesFindingFieldsUpdate.setter(Builder::severity)).constructor(SeverityUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Severity").build()}).build();
    private static final SdkField<String> VERIFICATION_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VerificationState").getter(AutomationRulesFindingFieldsUpdate.getter(AutomationRulesFindingFieldsUpdate::verificationStateAsString)).setter(AutomationRulesFindingFieldsUpdate.setter(Builder::verificationState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerificationState").build()}).build();
    private static final SdkField<Integer> CONFIDENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Confidence").getter(AutomationRulesFindingFieldsUpdate.getter(AutomationRulesFindingFieldsUpdate::confidence)).setter(AutomationRulesFindingFieldsUpdate.setter(Builder::confidence)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Confidence").build()}).build();
    private static final SdkField<Integer> CRITICALITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Criticality").getter(AutomationRulesFindingFieldsUpdate.getter(AutomationRulesFindingFieldsUpdate::criticality)).setter(AutomationRulesFindingFieldsUpdate.setter(Builder::criticality)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Criticality").build()}).build();
    private static final SdkField<List<String>> TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Types").getter(AutomationRulesFindingFieldsUpdate.getter(AutomationRulesFindingFieldsUpdate::types)).setter(AutomationRulesFindingFieldsUpdate.setter(Builder::types)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Types").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> USER_DEFINED_FIELDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("UserDefinedFields").getter(AutomationRulesFindingFieldsUpdate.getter(AutomationRulesFindingFieldsUpdate::userDefinedFields)).setter(AutomationRulesFindingFieldsUpdate.setter(Builder::userDefinedFields)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserDefinedFields").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<WorkflowUpdate> WORKFLOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Workflow").getter(AutomationRulesFindingFieldsUpdate.getter(AutomationRulesFindingFieldsUpdate::workflow)).setter(AutomationRulesFindingFieldsUpdate.setter(Builder::workflow)).constructor(WorkflowUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Workflow").build()}).build();
    private static final SdkField<List<RelatedFinding>> RELATED_FINDINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RelatedFindings").getter(AutomationRulesFindingFieldsUpdate.getter(AutomationRulesFindingFieldsUpdate::relatedFindings)).setter(AutomationRulesFindingFieldsUpdate.setter(Builder::relatedFindings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelatedFindings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RelatedFinding::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NOTE_FIELD, SEVERITY_FIELD, VERIFICATION_STATE_FIELD, CONFIDENCE_FIELD, CRITICALITY_FIELD, TYPES_FIELD, USER_DEFINED_FIELDS_FIELD, WORKFLOW_FIELD, RELATED_FINDINGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AutomationRulesFindingFieldsUpdate.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final NoteUpdate note;
    private final SeverityUpdate severity;
    private final String verificationState;
    private final Integer confidence;
    private final Integer criticality;
    private final List<String> types;
    private final Map<String, String> userDefinedFields;
    private final WorkflowUpdate workflow;
    private final List<RelatedFinding> relatedFindings;

    private AutomationRulesFindingFieldsUpdate(BuilderImpl builder) {
        this.note = builder.note;
        this.severity = builder.severity;
        this.verificationState = builder.verificationState;
        this.confidence = builder.confidence;
        this.criticality = builder.criticality;
        this.types = builder.types;
        this.userDefinedFields = builder.userDefinedFields;
        this.workflow = builder.workflow;
        this.relatedFindings = builder.relatedFindings;
    }

    public final NoteUpdate note() {
        return this.note;
    }

    public final SeverityUpdate severity() {
        return this.severity;
    }

    public final VerificationState verificationState() {
        return VerificationState.fromValue(this.verificationState);
    }

    public final String verificationStateAsString() {
        return this.verificationState;
    }

    public final Integer confidence() {
        return this.confidence;
    }

    public final Integer criticality() {
        return this.criticality;
    }

    public final boolean hasTypes() {
        return this.types != null && !(this.types instanceof SdkAutoConstructList);
    }

    public final List<String> types() {
        return this.types;
    }

    public final boolean hasUserDefinedFields() {
        return this.userDefinedFields != null && !(this.userDefinedFields instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> userDefinedFields() {
        return this.userDefinedFields;
    }

    public final WorkflowUpdate workflow() {
        return this.workflow;
    }

    public final boolean hasRelatedFindings() {
        return this.relatedFindings != null && !(this.relatedFindings instanceof SdkAutoConstructList);
    }

    public final List<RelatedFinding> relatedFindings() {
        return this.relatedFindings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.note());
        hashCode = 31 * hashCode + Objects.hashCode(this.severity());
        hashCode = 31 * hashCode + Objects.hashCode(this.verificationStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.confidence());
        hashCode = 31 * hashCode + Objects.hashCode(this.criticality());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTypes() ? this.types() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUserDefinedFields() ? this.userDefinedFields() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.workflow());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRelatedFindings() ? this.relatedFindings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutomationRulesFindingFieldsUpdate)) {
            return false;
        }
        AutomationRulesFindingFieldsUpdate other = (AutomationRulesFindingFieldsUpdate)obj;
        return Objects.equals(this.note(), other.note()) && Objects.equals(this.severity(), other.severity()) && Objects.equals(this.verificationStateAsString(), other.verificationStateAsString()) && Objects.equals(this.confidence(), other.confidence()) && Objects.equals(this.criticality(), other.criticality()) && this.hasTypes() == other.hasTypes() && Objects.equals(this.types(), other.types()) && this.hasUserDefinedFields() == other.hasUserDefinedFields() && Objects.equals(this.userDefinedFields(), other.userDefinedFields()) && Objects.equals(this.workflow(), other.workflow()) && this.hasRelatedFindings() == other.hasRelatedFindings() && Objects.equals(this.relatedFindings(), other.relatedFindings());
    }

    public final String toString() {
        return ToString.builder((String)"AutomationRulesFindingFieldsUpdate").add("Note", (Object)this.note()).add("Severity", (Object)this.severity()).add("VerificationState", (Object)this.verificationStateAsString()).add("Confidence", (Object)this.confidence()).add("Criticality", (Object)this.criticality()).add("Types", this.hasTypes() ? this.types() : null).add("UserDefinedFields", this.hasUserDefinedFields() ? this.userDefinedFields() : null).add("Workflow", (Object)this.workflow()).add("RelatedFindings", this.hasRelatedFindings() ? this.relatedFindings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Note": {
                return Optional.ofNullable(clazz.cast(this.note()));
            }
            case "Severity": {
                return Optional.ofNullable(clazz.cast(this.severity()));
            }
            case "VerificationState": {
                return Optional.ofNullable(clazz.cast(this.verificationStateAsString()));
            }
            case "Confidence": {
                return Optional.ofNullable(clazz.cast(this.confidence()));
            }
            case "Criticality": {
                return Optional.ofNullable(clazz.cast(this.criticality()));
            }
            case "Types": {
                return Optional.ofNullable(clazz.cast(this.types()));
            }
            case "UserDefinedFields": {
                return Optional.ofNullable(clazz.cast(this.userDefinedFields()));
            }
            case "Workflow": {
                return Optional.ofNullable(clazz.cast(this.workflow()));
            }
            case "RelatedFindings": {
                return Optional.ofNullable(clazz.cast(this.relatedFindings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Note", NOTE_FIELD);
        map.put("Severity", SEVERITY_FIELD);
        map.put("VerificationState", VERIFICATION_STATE_FIELD);
        map.put("Confidence", CONFIDENCE_FIELD);
        map.put("Criticality", CRITICALITY_FIELD);
        map.put("Types", TYPES_FIELD);
        map.put("UserDefinedFields", USER_DEFINED_FIELDS_FIELD);
        map.put("Workflow", WORKFLOW_FIELD);
        map.put("RelatedFindings", RELATED_FINDINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutomationRulesFindingFieldsUpdate, T> g) {
        return obj -> g.apply((AutomationRulesFindingFieldsUpdate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private NoteUpdate note;
        private SeverityUpdate severity;
        private String verificationState;
        private Integer confidence;
        private Integer criticality;
        private List<String> types = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> userDefinedFields = DefaultSdkAutoConstructMap.getInstance();
        private WorkflowUpdate workflow;
        private List<RelatedFinding> relatedFindings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AutomationRulesFindingFieldsUpdate model) {
            this.note(model.note);
            this.severity(model.severity);
            this.verificationState(model.verificationState);
            this.confidence(model.confidence);
            this.criticality(model.criticality);
            this.types(model.types);
            this.userDefinedFields(model.userDefinedFields);
            this.workflow(model.workflow);
            this.relatedFindings(model.relatedFindings);
        }

        public final NoteUpdate.Builder getNote() {
            return this.note != null ? this.note.toBuilder() : null;
        }

        public final void setNote(NoteUpdate.BuilderImpl note) {
            this.note = note != null ? note.build() : null;
        }

        @Override
        public final Builder note(NoteUpdate note) {
            this.note = note;
            return this;
        }

        public final SeverityUpdate.Builder getSeverity() {
            return this.severity != null ? this.severity.toBuilder() : null;
        }

        public final void setSeverity(SeverityUpdate.BuilderImpl severity) {
            this.severity = severity != null ? severity.build() : null;
        }

        @Override
        public final Builder severity(SeverityUpdate severity) {
            this.severity = severity;
            return this;
        }

        public final String getVerificationState() {
            return this.verificationState;
        }

        public final void setVerificationState(String verificationState) {
            this.verificationState = verificationState;
        }

        @Override
        public final Builder verificationState(String verificationState) {
            this.verificationState = verificationState;
            return this;
        }

        @Override
        public final Builder verificationState(VerificationState verificationState) {
            this.verificationState(verificationState == null ? null : verificationState.toString());
            return this;
        }

        public final Integer getConfidence() {
            return this.confidence;
        }

        public final void setConfidence(Integer confidence) {
            this.confidence = confidence;
        }

        @Override
        public final Builder confidence(Integer confidence) {
            this.confidence = confidence;
            return this;
        }

        public final Integer getCriticality() {
            return this.criticality;
        }

        public final void setCriticality(Integer criticality) {
            this.criticality = criticality;
        }

        @Override
        public final Builder criticality(Integer criticality) {
            this.criticality = criticality;
            return this;
        }

        public final Collection<String> getTypes() {
            if (this.types instanceof SdkAutoConstructList) {
                return null;
            }
            return this.types;
        }

        public final void setTypes(Collection<String> types) {
            this.types = TypeListCopier.copy(types);
        }

        @Override
        public final Builder types(Collection<String> types) {
            this.types = TypeListCopier.copy(types);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder types(String ... types) {
            this.types(Arrays.asList(types));
            return this;
        }

        public final Map<String, String> getUserDefinedFields() {
            if (this.userDefinedFields instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.userDefinedFields;
        }

        public final void setUserDefinedFields(Map<String, String> userDefinedFields) {
            this.userDefinedFields = FieldMapCopier.copy(userDefinedFields);
        }

        @Override
        public final Builder userDefinedFields(Map<String, String> userDefinedFields) {
            this.userDefinedFields = FieldMapCopier.copy(userDefinedFields);
            return this;
        }

        public final WorkflowUpdate.Builder getWorkflow() {
            return this.workflow != null ? this.workflow.toBuilder() : null;
        }

        public final void setWorkflow(WorkflowUpdate.BuilderImpl workflow) {
            this.workflow = workflow != null ? workflow.build() : null;
        }

        @Override
        public final Builder workflow(WorkflowUpdate workflow) {
            this.workflow = workflow;
            return this;
        }

        public final List<RelatedFinding.Builder> getRelatedFindings() {
            List<RelatedFinding.Builder> result = RelatedFindingListCopier.copyToBuilder(this.relatedFindings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRelatedFindings(Collection<RelatedFinding.BuilderImpl> relatedFindings) {
            this.relatedFindings = RelatedFindingListCopier.copyFromBuilder(relatedFindings);
        }

        @Override
        public final Builder relatedFindings(Collection<RelatedFinding> relatedFindings) {
            this.relatedFindings = RelatedFindingListCopier.copy(relatedFindings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relatedFindings(RelatedFinding ... relatedFindings) {
            this.relatedFindings(Arrays.asList(relatedFindings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relatedFindings(Consumer<RelatedFinding.Builder> ... relatedFindings) {
            this.relatedFindings(Stream.of(relatedFindings).map(c -> (RelatedFinding)((RelatedFinding.Builder)RelatedFinding.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public AutomationRulesFindingFieldsUpdate build() {
            return new AutomationRulesFindingFieldsUpdate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AutomationRulesFindingFieldsUpdate> {
        public Builder note(NoteUpdate var1);

        default public Builder note(Consumer<NoteUpdate.Builder> note) {
            return this.note((NoteUpdate)((NoteUpdate.Builder)NoteUpdate.builder().applyMutation(note)).build());
        }

        public Builder severity(SeverityUpdate var1);

        default public Builder severity(Consumer<SeverityUpdate.Builder> severity) {
            return this.severity((SeverityUpdate)((SeverityUpdate.Builder)SeverityUpdate.builder().applyMutation(severity)).build());
        }

        public Builder verificationState(String var1);

        public Builder verificationState(VerificationState var1);

        public Builder confidence(Integer var1);

        public Builder criticality(Integer var1);

        public Builder types(Collection<String> var1);

        public Builder types(String ... var1);

        public Builder userDefinedFields(Map<String, String> var1);

        public Builder workflow(WorkflowUpdate var1);

        default public Builder workflow(Consumer<WorkflowUpdate.Builder> workflow) {
            return this.workflow((WorkflowUpdate)((WorkflowUpdate.Builder)WorkflowUpdate.builder().applyMutation(workflow)).build());
        }

        public Builder relatedFindings(Collection<RelatedFinding> var1);

        public Builder relatedFindings(RelatedFinding ... var1);

        public Builder relatedFindings(Consumer<RelatedFinding.Builder> ... var1);
    }
}

